/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class DimensionBase
extends OlapElementBase
implements Dimension {
    protected final String name;
    protected final String uniqueName;
    protected final String description;
    protected final int globalOrdinal;
    protected Hierarchy[] hierarchies;
    protected DimensionType dimensionType;

    protected DimensionBase(String name, int globalOrdinal, DimensionType dimensionType) {
        this.name = name;
        this.uniqueName = Util.makeFqName(name);
        this.description = null;
        this.globalOrdinal = globalOrdinal;
        this.dimensionType = dimensionType;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    public Dimension getDimension() {
        return this;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxDimensionName.str(this.getUniqueName());
    }

    public boolean isMeasures() {
        return this.getUniqueName().equals("[Measures]");
    }

    public boolean usesDimension(Dimension dimension) {
        return dimension == this;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return this.lookupChild(schemaReader, s, MatchType.EXACT);
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s, MatchType matchType) {
        OlapElement oeLevel;
        OlapElement oe = this.lookupHierarchy(s);
        if ((oe == null || oe.getName().equalsIgnoreCase(this.getName())) && (oeLevel = this.getHierarchy().lookupChild(schemaReader, s, matchType)) != null) {
            oe = oeLevel;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("DimensionBase.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=" + oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    private Hierarchy lookupHierarchy(String s) {
        Hierarchy[] arr$ = this.hierarchies;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Hierarchy hierarchy = arr$[i$];
            if (!hierarchy.getName().equalsIgnoreCase(s)) continue;
            return hierarchy;
        }
        return null;
    }
}

