/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ParameterCompilable;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.QueryPrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Parameter;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ParameterExpr
extends ExpBase {
    private Parameter parameter;

    public ParameterExpr(Parameter parameter) {
        this.parameter = parameter;
    }

    public Type getType() {
        return this.parameter.getType();
    }

    public int getCategory() {
        return TypeUtil.typeToCategory(this.parameter.getType());
    }

    public Exp accept(Validator validator) {
        String parameterName = this.parameter.getName();
        Parameter p = validator.getQuery().getSchemaReader(false).getParameter(parameterName);
        this.parameter = p == null ? validator.createOrLookupParam(true, this.parameter.getName(), this.parameter.getType(), this.parameter.getDefaultExp(), this.parameter.getDescription()) : p;
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return ((ParameterCompilable)this.parameter).compile(compiler);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    public ParameterExpr clone() {
        return new ParameterExpr(this.parameter);
    }

    public void unparse(PrintWriter pw) {
        boolean def = pw instanceof QueryPrintWriter && this.parameter.getScope() == Parameter.Scope.Statement ? ((QueryPrintWriter)pw).parameters.add(this.parameter) : false;
        String name = this.parameter.getName();
        Type type = this.parameter.getType();
        int category = TypeUtil.typeToCategory(type);
        if (def) {
            pw.print("Parameter(" + Util.quoteForMdx(name) + ", ");
            switch (category) {
                case 7: 
                case 9: {
                    pw.print(Category.instance.getName(category).toUpperCase());
                    break;
                }
                case 6: {
                    String memberName = type.getLevel() != null ? type.getLevel().getUniqueName() : (type.getHierarchy() != null ? type.getHierarchy().getUniqueName() : type.getDimension().getUniqueName());
                    pw.print(memberName);
                    break;
                }
                default: {
                    throw Category.instance.badValue(category);
                }
            }
            pw.print(", ");
            Object value = this.parameter.getValue();
            if (value == null) {
                this.parameter.getDefaultExp().unparse(pw);
            } else if (value instanceof String) {
                String s = (String)value;
                pw.print(Util.quoteForMdx(s));
            } else {
                pw.print(value);
            }
            String description = this.parameter.getDescription();
            if (description != null) {
                pw.print(", " + Util.quoteForMdx(description));
            }
            pw.print(")");
        } else {
            pw.print("ParamRef(" + Util.quoteForMdx(name) + ")");
        }
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParameterExpr)) {
            return false;
        }
        ParameterExpr that = (ParameterExpr)other;
        return this.parameter == that.parameter;
    }

    public boolean isModifiable() {
        return true;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public Exp clone() {
        return this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

