/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MemberExpr
extends ExpBase
implements Exp {
    private final Member member;

    public MemberExpr(Member member) {
        Util.assertPrecondition(member != null, "member != null");
        this.member = member;
    }

    public Member getMember() {
        return this.member;
    }

    public String toString() {
        return this.member.getUniqueName();
    }

    public Type getType() {
        return MemberType.forMember(this.member);
    }

    public MemberExpr clone() {
        return new MemberExpr(this.member);
    }

    public int getCategory() {
        return 6;
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return ConstantCalc.constantMember(this.member);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    public Exp clone() {
        return this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

