/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import com.rc.retroweaver.runtime.Autobox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import mondrian.gui.JTreeUpdater;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaPropertyCellEditor;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.gui.SchemaTreeCellRenderer;
import mondrian.gui.SchemaTreeModel;
import mondrian.olap.MondrianDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMUtil;

public class SchemaExplorer
extends JPanel
implements TreeSelectionListener,
CellEditorListener {
    private MondrianDef.Schema schema;
    private SchemaTreeModel model;
    private SchemaTreeCellRenderer renderer;
    private File schemaFile;
    private JTreeUpdater updater;
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    public static final String[] DEF_DEFAULT = new String[0];
    public static final String[] DEF_VIRTUAL_CUBE = new String[]{"name"};
    public static final String[] DEF_VIRTUAL_CUBE_MEASURE = new String[]{"name", "cubeName"};
    public static final String[] DEF_VIRTUAL_CUBE_DIMENSION = new String[]{"cubeName"};
    public static final String[] DEF_VIEW = new String[]{"alias"};
    public static final String[] DEF_TABLE = new String[]{"name", "alias", "schema"};
    public static final String[] DEF_RELATION = new String[]{"name"};
    public static final String[] DEF_SQL = new String[]{"cdata", "dialect"};
    public static final String[] DEF_SCHEMA = new String[0];
    public static final String[] DEF_PROPERTY = new String[]{"name", "column", "type"};
    public static final String[] DEF_PARAMETER = new String[]{"name", "value"};
    public static final String[] DEF_MEASURE = new String[]{"name", "aggregator", "column", "formatString"};
    public static final String[] DEF_LEVEL = new String[]{"name", "column", "nameExp", "ordinalColumn", "ordinalExp", "table", "type", "uniqueMembers"};
    public static final String[] DEF_JOIN = new String[]{"left", "leftAlias", "leftKey", "right", "rightAlias", "rightKey"};
    public static final String[] DEF_HIERARCHY = new String[]{"hasAll", "defaultMember", "memberReaderClass", "primaryKey", "primaryKeyTable", "relation"};
    public static final String[] DEF_EXPRESSION_VIEW = new String[0];
    public static final String[] DEF_DIMENSION_USAGE = new String[]{"name", "foreignKey", "source"};
    public static final String[] DEF_DIMENSION = new String[]{"name", "foreignKey"};
    public static final String[] DEF_CUBE = new String[]{"name", "fact"};
    public static final String[] DEF_COLUMN = new String[]{"name", "table"};
    private static final String LBL_COLUMN = "Column";
    private static final String LBL_CUBE = "Cube";
    private static final String LBL_DIMENSION = "Dimension";
    private static final String LBL_DIMENSION_USAGE = "Dimension Usage";
    private static final String LBL_EXPRESSION_VIEW = "Expression View";
    private static final String LBL_HIERARCHY = "Hierarchy";
    private static final String LBL_JOIN = "Join";
    private static final String LBL_LEVEL = "Level";
    private static final String LBL_MEASURE = "Measure";
    private static final String LBL_PARAMETER = "Parameter";
    private static final String LBL_PROPERTY = "Property";
    private static final String LBL_SCHEMA = "Schema";
    private static final String LBL_SQL = "SQL";
    private static final String LBL_TABLE = "Table";
    private static final String LBL_VIEW = "View";
    private static final String LBL_VIRTUAL_CUBE = "Virtual Cube";
    private static final String LBL_VIRTUAL_CUBE_DIMENSION = "Virtual Cube Dimension";
    private static final String LBL_VIRTUAL_CUBE_MEASURE = "Virtual Cube Measure";
    private static final String LBL_UNKNOWN_TYPE = "Unknown Type";
    private AbstractAction addCube;
    private AbstractAction addDimension;
    private AbstractAction addMeasure;
    private AbstractAction addLevel;
    private AbstractAction addProperty;
    private JTable propertyTable;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JButton addLevelButton;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JButton addPropertyButton;
    private JButton pasteButton;
    private JLabel targetLabel;
    private JTree tree;
    private JSplitPane jSplitPane1;
    private JButton addDimensionButton;
    private JButton cutButton;
    private JButton addMeasureButton;
    private JButton addCubeButton;
    private JButton copyButton;
    private JToolBar jToolBar1;
    private JPopupMenu jPopupMenu;
    private static final /* synthetic */ Class class$java$lang$Object;

    public SchemaExplorer() {
        this.initComponents();
    }

    public SchemaExplorer(File f) {
        this();
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            this.schemaFile = f;
            this.schema = new MondrianDef.Schema(xmlParser.parse(this.schemaFile.toURL()));
            this.renderer = new SchemaTreeCellRenderer();
            this.model = new SchemaTreeModel(this.schema);
            this.tree.setModel(this.model);
            this.tree.setCellRenderer(this.renderer);
            this.tree.addTreeSelectionListener(this);
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor();
            spce.addCellEditorListener(this);
            this.propertyTable.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = SchemaExplorer.class$("java.lang.Object")) : class$java$lang$Object, spce);
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer();
            this.propertyTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SchemaExplorer.class$("java.lang.Object")) : class$java$lang$Object, spcr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.propertyTable = new JTable();
        this.targetLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jToolBar1 = new JToolBar();
        this.addCubeButton = new JButton();
        this.addDimensionButton = new JButton();
        this.addMeasureButton = new JButton();
        this.addLevelButton = new JButton();
        this.addPropertyButton = new JButton();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel1.setLayout(new BorderLayout());
        this.propertyTable.setModel(new DefaultTableModel(new Object[0][], new String[]{LBL_PROPERTY, "Value"}){
            Class[] types;
            boolean[] canEdit;
            private static final /* synthetic */ Class class$java$lang$String;
            private static final /* synthetic */ Class class$java$lang$Object;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = 1.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = 1.class$("java.lang.Object")) : class$java$lang$Object};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        });
        this.jScrollPane2.setViewportView(this.propertyTable);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.targetLabel.setFont(new Font("Dialog", 1, 14));
        this.targetLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.targetLabel.setHorizontalAlignment(0);
        this.targetLabel.setText(LBL_SCHEMA);
        this.targetLabel.setBorder(new EtchedBorder());
        this.jPanel1.add((Component)this.targetLabel, "North");
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.tree);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.addCube = new AbstractAction("Add cube"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addCube(e);
            }
        };
        this.addDimension = new AbstractAction("Add Dimension"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addDimension(e);
            }
        };
        this.addMeasure = new AbstractAction("Add Measure"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addMeasure(e);
            }
        };
        this.addLevel = new AbstractAction("Add Level"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addLevel(e);
            }
        };
        this.addProperty = new AbstractAction("Add Property"){

            public void actionPerformed(ActionEvent e) {
                SchemaExplorer.this.addProperty(e);
            }
        };
        ResourceBundle resources = ResourceBundle.getBundle("mondrian.gui.resources.gui");
        this.addCubeButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addCube"))));
        this.addCubeButton.setToolTipText("Add Cube");
        this.addCubeButton.addActionListener(this.addCube);
        this.addDimensionButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addDimension"))));
        this.addDimensionButton.setToolTipText("Add Dimension");
        this.addDimensionButton.addActionListener(this.addDimension);
        this.addMeasureButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addMeasure"))));
        this.addMeasureButton.setToolTipText("Add Measure");
        this.addMeasureButton.addActionListener(this.addMeasure);
        this.addLevelButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addLevel"))));
        this.addLevelButton.setToolTipText("Add Level");
        this.addLevelButton.addActionListener(this.addLevel);
        this.addPropertyButton.setIcon(new ImageIcon(this.myClassLoader.getResource(resources.getString("addProperty"))));
        this.addPropertyButton.setToolTipText("Add Property");
        this.addPropertyButton.addActionListener(this.addProperty);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut24.gif")));
        this.cutButton.setToolTipText("Cut");
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy24.gif")));
        this.copyButton.setToolTipText("Copy");
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste24.gif")));
        this.pasteButton.setToolTipText("Paste");
        this.jToolBar1.add(this.addCubeButton);
        this.jToolBar1.add(this.addDimensionButton);
        this.jToolBar1.add(this.addMeasureButton);
        this.jToolBar1.add(this.addLevelButton);
        this.jToolBar1.add(this.addPropertyButton);
        this.jToolBar1.add(this.cutButton);
        this.jToolBar1.add(this.copyButton);
        this.jToolBar1.add(this.pasteButton);
        this.jPopupMenu = new JPopupMenu();
        this.tree.addMouseListener(new PopupTrigger());
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jToolBar1, "North");
        this.updater = new JTreeUpdater(this.tree);
    }

    protected void addCube(ActionEvent evt) {
        MondrianDef.Schema schema = (MondrianDef.Schema)((Object)this.tree.getModel().getRoot());
        MondrianDef.Cube cube = new MondrianDef.Cube();
        cube.name = "New Cube " + schema.cubes.length;
        cube.dimensions = new MondrianDef.Dimension[0];
        cube.measures = new MondrianDef.Measure[0];
        cube.fact = new MondrianDef.Table();
        MondrianDef.Cube[] temp = schema.cubes;
        schema.cubes = new MondrianDef.Cube[temp.length + 1];
        for (int _i = 0; _i < temp.length; ++_i) {
            schema.cubes[_i] = temp[_i];
        }
        schema.cubes[schema.cubes.length - 1] = cube;
        this.refreshTree(this.tree.getSelectionPath());
    }

    private void refreshTree(TreePath path) {
        this.updater.update();
    }

    protected void addMeasure(ActionEvent evt) {
        Object path = this.tree.getSelectionPath().getLastPathComponent();
        if (!(path instanceof MondrianDef.Cube)) {
            return;
        }
        MondrianDef.Cube cube = (MondrianDef.Cube)((Object)path);
        MondrianDef.Measure measure = new MondrianDef.Measure();
        measure.name = "New Measure " + cube.measures.length;
        MondrianDef.Measure[] temp = cube.measures;
        cube.measures = new MondrianDef.Measure[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.measures[i] = temp[i];
        }
        cube.measures[cube.measures.length - 1] = measure;
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addDimension(ActionEvent evt) {
        Object path = this.tree.getSelectionPath().getLastPathComponent();
        if (!(path instanceof MondrianDef.Cube)) {
            return;
        }
        MondrianDef.Cube cube = (MondrianDef.Cube)((Object)path);
        MondrianDef.Dimension dimension = new MondrianDef.Dimension();
        dimension.name = "New Dimension " + cube.dimensions.length;
        dimension.hierarchies = new MondrianDef.Hierarchy[1];
        dimension.hierarchies[0] = new MondrianDef.Hierarchy();
        dimension.hierarchies[0].hasAll = Autobox.valueOf((boolean)false);
        dimension.hierarchies[0].levels = new MondrianDef.Level[0];
        dimension.hierarchies[0].memberReaderParameters = new MondrianDef.MemberReaderParameter[0];
        dimension.hierarchies[0].relation = new MondrianDef.Join();
        MondrianDef.CubeDimension[] temp = cube.dimensions;
        cube.dimensions = new MondrianDef.CubeDimension[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            cube.dimensions[i] = temp[i];
        }
        cube.dimensions[cube.dimensions.length - 1] = dimension;
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addLevel(ActionEvent evt) {
        Object path = this.tree.getSelectionPath().getLastPathComponent();
        if (!(path instanceof MondrianDef.Hierarchy)) {
            return;
        }
        MondrianDef.Hierarchy hierarchy = (MondrianDef.Hierarchy)((Object)path);
        MondrianDef.Level level = new MondrianDef.Level();
        level.uniqueMembers = Autobox.valueOf((boolean)false);
        level.name = "New Level " + hierarchy.levels.length;
        level.properties = new MondrianDef.Property[0];
        level.nameExp = new MondrianDef.NameExpression();
        level.nameExp.expressions = new MondrianDef.SQL[1];
        level.nameExp.expressions[0] = new MondrianDef.SQL();
        level.ordinalExp = new MondrianDef.OrdinalExpression();
        level.ordinalExp.expressions = new MondrianDef.SQL[1];
        level.ordinalExp.expressions[0] = new MondrianDef.SQL();
        MondrianDef.Level[] temp = hierarchy.levels;
        hierarchy.levels = new MondrianDef.Level[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            hierarchy.levels[i] = temp[i];
        }
        hierarchy.levels[hierarchy.levels.length - 1] = level;
        this.refreshTree(this.tree.getSelectionPath());
    }

    protected void addProperty(ActionEvent evt) {
        Object path = this.tree.getSelectionPath().getLastPathComponent();
        if (!(path instanceof MondrianDef.Level)) {
            return;
        }
        MondrianDef.Level level = (MondrianDef.Level)((Object)path);
        MondrianDef.Property property = new MondrianDef.Property();
        property.name = "New Property " + level.properties.length;
        MondrianDef.Property[] temp = level.properties;
        level.properties = new MondrianDef.Property[temp.length + 1];
        for (int i = 0; i < temp.length; ++i) {
            level.properties[i] = temp[i];
        }
        level.properties[level.properties.length - 1] = property;
        this.refreshTree(this.tree.getSelectionPath());
    }

    public MondrianDef.Schema getSchema() {
        return this.schema;
    }

    public File getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(File f) {
        this.schemaFile = f;
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object o = e.getPath().getLastPathComponent();
        String[] pNames = DEF_DEFAULT;
        if (o instanceof MondrianDef.Column) {
            pNames = DEF_COLUMN;
            this.targetLabel.setText(LBL_COLUMN);
        } else if (o instanceof MondrianDef.Cube) {
            pNames = DEF_CUBE;
            this.targetLabel.setText(LBL_CUBE);
        } else if (o instanceof MondrianDef.Dimension) {
            pNames = DEF_DIMENSION;
            this.targetLabel.setText(LBL_DIMENSION);
        } else if (o instanceof MondrianDef.DimensionUsage) {
            pNames = DEF_DIMENSION_USAGE;
            this.targetLabel.setText(LBL_DIMENSION_USAGE);
        } else if (o instanceof MondrianDef.ExpressionView) {
            pNames = DEF_EXPRESSION_VIEW;
            this.targetLabel.setText(LBL_EXPRESSION_VIEW);
        } else if (o instanceof MondrianDef.Hierarchy) {
            pNames = DEF_HIERARCHY;
            this.targetLabel.setText(LBL_HIERARCHY);
        } else if (o instanceof MondrianDef.Join) {
            pNames = DEF_JOIN;
            this.targetLabel.setText(LBL_JOIN);
        } else if (o instanceof MondrianDef.Level) {
            pNames = DEF_LEVEL;
            this.targetLabel.setText(LBL_LEVEL);
        } else if (o instanceof MondrianDef.Measure) {
            pNames = DEF_MEASURE;
            this.targetLabel.setText(LBL_MEASURE);
        } else if (o instanceof MondrianDef.MemberReaderParameter) {
            pNames = DEF_PARAMETER;
            this.targetLabel.setText(LBL_PARAMETER);
        } else if (o instanceof MondrianDef.Property) {
            pNames = DEF_PROPERTY;
            this.targetLabel.setText(LBL_PROPERTY);
        } else if (o instanceof MondrianDef.Schema) {
            pNames = DEF_SCHEMA;
            this.targetLabel.setText(LBL_SCHEMA);
        } else if (o instanceof MondrianDef.SQL) {
            pNames = DEF_SQL;
            this.targetLabel.setText(LBL_SQL);
        } else if (o instanceof MondrianDef.Table) {
            pNames = DEF_TABLE;
            this.targetLabel.setText(LBL_TABLE);
        } else if (o instanceof MondrianDef.View) {
            pNames = DEF_VIEW;
            this.targetLabel.setText(LBL_VIEW);
        } else if (o instanceof MondrianDef.VirtualCube) {
            pNames = DEF_VIRTUAL_CUBE;
            this.targetLabel.setText(LBL_VIRTUAL_CUBE);
        } else if (o instanceof MondrianDef.VirtualCubeDimension) {
            pNames = DEF_VIRTUAL_CUBE_DIMENSION;
            this.targetLabel.setText(LBL_VIRTUAL_CUBE_DIMENSION);
        } else if (o instanceof MondrianDef.VirtualCubeMeasure) {
            pNames = DEF_VIRTUAL_CUBE_MEASURE;
            this.targetLabel.setText(LBL_VIRTUAL_CUBE_MEASURE);
        } else {
            this.targetLabel.setText(LBL_UNKNOWN_TYPE);
        }
        PropertyTableModel ptm = new PropertyTableModel(o, pNames);
        this.propertyTable.setModel(ptm);
        for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
            TableCellRenderer renderer = this.propertyTable.getCellRenderer(i, 1);
            Component comp = renderer.getTableCellRendererComponent(this.propertyTable, this.propertyTable.getValueAt(i, 1), false, false, i, 1);
            try {
                int height = comp.getMaximumSize().height;
                this.propertyTable.setRowHeight(i, height);
                continue;
            }
            catch (Exception ea) {
                // empty catch block
            }
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.updater.update();
    }

    public void editingStopped(ChangeEvent e) {
        this.updater.update();
    }

    static JTree access$000(SchemaExplorer x0) {
        return x0.tree;
    }

    static JPopupMenu access$100(SchemaExplorer x0) {
        return x0.jPopupMenu;
    }

    static AbstractAction access$200(SchemaExplorer x0) {
        return x0.addCube;
    }

    static AbstractAction access$300(SchemaExplorer x0) {
        return x0.addDimension;
    }

    static AbstractAction access$400(SchemaExplorer x0) {
        return x0.addMeasure;
    }

    static AbstractAction access$500(SchemaExplorer x0) {
        return x0.addLevel;
    }

    static AbstractAction access$600(SchemaExplorer x0) {
        return x0.addProperty;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int x = e.getX();
                int y = e.getY();
                TreePath path = SchemaExplorer.access$000(SchemaExplorer.this).getPathForLocation(x, y);
                if (path != null) {
                    SchemaExplorer.access$100(SchemaExplorer.this).removeAll();
                    Object pathSelected = path.getLastPathComponent();
                    if (pathSelected instanceof MondrianDef.Schema) {
                        SchemaExplorer.access$100(SchemaExplorer.this).add(SchemaExplorer.access$200(SchemaExplorer.this));
                    } else if (pathSelected instanceof MondrianDef.Cube) {
                        SchemaExplorer.access$100(SchemaExplorer.this).add(SchemaExplorer.access$300(SchemaExplorer.this));
                        SchemaExplorer.access$100(SchemaExplorer.this).add(SchemaExplorer.access$400(SchemaExplorer.this));
                    } else if (pathSelected instanceof MondrianDef.Hierarchy) {
                        SchemaExplorer.access$100(SchemaExplorer.this).add(SchemaExplorer.access$500(SchemaExplorer.this));
                    } else if (pathSelected instanceof MondrianDef.Level) {
                        SchemaExplorer.access$100(SchemaExplorer.this).add(SchemaExplorer.access$600(SchemaExplorer.this));
                    } else {
                        return;
                    }
                    SchemaExplorer.access$100(SchemaExplorer.this).show(SchemaExplorer.access$000(SchemaExplorer.this), x, y);
                }
            }
        }
    }
}

