/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import com.rc.retroweaver.runtime.Autobox;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.DummyExp;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ConstantCalc
extends GenericCalc {
    private final Object o;
    private final int i;
    private final double d;

    public ConstantCalc(Type type, Object o) {
        super(new DummyExp(type));
        this.o = o;
        this.i = o instanceof Number ? ((Number)o).intValue() : 0;
        this.d = o instanceof Number ? ((Number)o).doubleValue() : 0.0;
    }

    public void accept(CalcWriter calcWriter) {
        calcWriter.getWriter().print(this.o);
    }

    public Object evaluate(Evaluator evaluator) {
        return this.o;
    }

    public int evaluateInteger(Evaluator evaluator) {
        return this.i;
    }

    public double evaluateDouble(Evaluator evaluator) {
        return this.d;
    }

    public boolean dependsOn(Dimension dimension) {
        return false;
    }

    public Calc[] getCalcs() {
        return new Calc[0];
    }

    public static ConstantCalc constantInteger(int i) {
        return new ConstantCalc(new NumericType(), Autobox.valueOf((int)i));
    }

    public static StringCalc constantString(String s) {
        return new ConstantCalc(new StringType(), s);
    }

    public static ConstantCalc constantNull(Type type) {
        return new ConstantCalc(type, null);
    }

    public static Calc constantMember(Member member) {
        return new ConstantCalc(MemberType.forMember(member), member);
    }

    public static Calc constantLevel(Level level) {
        return new ConstantCalc(LevelType.forLevel(level), level);
    }

    public static Calc constantHierarchy(Hierarchy hierarchy) {
        return new ConstantCalc(HierarchyType.forHierarchy(hierarchy), hierarchy);
    }

    public static Calc constantDimension(Dimension dimension) {
        return new ConstantCalc(DimensionType.forDimension(dimension), dimension);
    }
}

