/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import com.rc.retroweaver.runtime.Collections;
import java.io.PrintWriter;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCalc
implements Calc {
    protected final Type type;
    protected final Exp exp;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$mondrian$calc$impl$AbstractCalc;

    protected AbstractCalc(Exp exp) {
        if (!$assertionsDisabled && exp == null) {
            throw new AssertionError();
        }
        this.exp = exp;
        this.type = exp.getType();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(CalcWriter calcWriter) {
        PrintWriter pw = calcWriter.getWriter();
        String name = this.getName();
        pw.print(name);
        Calc[] calcs = this.getCalcs();
        List<Object> argumentList = this.getArguments();
        if (calcs.length > 0 || !argumentList.isEmpty()) {
            pw.print("(");
            int k = 0;
            for (Calc calc : calcs) {
                if (k++ > 0) {
                    pw.print(", ");
                }
                calc.accept(calcWriter);
            }
            for (Object o : argumentList) {
                if (k++ > 0) {
                    pw.print(", ");
                }
                pw.print(o);
            }
            pw.print(")");
        }
    }

    protected String getName() {
        String name;
        if (this.exp instanceof ResolvedFunCall) {
            ResolvedFunCall funCall = (ResolvedFunCall)this.exp;
            name = funCall.getFunDef().getName();
        } else {
            int dollar;
            name = this.getClass().getName();
            int dot = name.lastIndexOf(46);
            int dotDollar = Math.max(dot, dollar = name.lastIndexOf(36));
            if (dotDollar >= 0) {
                name = name.substring(dotDollar + 1);
            }
        }
        return name;
    }

    public abstract Calc[] getCalcs();

    @Override
    public boolean dependsOn(Dimension dimension) {
        return AbstractCalc.anyDepends(this.getCalcs(), dimension);
    }

    public static boolean anyDepends(Calc[] calcs, Dimension dimension) {
        for (Calc calc : calcs) {
            if (calc == null || !calc.dependsOn(dimension)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyDependsButFirst(Calc[] calcs, Dimension dimension) {
        if (calcs.length == 0) {
            return false;
        }
        if (calcs[0].dependsOn(dimension)) {
            return true;
        }
        if (calcs[0].getType().usesDimension(dimension, true)) {
            return false;
        }
        for (int i = 1; i < calcs.length; ++i) {
            Calc calc = calcs[i];
            if (calc == null || !calc.dependsOn(dimension)) continue;
            return true;
        }
        return false;
    }

    public static boolean butDepends(Calc[] calcs, Dimension dimension) {
        boolean result = true;
        for (Calc calc : calcs) {
            if (calc == null) continue;
            if (calc.dependsOn(dimension)) {
                return true;
            }
            if (!calc.getType().usesDimension(dimension, true)) continue;
            result = false;
        }
        return result;
    }

    public List<Object> getArguments() {
        return Collections.emptyList();
    }

    public static Evaluator simplifyEvaluator(Calc calc, Evaluator evaluator) {
        Dimension[] dimensions;
        if (evaluator.isNonEmpty()) {
            return evaluator;
        }
        int changeCount = 0;
        Evaluator ev = evaluator;
        for (Dimension dimension : dimensions = evaluator.getCube().getDimensions()) {
            Member unconstrainedMember;
            Member member = ev.getContext(dimension);
            if (member.isAll() || calc.dependsOn(dimension) || member == (unconstrainedMember = member.getHierarchy().getDefaultMember())) continue;
            if (changeCount++ == 0) {
                ev = evaluator.push(unconstrainedMember);
                continue;
            }
            ev.setContext(unconstrainedMember);
        }
        return ev;
    }

    @Override
    public ExpCompiler.ResultStyle getResultStyle() {
        return ExpCompiler.ResultStyle.VALUE;
    }

    static {
        $assertionsDisabled = !(class$mondrian$calc$impl$AbstractCalc == null ? (class$mondrian$calc$impl$AbstractCalc = AbstractCalc.class$("mondrian.calc.impl.AbstractCalc")) : class$mondrian$calc$impl$AbstractCalc).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

