/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.InvocationContextFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.xml.sax.SAXException;

public class ServletUnitClient
extends WebClient {
    private InvocationContextFactory _invocationContextFactory;

    public static ServletUnitClient newClient(InvocationContextFactory factory) {
        return new ServletUnitClient(factory);
    }

    public InvocationContext newInvocation(String requestString) throws IOException, MalformedURLException {
        return this.newInvocation(new GetMethodWebRequest(requestString));
    }

    public InvocationContext newInvocation(WebRequest request) throws IOException, MalformedURLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeMessageBody(request, baos);
        return this._invocationContextFactory.newInvocation(this, this.getTargetFrame(request), request, this.getHeaderFields(request.getURL()), baos.toByteArray());
    }

    public WebResponse getResponse(InvocationContext invocation) throws MalformedURLException, IOException, SAXException {
        this.updateMainWindow(invocation.getTarget(), invocation.getServletResponse());
        return this.getFrameContents(invocation.getTarget());
    }

    protected WebResponse newResponse(WebRequest request, String frameName) throws MalformedURLException, IOException {
        try {
            InvocationContext invocation = this.newInvocation(request);
            invocation.getServlet().service((ServletRequest)invocation.getRequest(), (ServletResponse)invocation.getResponse());
            return invocation.getServletResponse();
        }
        catch (ServletException e) {
            throw new HttpInternalErrorException(request.getURL(), (Throwable)e);
        }
    }

    private ServletUnitClient(InvocationContextFactory factory) {
        this._invocationContextFactory = factory;
    }
}

