/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.ObjectPermissionRecipientIdentity;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.AclService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.InternalURIDefinition;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ObjectPermissionServiceInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclProvider;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclDao;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.BasicAclEntryCache;
import org.acegisecurity.acl.basic.EffectiveAclsResolver;
import org.acegisecurity.acl.basic.GrantedAuthorityEffectiveAclsResolver;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.acl.basic.cache.NullAclEntryCache;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ObjectPermissionServiceImpl
extends HibernateDaoImpl
implements BasicAclDao,
AclProvider,
AclService,
ObjectPermissionService,
ObjectPermissionServiceInternal,
ApplicationContextAware,
PersistentObjectResolver,
InitializingBean {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$ObjectPermissionServiceImpl == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$ObjectPermissionServiceImpl = ObjectPermissionServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.service.impl.ObjectPermissionServiceImpl")) : class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$ObjectPermissionServiceImpl));
    public static final String RECIPIENT_USED_FOR_INHERITANCE_MARKER = "___INHERITANCE_MARKER_ONLY___";
    private static String RECIPIENT_FOR_CACHE_EMPTY = "RESERVED_RECIPIENT_NOBODY";
    private HibernateRepositoryService repoService;
    private UserAuthorityService userService;
    private ResourceFactory objectFactory;
    private ResourceFactory persistentClassFactory;
    private BasicAclEntryCache basicAclEntryCache = new NullAclEntryCache();
    private EffectiveAclsResolver effectiveAclsResolver = new GrantedAuthorityEffectiveAclsResolver();
    private ApplicationContext appContext;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$ObjectPermissionServiceImpl;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$SimpleAclEntry;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource;

    public HibernateRepositoryService getRepositoryService() {
        return this.repoService;
    }

    public void setRepositoryService(HibernateRepositoryService repoService) {
        this.repoService = repoService;
    }

    public UserAuthorityService getUserAuthorityService() {
        return this.userService;
    }

    public void setUserAuthorityService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public void setBasicAclEntryCache(BasicAclEntryCache basicAclEntryCache) {
        this.basicAclEntryCache = basicAclEntryCache;
    }

    public BasicAclEntryCache getBasicAclEntryCache() {
        return this.basicAclEntryCache;
    }

    public EffectiveAclsResolver getEffectiveAclsResolver() {
        return this.effectiveAclsResolver;
    }

    public void setEffectiveAclsResolver(EffectiveAclsResolver effectiveAclsResolver) {
        this.effectiveAclsResolver = effectiveAclsResolver;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.appContext = arg0;
    }

    public BasicAclEntry[] getAcls(String uri) {
        Resource res = this.getRepositoryService().getResourceUnsecure(null, uri);
        if (res == null) {
            res = this.getRepositoryService().getFolderUnsecure(null, uri);
        }
        if (res != null) {
            return this.getAcls((InternalURI)res);
        }
        return null;
    }

    public BasicAclEntry[] getAcls(InternalURI targetURI) {
        if (targetURI == null) {
            ((DaoSupport)this).logger.error((Object)"getAcls(InternalURI targetURI): returning. null targetURI");
            return null;
        }
        HashMap<Object, BasicAclEntry> map = new HashMap<Object, BasicAclEntry>();
        BasicAclEntry[] instanceAclEntries = null;
        if (targetURI instanceof Resource && ((Resource)targetURI).isNew()) {
            Resource res = this.getRepositoryService().getResourceUnsecure(null, "repo:" + targetURI.getPath());
            if (res == null) {
                res = this.getRepositoryService().getFolderUnsecure(null, "repo:" + targetURI.getPath());
            }
            if (res == null) {
                instanceAclEntries = this.lookup(this.getParentURI("repo:" + targetURI.getPath()));
            }
        } else {
            instanceAclEntries = this.lookup("repo:" + targetURI.getPath());
        }
        if (instanceAclEntries == null) {
            return null;
        }
        for (int i = 0; i < instanceAclEntries.length; ++i) {
            if (((DaoSupport)this).logger.isDebugEnabled()) {
                ((DaoSupport)this).logger.debug((Object)("Explicit add: " + instanceAclEntries[i].toString()));
            }
            map.put(instanceAclEntries[i].getRecipient(), instanceAclEntries[i]);
        }
        String parent = this.getParentURI("repo:" + targetURI.getPath());
        while (parent != null) {
            BasicAclEntry[] parentAclEntries = this.lookup(parent);
            if (((DaoSupport)this).logger.isDebugEnabled()) {
                ((DaoSupport)this).logger.debug((Object)("Parent lookup: " + parent));
            }
            if (parentAclEntries == null) {
                if (!((DaoSupport)this).logger.isDebugEnabled()) break;
                ((DaoSupport)this).logger.debug((Object)"Parent could not be found in ACL repository");
                break;
            }
            for (int i = 0; i < parentAclEntries.length; ++i) {
                if (!map.containsKey(parentAclEntries[i].getRecipient())) {
                    if (((DaoSupport)this).logger.isDebugEnabled()) {
                        ((DaoSupport)this).logger.debug((Object)("Added parent to map: " + parentAclEntries[i].toString() + " for recipient: " + parentAclEntries[i].getRecipient()));
                    }
                    map.put(parentAclEntries[i].getRecipient(), parentAclEntries[i]);
                    continue;
                }
                if (!((DaoSupport)this).logger.isDebugEnabled()) continue;
                ((DaoSupport)this).logger.debug((Object)("Did NOT add parent to map: " + parentAclEntries[i].toString() + " for recipient: " + parentAclEntries[i].getRecipient()));
            }
            parent = this.getParentURI(parent);
        }
        Collection collection = map.values();
        return collection.toArray(new BasicAclEntry[0]);
    }

    public BasicAclEntry[] getAcls(AclObjectIdentity aclObjectIdentity) {
        if (aclObjectIdentity == null || !(aclObjectIdentity instanceof InternalURI)) {
            ((DaoSupport)this).logger.debug((Object)("getAcls(AclObjectIdentity aclObjectIdentity): returning. invalid object for getAcls: " + aclObjectIdentity));
            return null;
        }
        InternalURI targetURI = (InternalURI)aclObjectIdentity;
        return this.getAcls(targetURI);
    }

    public BasicAclEntry[] getAcls(AclObjectIdentity aclObjectIdentity, Object recipient) {
        if (aclObjectIdentity == null || !(aclObjectIdentity instanceof InternalURI)) {
            ((DaoSupport)this).logger.debug((Object)("getAcls(AclObjectIdentity aclObjectIdentity, Object recipient): returning. invalid object for getAcls: " + aclObjectIdentity));
            return null;
        }
        InternalURI targetURI = (InternalURI)aclObjectIdentity;
        return this.getAclsForRecipient("repo:" + targetURI.getPath(), recipient);
    }

    private BasicAclEntry[] getAclsForRecipient(String targetURI, Object recipient) {
        HashMap<Object, BasicAclEntry> map = new HashMap<Object, BasicAclEntry>();
        while (targetURI != null) {
            BasicAclEntry[] entries = this.lookup(targetURI);
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    if (!(recipient != null && recipient == entries[i].getRecipient() || map.containsKey(entries[i].getRecipient()))) {
                        if (((DaoSupport)this).logger.isDebugEnabled()) {
                            ((DaoSupport)this).logger.debug((Object)("Added: " + entries[i].toString()));
                        }
                        map.put(entries[i].getRecipient(), entries[i]);
                        continue;
                    }
                    if (!((DaoSupport)this).logger.isDebugEnabled()) continue;
                    ((DaoSupport)this).logger.debug((Object)("Did NOT add: " + entries[i].toString()));
                }
            }
            targetURI = this.getParentURI(targetURI);
        }
        Collection collection = map.values();
        return collection.toArray(new BasicAclEntry[0]);
    }

    private BasicAclEntry[] getAclsFromObjectPermissions(String targetURI, List permissions) {
        if (permissions == null || permissions.size() == 0) {
            log.debug((Object)"No explicit permissions found");
            return new BasicAclEntry[]{this.createBasicAclEntry(targetURI, null)};
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + permissions.size() + " explicit permissions"));
        }
        ObjectPermission[] aclHolders = permissions.toArray(new ObjectPermission[0]);
        ArrayList<BasicAclEntry> toReturnAcls = new ArrayList<BasicAclEntry>(aclHolders.length);
        for (int i = 0; i < aclHolders.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)aclHolders[i]);
            }
            toReturnAcls.add(this.createBasicAclEntry(targetURI, aclHolders[i]));
        }
        return toReturnAcls.toArray(new BasicAclEntry[0]);
    }

    private BasicAclEntry createBasicAclEntry(String targetURI, ObjectPermission aclInformation) {
        BasicAclEntry entry;
        try {
            entry = (BasicAclEntry)(class$org$acegisecurity$acl$basic$SimpleAclEntry == null ? (class$org$acegisecurity$acl$basic$SimpleAclEntry = ObjectPermissionServiceImpl.class$("org.acegisecurity.acl.basic.SimpleAclEntry")) : class$org$acegisecurity$acl$basic$SimpleAclEntry).newInstance();
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        entry.setAclObjectIdentity((AclObjectIdentity)new URIObjectIdentity(targetURI));
        entry.setAclObjectParentIdentity((AclObjectIdentity)new URIObjectIdentity(this.getParentURI(targetURI)));
        if (aclInformation == null) {
            entry.setMask(0);
            entry.setRecipient((Object)RECIPIENT_USED_FOR_INHERITANCE_MARKER);
        } else {
            entry.setMask(aclInformation.getPermissionMask());
            entry.setRecipient(aclInformation.getPermissionRecipient());
        }
        return entry;
    }

    private String getParentURI(String currentURI) {
        if (currentURI == null || currentURI.trim().length() == 0) {
            return null;
        }
        String repoURIPrefix = "repo:";
        String workUri = currentURI.startsWith("repo:") ? currentURI.substring("repo:".length()).trim() : currentURI.trim();
        int lastSeparator = workUri.lastIndexOf("/");
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == 0) {
            if (workUri.length() == 1) {
                return null;
            }
            return "repo:/";
        }
        return "repo:" + workUri.substring(0, lastSeparator);
    }

    public AclEntry[] getAcls(Object obj) {
        ArrayList resultList = new ArrayList();
        if (obj instanceof InternalURI) {
            return this.getAcls((InternalURI)obj);
        }
        if (obj instanceof String) {
            Resource res = this.getRepositoryService().getResourceUnsecure(null, (String)obj);
            if (res == null) {
                res = this.getRepositoryService().getFolderUnsecure(null, (String)obj);
            }
            if (res != null) {
                return this.getAcls((InternalURI)res);
            }
            return this.getAcls(new InternalURIDefinition((String)obj));
        }
        return resultList.toArray(new BasicAclEntry[0]);
    }

    public AclEntry[] getAcls(Object obj, Authentication auth) {
        if (auth == null || auth.getPrincipal() == null || !(obj instanceof InternalURI) && !(obj instanceof String)) {
            return new BasicAclEntry[0];
        }
        AclEntry[] allAcls = this.getAcls(obj);
        return this.effectiveAclsResolver.resolveEffectiveAcls(allAcls, auth);
    }

    private BasicAclEntry[] lookup(String targetURI) {
        Resource res;
        URIObjectIdentity objIdent = new URIObjectIdentity(targetURI);
        BasicAclEntry[] result = this.basicAclEntryCache.getEntriesFromCache((AclObjectIdentity)objIdent);
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + targetURI + " in cache"));
            }
            if (result[0].getRecipient().equals(RECIPIENT_FOR_CACHE_EMPTY)) {
                return null;
            }
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find " + targetURI + " in cache"));
        }
        if ((res = this.getRepositoryService().getResourceUnsecure(null, targetURI)) == null) {
            res = this.getRepositoryService().getFolderUnsecure(null, targetURI);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Did not find " + targetURI + " as resource"));
                log.debug((Object)("Did " + (res == null ? "not" : "") + " find " + targetURI + " as folder"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + targetURI + " as resource"));
        }
        if (res == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource not found for permissions lookup: " + targetURI + ". Using parent permissions"));
            }
            return this.lookup(this.getParentURI(targetURI));
        }
        List permissions = this.getObjectPermissionsForObject(null, res);
        result = this.getAclsFromObjectPermissions(targetURI, permissions);
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Default entries for " + targetURI + " cached"));
            }
            SimpleAclEntry[] emptyAclEntries = new SimpleAclEntry[]{new SimpleAclEntry((Object)RECIPIENT_FOR_CACHE_EMPTY, (AclObjectIdentity)new URIObjectIdentity(targetURI), null, 0)};
            this.basicAclEntryCache.putEntriesInCache((BasicAclEntry[])emptyAclEntries);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(result.length + " entries for " + targetURI + " cached"));
        }
        this.basicAclEntryCache.putEntriesInCache(result);
        return result;
    }

    public void deleteObjectPermissionForObject(ExecutionContext context, Object targetObject) {
        if (targetObject == null || !(targetObject instanceof InternalURI)) {
            return;
        }
        InternalURI res = (InternalURI)targetObject;
        this.deleteObjectPermissionForRepositoryPath(context, res.getPath());
    }

    public void deleteObjectPermissionForRepositoryPath(ExecutionContext context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting object permissions for repository path " + path));
        }
        List permissions = this.getRepoObjectPermissions(context, "repo:" + path, null);
        this.deleteObjectPermissions(permissions);
    }

    public void deleteObjectPermissionsForRecipient(ExecutionContext context, Object recipient) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting object permissions for recipient " + recipient));
        }
        List permissions = this.getRepoObjectPermissions(context, null, recipient);
        this.deleteObjectPermissions(permissions);
    }

    public void deleteObjectPermissionsForRecipient(ExecutionContext context, ObjectPermissionRecipientIdentity recipientIdentity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting object permissions for recipient " + recipientIdentity));
        }
        List permissions = this.getRepoObjectPermissions(recipientIdentity);
        this.deleteObjectPermissions(permissions);
    }

    protected void deleteObjectPermissions(List permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            Iterator it = permissions.iterator();
            while (it.hasNext()) {
                RepoObjectPermission permission = (RepoObjectPermission)it.next();
                this.deleteObjectPermission(permission);
            }
        }
    }

    public boolean supports(Object obj) {
        return obj instanceof InternalURI || obj instanceof String;
    }

    public ObjectPermission newObjectPermission(ExecutionContext context) {
        return (ObjectPermission)this.getObjectMappingFactory().newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission = ObjectPermissionServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission);
    }

    public void putObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        RepoObjectPermission existingPerm = this.getRepoObjectPermission(context, objPermission);
        if (existingPerm == null) {
            existingPerm = (RepoObjectPermission)this.getPersistentClassFactory().newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission = ObjectPermissionServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission);
        }
        existingPerm.copyFromClient(objPermission, this);
        this.getHibernateTemplate().saveOrUpdate((Object)existingPerm);
        URIObjectIdentity objId = new URIObjectIdentity(objPermission.getURI());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing " + objId + " from permissions"));
        }
        this.basicAclEntryCache.removeEntriesFromCache((AclObjectIdentity)objId);
    }

    public void deleteObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        RepoObjectPermission existingPerm = this.getRepoObjectPermission(context, objPermission);
        if (existingPerm == null) {
            throw new JSException("jsexception.no.such.object.permission");
        }
        this.deleteObjectPermission(existingPerm);
    }

    protected void deleteObjectPermission(RepoObjectPermission permission) {
        this.getHibernateTemplate().delete((Object)permission);
        URIObjectIdentity objId = new URIObjectIdentity(permission.getURI());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing " + objId + " from permissions"));
        }
        this.basicAclEntryCache.removeEntriesFromCache((AclObjectIdentity)objId);
    }

    public ObjectPermission getObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        RepoObjectPermission existingPerm = this.getRepoObjectPermission(context, objPermission);
        if (existingPerm == null) {
            return null;
        }
        return (ObjectPermission)existingPerm.toClient(this.getObjectMappingFactory());
    }

    private List getRepoObjectPermissions(ExecutionContext context, final String uri, Object recipient) {
        final IdedObject recipientObject = (IdedObject)this.getPersistentObject(recipient);
        String objPermissionClassName = this.getPersistentClassFactory().getImplementationClassName(class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission = ObjectPermissionServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission);
        List objList = null;
        if (uri == null && recipientObject == null) {
            throw new JSException("jsexception.no.uri.or.recipient.given");
        }
        if (uri != null && recipientObject != null) {
            final String queryString = "from " + objPermissionClassName + " as objPermission " + "where objPermission.URI = ? and " + "      objPermission.permissionRecipient.id = ? and objPermission.permissionRecipient.class = ?";
            objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(queryString);
                    query.setParameter(0, (Object)uri, (Type)Hibernate.STRING);
                    query.setParameter(1, (Object)new Long(recipientObject.getId()), (Type)Hibernate.LONG);
                    query.setParameter(2, recipientObject.getClass(), (Type)Hibernate.CLASS);
                    return query.list();
                }
            });
        } else if (uri != null) {
            final String queryString = "from " + objPermissionClassName + " as objPermission " + "where objPermission.URI = ?";
            objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query query = session.createQuery(queryString);
                    query.setParameter(0, (Object)uri, (Type)Hibernate.STRING);
                    return query.list();
                }
            });
        } else if (recipientObject != null) {
            ObjectPermissionRecipientIdentity recipientIdentity = new ObjectPermissionRecipientIdentity(recipientObject);
            objList = this.getRepoObjectPermissions(recipientIdentity);
        }
        return objList;
    }

    protected List getRepoObjectPermissions(final ObjectPermissionRecipientIdentity recipientIdentity) {
        String objPermissionClassName = this.getPersistentClassFactory().getImplementationClassName(class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission = ObjectPermissionServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$ObjectPermission);
        final String queryString = "from " + objPermissionClassName + " as objPermission " + "where objPermission.permissionRecipient.id = ? and objPermission.permissionRecipient.class = ?";
        List objList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(queryString);
                query.setParameter(0, (Object)new Long(recipientIdentity.getId()), (Type)Hibernate.LONG);
                query.setParameter(1, (Object)recipientIdentity.getRecipientClass(), (Type)Hibernate.CLASS);
                return query.list();
            }
        });
        return objList;
    }

    private List getRepoObjectPermissions(ExecutionContext context, ObjectPermission objPermission) {
        return this.getRepoObjectPermissions(context, objPermission.getURI(), objPermission.getPermissionRecipient());
    }

    private RepoObjectPermission getRepoObjectPermission(ExecutionContext context, ObjectPermission objPermission) {
        List objList = this.getRepoObjectPermissions(context, objPermission);
        RepoObjectPermission objPerm = null;
        if (objList == null || objList.isEmpty()) {
            log.debug((Object)("ObjectPermission not found with object \"" + objPermission.getURI() + "\", recipient \"" + objPermission.getPermissionRecipient() + "\""));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ObjectPermission FOUND with object \"" + objPermission.getURI() + "\", recipient \"" + objPermission.getPermissionRecipient() + "\""));
                log.debug((Object)("Size: " + objList.size()));
            }
            objPerm = (RepoObjectPermission)objList.get(0);
        }
        return objPerm;
    }

    public List getObjectPermissionsForObject(ExecutionContext context, Object targetObject) {
        if (targetObject == null || !(targetObject instanceof InternalURI)) {
            return new ArrayList();
        }
        InternalURI res = (InternalURI)targetObject;
        List objList = this.getRepoObjectPermissions(context, "repo:" + res.getPath(), null);
        return this.makeObjectPermissionClientList("repo:" + res.getPath(), objList);
    }

    public List getObjectPermissionsForRecipient(ExecutionContext context, Object recipient) {
        List objList = this.getRepoObjectPermissions(context, null, recipient);
        return this.makeObjectPermissionClientList(null, objList);
    }

    public List getObjectPermissionsForObjectAndRecipient(ExecutionContext context, Object targetObject, Object recipient) {
        if (!(targetObject instanceof InternalURI)) {
            return new ArrayList();
        }
        InternalURI res = (InternalURI)targetObject;
        List objList = this.getRepoObjectPermissions(context, "repo:" + res.getPath(), recipient);
        return this.makeObjectPermissionClientList("repo:" + res.getPath(), objList);
    }

    private List makeObjectPermissionClientList(String uri, List objList) {
        ArrayList<ObjectPermission> resultList = new ArrayList<ObjectPermission>(objList.size());
        Iterator it = objList.iterator();
        while (!objList.isEmpty() && it.hasNext()) {
            RepoObjectPermission repoPerm = (RepoObjectPermission)it.next();
            ObjectPermission clientPermission = (ObjectPermission)repoPerm.toClient(this.getObjectMappingFactory());
            resultList.add(clientPermission);
        }
        return resultList;
    }

    public Object getPersistentObject(Object clientObject) {
        if (clientObject == null) {
            return null;
        }
        if (clientObject instanceof IdedObject) {
            return clientObject;
        }
        if (clientObject instanceof Role || clientObject instanceof User) {
            return ((PersistentObjectResolver)this.userService).getPersistentObject(clientObject);
        }
        if (clientObject instanceof Resource) {
            String uri = ((Resource)clientObject).getPath();
            return this.repoService.findByURI(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource = ObjectPermissionServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource, uri, false);
        }
        if (clientObject instanceof ObjectPermission) {
            return this.getRepoObjectPermission(null, (ObjectPermission)clientObject);
        }
        return null;
    }

    public RepoResource getExternalReference(String uri, Class persistentReferenceClass) {
        return ((ReferenceResolver)((Object)this.repoService)).getExternalReference(uri, persistentReferenceClass);
    }

    public RepoResource getReference(RepoResource owner, Resource resource, Class persistentReferenceClass) {
        return ((ReferenceResolver)((Object)this.repoService)).getReference(owner, resource, persistentReferenceClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class URIObjectIdentity
    implements AclObjectIdentity {
        String uri;

        public URIObjectIdentity(String uri) {
            String fullUri = uri;
            if (uri != null && uri.startsWith("/")) {
                fullUri = "repo:" + uri;
            }
            this.uri = fullUri;
        }

        public String getURI() {
            return this.uri;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("uri", (Object)this.getURI()).toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof URIObjectIdentity)) {
                return false;
            }
            URIObjectIdentity castOther = (URIObjectIdentity)other;
            return new EqualsBuilder().append((Object)this.getURI(), (Object)castOther.getURI()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getURI()).toHashCode();
        }
    }
}

