/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate;

import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RepoUser
implements User,
IdedObject {
    private Set roleSet = new HashSet();
    private long id;
    private String username = null;
    private String fullName = null;
    private String password = null;
    private String emailAddress = null;
    private boolean externallyDefined = false;
    private boolean enabled = false;
    private List attributes = null;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$domain$User;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String newUsername) {
        if (newUsername == null || newUsername.trim().length() == 0) {
            throw new RuntimeException("No user name");
        }
        this.username = newUsername;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Set getRoles() {
        return this.roleSet;
    }

    public void setRoles(Set newRoleSet) {
        this.roleSet = newRoleSet;
    }

    public void addRole(Role newRole) {
        if (!(newRole instanceof RepoRole)) {
            throw new IllegalArgumentException("can only add RepoRoles to a RepoUser");
        }
        if (newRole != null && !this.getRoles().contains(newRole)) {
            this.getRoles().add(newRole);
        }
    }

    public void removeRole(Role removedRole) {
        this.getRoles().remove(removedRole);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    public GrantedAuthority[] getAuthorities() {
        GrantedAuthority[] authorities;
        Set currentRoles = this.getRoles();
        GrantedAuthority[] grantedAuthorityArray = authorities = currentRoles == null ? new GrantedAuthority[]{} : new GrantedAuthority[currentRoles.size()];
        if (currentRoles == null) {
            return authorities;
        }
        Iterator it = currentRoles.iterator();
        int i = 0;
        while (it.hasNext()) {
            Role aRole = (Role)it.next();
            authorities[i++] = new GrantedAuthorityImpl(aRole.getRoleName());
        }
        return authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAccountNonExpired() {
        return this.enabled;
    }

    public boolean isAccountNonLocked() {
        return this.enabled;
    }

    public boolean isCredentialsNonExpired() {
        return this.enabled;
    }

    public boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    public void setExternallyDefined(boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void copyFromClient(Object obj, PersistentObjectResolver resolver) {
        User u = (User)obj;
        this.setUsername(u.getUsername());
        this.setPassword(PasswordCipherer.getInstance().encodePassword(u.getPassword()));
        this.setFullName(u.getFullName());
        this.setEmailAddress(u.getEmailAddress());
        this.setExternallyDefined(u.isExternallyDefined());
        this.setEnabled(u.isEnabled());
        Set clientRoles = u.getRoles();
        HashSet<RepoRole> repoRoles = null;
        if (clientRoles != null) {
            repoRoles = new HashSet<RepoRole>(clientRoles.size());
            if (clientRoles.size() > 0) {
                Iterator it = clientRoles.iterator();
                while (it.hasNext()) {
                    Role clientRole = (Role)it.next();
                    RepoRole r = (RepoRole)resolver.getPersistentObject(clientRole);
                    if (r == null) {
                        r = new RepoRole();
                    }
                    r.copyFromClient(clientRole, resolver);
                    repoRoles.add(r);
                }
            }
        }
        this.setRoles(repoRoles);
    }

    public Object toClient(ResourceFactory clientMappingFactory) {
        User u = (User)clientMappingFactory.newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = RepoUser.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User);
        u.setUsername(this.getUsername());
        u.setPassword(PasswordCipherer.getInstance().decodePassword(this.getPassword()));
        u.setFullName(this.getFullName());
        u.setEmailAddress(this.getEmailAddress());
        u.setExternallyDefined(this.isExternallyDefined());
        u.setEnabled(this.isEnabled());
        Set repoRoles = this.getRoles();
        HashSet<Role> clientRoles = null;
        if (repoRoles != null) {
            clientRoles = new HashSet<Role>(repoRoles.size());
            if (repoRoles.size() > 0) {
                Iterator it = repoRoles.iterator();
                while (it.hasNext()) {
                    RepoRole repoRole = (RepoRole)it.next();
                    Role r = (Role)repoRole.toClient(clientMappingFactory);
                    clientRoles.add(r);
                }
            }
        }
        u.setRoles(clientRoles);
        return u;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("userId", this.getId()).append("username", (Object)this.getUsername()).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RepoUser)) {
            return false;
        }
        RepoUser castOther = (RepoUser)other;
        return new EqualsBuilder().append(this.getId(), castOther.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getId()).toHashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

