/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

public class ContentRepoFileResource
extends RepoResource {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource = ContentRepoFileResource.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.ContentRepoFileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource));
    private String fileType;
    private Blob data;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource;

    public Blob getData() {
        return this.data;
    }

    public void setData(Blob data) {
        this.data = data;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String type) {
        this.fileType = type;
    }

    protected void copyDataFrom(ContentResource dataRes) {
        if (dataRes.isReference()) {
            this.setData(null);
        } else if (dataRes.hasData()) {
            byte[] clientData = dataRes.getData();
            Blob blob = Hibernate.createBlob((byte[])clientData);
            this.setData(blob);
        }
    }

    public FileResourceData copyData() {
        try {
            Blob blob = this.getData();
            FileResourceData resData = blob == null ? new FileResourceData((byte[])null) : new FileResourceData(blob.getBinaryStream());
            return resData;
        }
        catch (SQLException e) {
            log.error((Object)("Error while reading data blob of \"" + this.getResourceURI() + "\""), (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        ContentResource resource = (ContentResource)clientRes;
        resource.setFileType(this.getFileType());
        resource.setReferenceURI(null);
        RepoFolder childrenFolder = this.getChildrenFolder();
        if (childrenFolder != null) {
            Set resList = childrenFolder.getChildren();
            Iterator it = resList.iterator();
            while (it.hasNext()) {
                ContentRepoFileResource fileRes = (ContentRepoFileResource)it.next();
                resource.addChildResource((ContentResource)fileRes.toClient(resourceFactory));
            }
        }
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        ContentResource dataRes = (ContentResource)clientRes;
        this.setFileType(dataRes.getFileType());
        this.copyDataFrom(dataRes);
        this.copyResources(referenceResolver, (ContentResource)clientRes);
    }

    private void copyResources(ReferenceResolver referenceResolver, ContentResource resource) {
        List clientResources = resource.getResources();
        if (clientResources != null && !clientResources.isEmpty()) {
            Iterator it = clientResources.iterator();
            while (it.hasNext()) {
                ContentResource childResource = (ContentResource)it.next();
                this.getReference((Resource)childResource, class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource == null ? ContentRepoFileResource.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource") : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource, referenceResolver);
            }
        }
    }

    protected Class getClientItf() {
        return class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource = ContentRepoFileResource.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$ContentResource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

