/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.CachedItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class HibernateRepositoryCache
extends HibernateDaoImpl
implements RepositoryCache {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryCache == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryCache = HibernateRepositoryCache.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryCache")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryCache));
    private RepositoryService repository;
    private Set locks = new HashSet();
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryCache;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$CachedItem;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public InputStream cache(ExecutionContext context, FileResource resource, RepositoryCacheableItem cacheableItem) {
        CachedItem cachedItem = this.getCachedItem(context, resource, cacheableItem);
        while (cachedItem.isReference()) {
            cachedItem = cachedItem.getReference();
        }
        return new ByteArrayInputStream(cachedItem.getDataBytes());
    }

    public InputStream cache(ExecutionContext context, String uri, RepositoryCacheableItem cacheableItem) {
        FileResource resource = (FileResource)this.repository.getResource(context, uri);
        return this.cache(context, resource, cacheableItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lock(FileResource resource, RepositoryCacheableItem cacheableItem) {
        Pair key = this.getLockKey(resource, cacheableItem);
        Set set = this.locks;
        synchronized (set) {
            while (this.locks.contains(key)) {
                try {
                    this.locks.wait();
                }
                catch (InterruptedException e) {
                    throw new JSExceptionWrapper((Exception)e);
                }
            }
            this.locks.add(key);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(Object key) {
        Set set = this.locks;
        synchronized (set) {
            this.locks.remove(key);
            this.locks.notifyAll();
        }
    }

    protected Pair getLockKey(FileResource resource, RepositoryCacheableItem cacheableItem) {
        return new Pair((Object)resource.getURIString(), (Object)cacheableItem.getCacheName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CachedItem getCachedItem(ExecutionContext context, FileResource resource, RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking in repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + resource.getURIString() + "\", version " + resource.getVersion() + "\", version date " + resource.getCreationDate()));
        }
        Object lockKey = this.lock(resource, cacheableItem);
        try {
            CachedItem cachedItem = this.getCachedItem(resource.getURIString(), cacheableItem);
            if (cachedItem == null || cachedItem.getVersion() < resource.getVersion() || cachedItem.getVersionDate() == null || cachedItem.getVersionDate().before(resource.getCreationDate())) {
                cachedItem = resource.isReference() ? this.saveRefence(context, resource, cachedItem, cacheableItem) : this.saveData(context, resource, cachedItem, cacheableItem);
            }
            CachedItem cachedItem2 = cachedItem;
            return cachedItem2;
        }
        finally {
            this.unlock(lockKey);
        }
    }

    protected CachedItem getCachedItem(String uri, RepositoryCacheableItem cacheableItem) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$CachedItem == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$CachedItem = HibernateRepositoryCache.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.CachedItem")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$CachedItem));
        criteria.add((Criterion)Restrictions.naturalId().set("cacheName", (Object)cacheableItem.getCacheName()).set("uri", (Object)uri));
        List list = this.getHibernateTemplate().findByCriteria(criteria);
        CachedItem item = list.isEmpty() ? null : (CachedItem)list.get(0);
        return item;
    }

    protected CachedItem saveRefence(ExecutionContext context, FileResource resource, CachedItem item, RepositoryCacheableItem cacheableItem) {
        FileResource ref = (FileResource)this.repository.getResource(context, resource.getReferenceURI());
        CachedItem refItem = this.getCachedItem(context, ref, cacheableItem);
        CachedItem saveItem = item == null ? new CachedItem() : item;
        saveItem.setCacheName(cacheableItem.getCacheName());
        saveItem.setData(null);
        saveItem.setReference(refItem);
        saveItem.setUri(resource.getURIString());
        saveItem.setVersion(resource.getVersion());
        saveItem.setVersionDate(resource.getCreationDate());
        if (item == null) {
            this.getHibernateTemplate().save((Object)saveItem);
        } else {
            this.getHibernateTemplate().update((Object)saveItem);
        }
        return saveItem;
    }

    protected CachedItem saveData(ExecutionContext context, FileResource resource, CachedItem item, RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + resource.getURIString() + "\", version " + resource.getVersion() + "\", version date " + resource.getCreationDate()));
        }
        byte[] data = cacheableItem.getData(context, resource);
        CachedItem saveItem = item == null ? new CachedItem() : item;
        saveItem.setCacheName(cacheableItem.getCacheName());
        saveItem.setDataBytes(data);
        saveItem.setReference(null);
        saveItem.setUri(resource.getURIString());
        saveItem.setVersion(resource.getVersion());
        saveItem.setVersionDate(resource.getCreationDate());
        if (item == null) {
            this.getHibernateTemplate().save((Object)saveItem);
        } else {
            this.getHibernateTemplate().update((Object)saveItem);
        }
        return saveItem;
    }

    public void clearCache(final String uri, final RepositoryCacheableItem cacheableItem) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryCache.this.removeCached(uri, cacheableItem);
                return null;
            }
        }, false);
    }

    protected void removeCached(String uri, RepositoryCacheableItem cacheableItem) {
        CachedItem cachedItem;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing cache " + cacheableItem.getCacheName() + " for resource " + uri));
        }
        if ((cachedItem = this.getCachedItem(uri, cacheableItem)) != null) {
            this.getHibernateTemplate().delete((Object)cachedItem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

