/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.view.domain.Filter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.view.domain.ParentFolderFilter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.PropertyFilter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.ReferenceFilter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.URIFilter;
import java.util.Iterator;
import java.util.List;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class HibernateFilter
implements Filter {
    public final Junction junction;
    private final ReferenceResolver referenceResolver;
    private Criterion criterion;

    public HibernateFilter(Junction junction, ReferenceResolver referenceResolver) {
        this.junction = junction;
        this.referenceResolver = referenceResolver;
    }

    protected final Criterion last() {
        return this.criterion;
    }

    protected void add(Criterion newCriterion) {
        this.criterion = newCriterion;
        if (this.junction != null) {
            this.junction.add(newCriterion);
        }
    }

    public void applyParentFolderFilter(ParentFolderFilter filter) {
        this.add((Criterion)this.parentFolderRestriction(filter.getFolderURI()));
    }

    protected SimpleExpression parentFolderRestriction(String folderURI) {
        return Restrictions.eq((String)"parent.URI", (Object)folderURI);
    }

    public void applyPropertyFilter(PropertyFilter filter) {
        SimpleExpression propCriterion;
        switch (filter.getOp()) {
            case 0: {
                propCriterion = Restrictions.eq((String)filter.getProperty(), (Object)filter.getValue());
                break;
            }
            case 1: {
                propCriterion = Restrictions.like((String)filter.getProperty(), (Object)filter.getValue());
                break;
            }
            case 2: {
                propCriterion = Restrictions.gt((String)filter.getProperty(), (Object)filter.getValue());
                break;
            }
            case 3: {
                propCriterion = Restrictions.lt((String)filter.getProperty(), (Object)filter.getValue());
                break;
            }
            case 4: {
                propCriterion = Restrictions.between((String)filter.getProperty(), (Object)filter.getLowValue(), (Object)filter.getHighValue());
                break;
            }
            default: {
                throw new JSException("jsexception.hibernate.unknown.property.filter.operation", new Object[]{new Byte(filter.getOp())});
            }
        }
        this.add((Criterion)propCriterion);
    }

    public void applyNegatedFilter(FilterElement element) {
        HibernateFilter notFilter = new HibernateFilter(null, this.referenceResolver);
        element.apply((Filter)notFilter);
        this.add(Restrictions.not((Criterion)notFilter.last()));
    }

    public void applyConjunction(List filterElements) {
        Conjunction conjunction = Restrictions.conjunction();
        this.applyJunction(filterElements, (Junction)conjunction);
    }

    public void applyDisjunction(List filterElements) {
        Disjunction disjunction = Restrictions.disjunction();
        this.applyJunction(filterElements, (Junction)disjunction);
    }

    public void applyOr(FilterElement lhs, FilterElement rhs) {
        HibernateFilter lhsFilter = new HibernateFilter(null, this.referenceResolver);
        lhs.apply((Filter)lhsFilter);
        HibernateFilter rhsFilter = new HibernateFilter(null, this.referenceResolver);
        rhs.apply((Filter)rhsFilter);
        LogicalExpression or = Restrictions.or((Criterion)lhsFilter.last(), (Criterion)rhsFilter.last());
        this.add((Criterion)or);
    }

    protected void applyJunction(List filterElements, Junction subJunction) {
        HibernateFilter junctionFilter = new HibernateFilter(subJunction, this.referenceResolver);
        Iterator it = filterElements.iterator();
        while (it.hasNext()) {
            FilterElement filterElement = (FilterElement)it.next();
            filterElement.apply((Filter)junctionFilter);
        }
        this.add((Criterion)subJunction);
    }

    public void applyReferenceFilter(ReferenceFilter filter) {
        RepoResource persistentRef = this.referenceResolver.getPersistentReference(filter.getReferredURI(), filter.getReferenceClass());
        SimpleExpression propCriterion = Restrictions.eq((String)filter.getProperty(), (Object)persistentRef);
        this.add((Criterion)propCriterion);
    }

    public void applyURIFilter(URIFilter filter) {
        String uri = filter.getURI();
        int lastSep = uri.lastIndexOf("/");
        if (lastSep <= 0) {
            throw new JSException("Invalid resource URI " + uri);
        }
        String folder = uri.substring(0, lastSep);
        String name = uri.substring(lastSep + Folder.SEPARATOR_LENGTH);
        this.add((Criterion)Restrictions.conjunction().add((Criterion)this.parentFolderRestriction(folder)).add((Criterion)Restrictions.eq((String)"name", (Object)name)));
    }
}

