/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.Cipherer;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;

public class PasswordCipherer
implements PasswordEncoder {
    private static Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$PasswordCipherer == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$PasswordCipherer = PasswordCipherer.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$PasswordCipherer));
    private static PasswordCipherer instance = null;
    private static Cipherer cipherer = null;
    private boolean allowEncoding = false;
    private boolean keyInPlainText = false;
    private String secretKey = null;
    private String secretKeyAlgorithm = null;
    private String cipherTransformation = null;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$PasswordCipherer;

    public PasswordCipherer() {
        instance = this;
    }

    public static PasswordCipherer getInstance() {
        if (instance == null) {
            instance = new PasswordCipherer();
        }
        if (cipherer == null && instance.isAllowEncoding()) {
            instance.initCipherer();
        }
        return instance;
    }

    private void initCipherer() {
        cipherer = new Cipherer();
        if (this.secretKey != null) {
            cipherer.setKeyBytes(this.secretKey, this.keyInPlainText);
        }
        if (this.cipherTransformation != null) {
            cipherer.setCipherTransformation(this.cipherTransformation);
        }
        if (this.secretKeyAlgorithm != null) {
            cipherer.setKeyAlgorithm(this.secretKeyAlgorithm);
        }
        cipherer.init();
    }

    public String decodePassword(String encPass) {
        try {
            log.debug((Object)("Decode password: " + this.allowEncoding));
            if (!this.allowEncoding) {
                return encPass;
            }
            return cipherer.decode(encPass);
        }
        catch (Exception ex) {
            log.debug((Object)ex);
            ex.printStackTrace();
            throw new DataAccessResourceFailureException(ex.getMessage(), ex.getCause());
        }
    }

    public String encodePassword(String rawPass) throws DataAccessException {
        try {
            log.debug((Object)("Encode password: " + this.allowEncoding));
            if (!this.allowEncoding) {
                return rawPass;
            }
            return cipherer.encode(rawPass);
        }
        catch (Exception ex) {
            log.debug((Object)ex);
            ex.printStackTrace();
            throw new DataAccessResourceFailureException(ex.getMessage(), ex.getCause());
        }
    }

    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        return this.encodePassword(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        return rawPass.equals(encPass);
    }

    public boolean isAllowEncoding() {
        return this.allowEncoding;
    }

    public void setAllowEncoding(boolean allowEncoding) {
        this.allowEncoding = allowEncoding;
    }

    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public void setCipherTransformation(String cipherTransformation) {
        this.cipherTransformation = cipherTransformation;
    }

    public boolean isKeyInPlainText() {
        return this.keyInPlainText;
    }

    public void setKeyInPlainText(boolean keyInPlainText) {
        this.keyInPlainText = keyInPlainText;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

