/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.xmla;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryUnsecure;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.OlapConnectionServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.xmla.XmlaHandlerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaServlet;
import mondrian.xmla.impl.DefaultXmlaServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class XmlaServletImpl
extends DefaultXmlaServlet {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$xmla$XmlaServletImpl == null ? (class$com$jaspersoft$jasperserver$war$xmla$XmlaServletImpl = XmlaServletImpl.class$("com.jaspersoft.jasperserver.war.xmla.XmlaServletImpl")) : class$com$jaspersoft$jasperserver$war$xmla$XmlaServletImpl));
    private static ApplicationContext ctx;
    private RepositoryService mRepository;
    private OlapConnectionService mConnectionService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$xmla$XmlaServletImpl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition;

    public static ApplicationContext getContext() {
        return ctx;
    }

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"XmlaServletImpl:init");
        ServletContext servletContext = config.getServletContext();
        ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (ctx == null) {
            log.error((Object)"XmlaServletImpl:init Unable to obtain ApplicationContext from servletContext");
            ctx = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"});
            if (ctx == null) {
                log.error((Object)"XmlaServletImpl:init Unable to obtain ApplicationContext");
            }
        }
        super.init(config);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.getConnectionService() != null) {
                ((XmlaServlet)this).charEncoding = ((OlapConnectionServiceImpl)this.getConnectionService()).getEncodingProvider().getCharacterEncoding();
                log.debug((Object)("doPost:charEncoding set to " + ((XmlaServlet)this).charEncoding));
            }
            super.doPost(request, response);
        }
        catch (Throwable t) {
            log.error((Object)"XMLA Servlet Error, ROOT CAUSE:");
            log.error((Object)XmlaException.getRootCause((Throwable)t).getStackTrace());
            throw new ServletException(t);
        }
    }

    protected void handleFault(HttpServletResponse response, byte[][] responseSoapParts, XmlaServlet.Phase phase, Throwable t) {
        log.error((Object)"XMLA FAULT!!!");
        log.error((Object)XmlaException.getRootCause((Throwable)t).getStackTrace());
        super.handleFault(response, responseSoapParts, phase, t);
    }

    protected DataSourcesConfig.DataSources makeDataSources(ServletConfig servletConfig) {
        log.debug((Object)"makeDataSources");
        RepositoryService rep = this.getRepository();
        String servletURL = null;
        try {
            String defaultPort;
            ServletContext servletContext = servletConfig.getServletContext();
            InetAddress local = InetAddress.getLocalHost();
            String defaultProtocol = servletContext.getInitParameter("defaultProtocol");
            if (defaultProtocol == null || defaultProtocol.trim().length() == 0) {
                defaultProtocol = "http";
            }
            if ((defaultPort = servletContext.getInitParameter("defaultPort")) == null || defaultPort.trim().length() == 0) {
                defaultPort = "-1";
            }
            int port = Integer.parseInt(defaultPort);
            URL root = servletContext.getResource("/");
            int pastHost = root.getPath().indexOf("/", 1);
            String path = root.getPath().substring(pastHost, root.getPath().length());
            servletURL = new URL(defaultProtocol, local.getCanonicalHostName(), port, path).toString() + "xmla";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DataSourcesConfig.DataSources datasources = new DataSourcesConfig.DataSources();
        FilterCriteria f = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition = XmlaServletImpl.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition));
        ResourceLookup[] lookups = rep.findResource(JasperServerUtil.getExecutionContext(), f);
        if (lookups == null || lookups.length == 0) {
            log.debug((Object)"No XML/A Connections available");
            return datasources;
        }
        DataSourcesConfig.DataSource[] ds = datasources.dataSources = new DataSourcesConfig.DataSource[lookups.length];
        for (int i = 0; i < lookups.length; ++i) {
            DataSourcesConfig.DataSource d = new DataSourcesConfig.DataSource();
            MondrianXMLADefinition def = (MondrianXMLADefinition)((RepositoryUnsecure)rep).getResourceUnsecure(null, lookups[i].getURIString());
            d.description = def.getDescription();
            d.url = servletURL;
            d.providerName = "Mondrian";
            d.providerType = "MDP";
            d.authenticationMode = "Unauthenticated";
            d.dataSourceInfo = d.name = "Provider=" + d.providerName + ";DataSource=" + def.getCatalog() + ";";
            DataSourcesConfig.Catalogs cs = new DataSourcesConfig.Catalogs();
            DataSourcesConfig.Catalog c = new DataSourcesConfig.Catalog();
            c.name = def.getCatalog();
            cs.catalogs = new DataSourcesConfig.Catalog[1];
            cs.catalogs[0] = c;
            d.catalogs = cs;
            c.definition = "JASPERSERVER";
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading DataSource name=" + d.name + ", info=" + d.dataSourceInfo + ", url=" + d.url));
            }
            ds[i] = d;
        }
        return datasources;
    }

    protected XmlaHandler getXmlaHandler() {
        if (((XmlaServlet)this).xmlaHandler == null) {
            log.debug((Object)"getXmlaHandler");
            ((XmlaServlet)this).xmlaHandler = new XmlaHandlerImpl(((XmlaServlet)this).dataSources, ((XmlaServlet)this).catalogLocator, this.getRepository(), this.getConnectionService());
        }
        return ((XmlaServlet)this).xmlaHandler;
    }

    public RepositoryService getRepository() {
        if (this.mRepository == null) {
            log.debug((Object)"getRepository");
            this.mRepository = (RepositoryService)ctx.getBean("repositoryService");
            if (this.mRepository == null) {
                log.error((Object)("repositoryService not available in context: " + ctx));
            }
        }
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    public OlapConnectionService getConnectionService() {
        if (this.mConnectionService == null) {
            log.debug((Object)"getConnectionService");
            this.mConnectionService = (OlapConnectionService)ctx.getBean("olapConnectionService");
            if (this.mConnectionService == null) {
                log.error((Object)("repositoryService not available in context: " + ctx));
            }
        }
        return this.mConnectionService;
    }

    public void setConnectionService(OlapConnectionService cs) {
        this.mConnectionService = cs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

