/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.xmla;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.spi.CatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlaHandlerImpl
extends XmlaHandler {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$xmla$XmlaHandlerImpl == null ? (class$com$jaspersoft$jasperserver$war$xmla$XmlaHandlerImpl = XmlaHandlerImpl.class$("com.jaspersoft.jasperserver.war.xmla.XmlaHandlerImpl")) : class$com$jaspersoft$jasperserver$war$xmla$XmlaHandlerImpl));
    private static final String XMLA_PREFIX = "xmla";
    private OlapConnectionService mConnectionService;
    private RepositoryService mRepository;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$xmla$XmlaHandlerImpl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition;

    public XmlaHandlerImpl(DataSourcesConfig.DataSources dataSources, CatalogLocator catalogLocator, RepositoryService repository, OlapConnectionService connectionService) {
        super(dataSources, catalogLocator, XMLA_PREFIX);
        this.setRepository(repository);
        this.setConnectionService(connectionService);
    }

    protected Connection getConnection(DataSourcesConfig.Catalog catalog, String role) throws XmlaException {
        Map dsMap = this.getDataSourceEntries();
        Iterator keys = dsMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("DATASOURCE KEY=" + key + " " + key.getClass() + " ,VALUE=" + dsMap.get(key) + " " + dsMap.get(key).getClass()));
        }
        DataSourcesConfig.DataSource ds = catalog.getDataSource();
        ExecutionContext context = null;
        MondrianConnection monConn = this.lookupXmlaConnection(context, ds);
        Util.PropertyList connectProperties = this.getConnectionService().getMondrianConnectProperties(context, monConn);
        if (!"Unauthenticated".equalsIgnoreCase(ds.getAuthenticationMode()) && null == role) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", (Throwable)new SecurityException("Access denied for data source needing authentication"));
        }
        connectProperties.put("role", role);
        RolapConnection conn = (RolapConnection)DriverManager.getConnection((Util.PropertyList)connectProperties, null, (boolean)false);
        return conn;
    }

    protected Connection getConnection(DataSourcesConfig.DataSource ds, String catalogUrl, String role) throws XmlaException {
        ExecutionContext context = null;
        MondrianConnection monConn = this.lookupXmlaConnection(context, ds);
        Util.PropertyList connectProperties = this.getConnectionService().getMondrianConnectProperties(context, monConn);
        if (!"Unauthenticated".equalsIgnoreCase(ds.getAuthenticationMode()) && null == role) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", (Throwable)new SecurityException("Access denied for data source needing authentication"));
        }
        connectProperties.put("role", role);
        RolapConnection conn = (RolapConnection)DriverManager.getConnection((Util.PropertyList)connectProperties, null, (boolean)false);
        return conn;
    }

    protected Connection getConnection(XmlaRequest request) throws XmlaException {
        log.debug((Object)"XmlaHandlerImpl:getConnection");
        Map dataSourcesMap = this.getDataSourceEntries();
        Map properties = request.getProperties();
        String dataSourceInfo = (String)properties.get("DataSourceInfo");
        if (!dataSourcesMap.containsKey(dataSourceInfo)) {
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", (Throwable)Util.newError((String)("no data source is configured with name '" + dataSourceInfo + "'")));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("XmlaHandlerImpl.getConnection: dataSourceInfo=" + dataSourceInfo));
        }
        DataSourcesConfig.DataSource ds = (DataSourcesConfig.DataSource)dataSourcesMap.get(dataSourceInfo);
        if (log.isDebugEnabled()) {
            if (ds == null) {
                log.debug((Object)"XmlaHandlerImpl.getConnection: ds is null");
            } else {
                log.debug((Object)("XmlaHandlerImpl.getConnection: ds.dataSourceInfo=" + ds.getDataSourceInfo()));
            }
        }
        ExecutionContext context = null;
        MondrianConnection monConn = this.lookupXmlaConnection(context, ds);
        Util.PropertyList connectProperties = this.getConnectionService().getMondrianConnectProperties(context, monConn);
        if (!"Unauthenticated".equalsIgnoreCase(ds.getAuthenticationMode()) && null == request.getRole()) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", (Throwable)new SecurityException("Access denied for data source needing authentication"));
        }
        connectProperties.put("role", request.getRole());
        RolapConnection conn = (RolapConnection)DriverManager.getConnection((Util.PropertyList)connectProperties, null, (boolean)false);
        return conn;
    }

    protected MondrianConnection lookupXmlaConnection(ExecutionContext context, DataSourcesConfig.DataSource ds) {
        FilterCriteria f;
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up DataSource name=" + ds.name + ", info=" + ds.dataSourceInfo + ", url=" + ds.url));
        }
        MondrianConnection result = null;
        RepositoryService rep = this.getRepository();
        List lookups = rep.loadResourcesList(context, f = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition = XmlaHandlerImpl.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition)));
        if (lookups == null || lookups.size() == 0) {
            log.error((Object)"No XMLA Definitions");
        } else {
            Iterator it = lookups.iterator();
            while (it.hasNext()) {
                MondrianXMLADefinition xmlaDef = (MondrianXMLADefinition)rep.getResource(context, ((ResourceLookup)it.next()).getURIString());
                if (ds.name == null || !ds.name.endsWith("DataSource=" + xmlaDef.getCatalog() + ";")) continue;
                result = (MondrianConnection)this.getConnectionService().dereference(context, xmlaDef.getMondrianConnection());
                log.debug((Object)("Connection Found for catalog: " + xmlaDef.getCatalog()));
                break;
            }
        }
        if (result == null) {
            log.error((Object)("Mondrian XMLA Definition not found for name: " + ds.name));
        }
        return result;
    }

    public OlapConnectionService getConnectionService() {
        return this.mConnectionService;
    }

    public void setConnectionService(OlapConnectionService cs) {
        this.mConnectionService = cs;
    }

    public RepositoryService getRepository() {
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

