/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.InputControlWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportUnitWrapper;
import com.jaspersoft.jasperserver.war.util.ServletContextInformation;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ReportDetailsValidator
implements Validator {
    private RepositoryService repository;
    private ServletContextInformation servletContextInformation;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$ReportUnitWrapper;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class clazz) {
        return (class$com$jaspersoft$jasperserver$war$dto$ReportUnitWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$ReportUnitWrapper = ReportDetailsValidator.class$("com.jaspersoft.jasperserver.war.dto.ReportUnitWrapper")) : class$com$jaspersoft$jasperserver$war$dto$ReportUnitWrapper).isAssignableFrom(clazz);
    }

    public void validate(Object o, Errors errors) {
        ReportUnitWrapper reportDetails = (ReportUnitWrapper)o;
        this.validateNameLabelDesc(reportDetails, errors);
        this.validateJrxmlUpload(reportDetails, errors);
        this.validateReportViewForm(reportDetails, errors);
    }

    public void validateNameLabelDesc(ReportUnitWrapper ruWrapper, Errors errors) {
        ReportUnit ru = ruWrapper.getReportUnit();
        if (ru.getLabel() == null || ru.getLabel().trim().length() == 0) {
            errors.rejectValue("reportUnit.label", "ReportDetailsValidator.error.not.empty");
        } else if (ruWrapper.getReportUnit().getLabel().length() > 100) {
            errors.rejectValue("reportUnit.label", "ReportDetailsValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateLabel(ru.getLabel())) {
            errors.rejectValue("reportUnit.label", "ReportDetailsValidator.error.invalid.chars");
        }
        if (ru.getName() == null || ru.getName().trim().length() == 0) {
            errors.rejectValue("reportUnit.name", "ReportDetailsValidator.error.not.empty");
        } else if (ru.getName().length() > 100) {
            errors.rejectValue("reportUnit.name", "ReportDetailsValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateName(ru.getName())) {
            errors.rejectValue("reportUnit.name", "ReportDetailsValidator.error.invalid.chars");
        } else if (ruWrapper.isAloneNewMode() && this.repository.resourceExists(null, ru.getURIString())) {
            errors.rejectValue("reportUnit.name", "ReportDetailsValidator.error.duplicate");
        }
        if (ru.getDescription() != null && ru.getDescription().length() > 250) {
            errors.rejectValue("reportUnit.description", "ReportDetailsValidator.error.too.long");
        }
    }

    public void validateURIString(ReportUnitWrapper reportUnit, Errors errors) {
        if (reportUnit.getSource() == null) {
            errors.rejectValue("source", "ReportDetailsValidator.error.invalid.jrxml");
        } else if (reportUnit.getSource().equals("CONTENT_REPOSITORY") && (reportUnit.getJrxmlUri() == null || reportUnit.getJrxmlUri().length() == 0)) {
            errors.rejectValue("jrxmlUri", "ReportDetailsValidator.error.not.reusable");
        }
    }

    public void validateJrxmlUpload(ReportUnitWrapper wrapper, Errors errors) {
        if (wrapper.getSource() == null) {
            errors.rejectValue("source", "ReportDetailsValidator.error.invalid.jrxml");
        } else if (wrapper.getSource().equals("FILE_SYSTEM") && !wrapper.isJrxmlLocated() && (wrapper.getJrxmlData() == null || wrapper.getJrxmlData().length == 0)) {
            errors.rejectValue("jrxmlData", "ReportDetailsValidator.error.invalid.jrxml");
        }
    }

    public void validateResources(ReportUnitWrapper wrapper, Errors errors) {
        List sugContr;
        boolean allResLocated = true;
        boolean allControlsLocated = true;
        List sugRes = wrapper.getSuggestedResources();
        if (sugRes != null && !sugRes.isEmpty()) {
            for (int i = 0; i < sugRes.size(); ++i) {
                FileResourceWrapper resWrap = (FileResourceWrapper)sugRes.get(i);
                if (resWrap.isLocated()) continue;
                allResLocated = false;
                break;
            }
        }
        if ((sugContr = wrapper.getSuggestedControls()) != null && !sugContr.isEmpty()) {
            for (int i = 0; i < sugContr.size(); ++i) {
                InputControlWrapper icWrap = (InputControlWrapper)sugContr.get(i);
                if (icWrap.isLocated()) continue;
                allControlsLocated = false;
                break;
            }
        }
        if (!allControlsLocated && !allResLocated) {
            errors.rejectValue("validationMessage", "ReportDetailsValidator.error.controls.resources.located");
        } else if (!allControlsLocated) {
            errors.rejectValue("validationMessage", "ReportDetailsValidator.error.controls.located");
        } else if (!allResLocated) {
            errors.rejectValue("validationMessage", "ReportDetailsValidator.error.resources.located");
        }
        this.validateInputControlView(wrapper, errors);
    }

    protected void validateInputControlView(ReportUnitWrapper wrapper, Errors errors) {
        String inputControlRenderingView = wrapper.getReportUnit().getInputControlRenderingView();
        if (inputControlRenderingView != null && inputControlRenderingView.length() > 0) {
            if (inputControlRenderingView.length() > 100) {
                errors.rejectValue("reportUnit.inputControlRenderingView", "ReportDetailsValidator.error.too.long");
            } else if (!this.getServletContextInformation().jspExists(inputControlRenderingView)) {
                errors.rejectValue("reportUnit.inputControlRenderingView", "ReportDetailsValidator.error.inexisting.jsp");
            }
        }
    }

    public void validateReportViewForm(ReportUnitWrapper wrapper, Errors errors) {
        String reportRenderingView = wrapper.getReportUnit().getReportRenderingView();
        if (reportRenderingView != null && reportRenderingView.length() > 0) {
            if (reportRenderingView.length() > 100) {
                errors.rejectValue("reportUnit.reportRenderingView", "ReportDetailsValidator.error.too.long");
            } else if (!this.getServletContextInformation().jspExists(reportRenderingView)) {
                errors.rejectValue("reportUnit.reportRenderingView", "ReportDetailsValidator.error.inexisting.jsp");
            }
        }
    }

    public ServletContextInformation getServletContextInformation() {
        return this.servletContextInformation;
    }

    public void setServletContextInformation(ServletContextInformation servletContextInformation) {
        this.servletContextInformation = servletContextInformation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

