/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.InputControlWrapper;
import com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class OlapClientConnectionValidator
implements Validator {
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper;

    public boolean supports(Class clazz) {
        return (class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper = OlapClientConnectionValidator.class$("com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper")) : class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper).isAssignableFrom(clazz);
    }

    public void validate(Object object, Errors errors) {
        OlapClientConnectionWrapper details = (OlapClientConnectionWrapper)object;
        this.validateNameLabelDesc(details, errors);
        this.validateSchemaUpload(details, errors);
    }

    public void validateNameLabelDesc(OlapClientConnectionWrapper wrapper, Errors errors) {
        if (wrapper.getConnectionLabel() == null || wrapper.getConnectionLabel().trim().length() == 0) {
            errors.rejectValue("connectionLabel", "OlapClientConnectionValidator.error.not.empty");
        } else if (wrapper.getConnectionLabel().length() > 100) {
            errors.rejectValue("connectionLabel", "OlapClientConnectionValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateLabel(wrapper.getConnectionLabel())) {
            errors.rejectValue("connectionLabel", "OlapClientConnectionValidator.error.invalid.chars");
        }
        if (wrapper.getConnectionName() == null || wrapper.getConnectionName().trim().length() == 0) {
            errors.rejectValue("connectionName", "OlapClientConnectionValidator.error.not.empty");
        } else if (wrapper.getConnectionName().length() > 100) {
            errors.rejectValue("connectionName", "OlapClientConnectionValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateName(wrapper.getConnectionName())) {
            errors.rejectValue("connectionName", "OlapClientConnectionValidator.error.invalid.chars");
        } else if (wrapper.isNewMode() && wrapper.getExistingResources() != null) {
            List res = wrapper.getExistingResources();
            for (int i = 0; i < res.size(); ++i) {
                String preExtName = (String)res.get(i);
                if (!preExtName.equalsIgnoreCase(wrapper.getConnectionName().trim())) continue;
                errors.rejectValue("connectionName", "OlapClientConnectionValidator.error.duplicate");
                break;
            }
        }
        if (wrapper.getConnectionDescription() != null && wrapper.getConnectionDescription().length() > 300) {
            errors.rejectValue("connectionDescription", "OlapClientConnectionValidator.error.too.long");
        }
    }

    public void validateNameLabelDescAndXmlaSource(OlapClientConnectionWrapper wrapper, Errors errors) {
        this.validateNameLabelDesc(wrapper, errors);
        if (wrapper.getXmlaDatasource() == null || wrapper.getXmlaDatasource().trim().length() == 0) {
            errors.rejectValue("xmlaDatasource", "OlapClientConnectionValidator.error.not.empty");
        }
        if (wrapper.getXmlaConnectionUri() == null || wrapper.getXmlaConnectionUri().trim().length() == 0) {
            errors.rejectValue("xmlaConnectionUri", "OlapClientConnectionValidator.error.not.empty");
        }
        if (wrapper.getUsername() == null || wrapper.getUsername().trim().length() == 0) {
            errors.rejectValue("username", "OlapClientConnectionValidator.error.not.empty");
        }
        if (wrapper.getPassword() == null || wrapper.getPassword().trim().length() == 0) {
            errors.rejectValue("password", "OlapClientConnectionValidator.error.not.empty");
        }
    }

    public void validateURIString(OlapClientConnectionWrapper olapUnit, Errors errors) {
        if (olapUnit.getSource() == null) {
            errors.rejectValue("source", "OlapClientConnectionValidator.error.invalid.schema");
        } else if (olapUnit.getSource().equals("CONTENT_REPOSITORY") && (olapUnit.getSchemaUri() == null || olapUnit.getSchemaUri().length() == 0)) {
            errors.rejectValue("schemaUri", "OlapClientConnectionValidator.error.not.reusable");
        }
    }

    public void validateSchemaUpload(OlapClientConnectionWrapper wrapper, Errors errors) {
    }

    public void validateResources(OlapClientConnectionWrapper wrapper, Errors errors) {
        List sugContr;
        boolean allResLocated = true;
        boolean allControlsLocated = true;
        List sugRes = wrapper.getSuggestedResources();
        if (sugRes != null && !sugRes.isEmpty()) {
            for (int i = 0; i < sugRes.size(); ++i) {
                FileResourceWrapper resWrap = (FileResourceWrapper)sugRes.get(i);
                if (resWrap.isLocated()) continue;
                allResLocated = false;
                break;
            }
        }
        if ((sugContr = wrapper.getSuggestedControls()) != null && !sugContr.isEmpty()) {
            for (int i = 0; i < sugContr.size(); ++i) {
                InputControlWrapper icWrap = (InputControlWrapper)sugContr.get(i);
                if (icWrap.isLocated()) continue;
                allControlsLocated = false;
                break;
            }
        }
        if (!allControlsLocated && !allResLocated) {
            errors.rejectValue("validationMessage", "OlapClientConnectionValidator.error.controls.resources.located");
        } else if (!allControlsLocated) {
            errors.rejectValue("validationMessage", "OlapClientConnectionValidator.error.controls.located");
        } else if (!allResLocated) {
            errors.rejectValue("validationMessage", "OlapClientConnectionValidator.error.resources.located");
        }
    }

    public void validateConnectionType(OlapClientConnectionWrapper wrapper, Errors errors) {
        if (wrapper.getType() == null) {
            errors.rejectValue("source", "OlapClientConnectionValidator.error.no.connection.type");
        }
    }

    public void validateConnectionSource(OlapClientConnectionWrapper wrapper, Errors errors) {
        if (wrapper.getSource() == null) {
            errors.rejectValue("source", "OlapClientConnectionValidator.error.no.connection.source");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

