/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerConst;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FolderWrapper;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class FolderValidator
implements Validator {
    private RepositoryService repository;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$FolderWrapper;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class clazz) {
        return (class$com$jaspersoft$jasperserver$war$dto$FolderWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$FolderWrapper = FolderValidator.class$("com.jaspersoft.jasperserver.war.dto.FolderWrapper")) : class$com$jaspersoft$jasperserver$war$dto$FolderWrapper).isAssignableFrom(clazz);
    }

    public void validate(Object object, Errors errors) {
        FolderWrapper wrapper = (FolderWrapper)object;
        Folder folder = wrapper.getActualFolder();
        if (folder.getName() == null || this.size(folder.getName()) == 0) {
            errors.rejectValue("actualFolder.name", "error.not.empty");
        } else if (!JasperServerUtil.regExValidateName(folder.getName())) {
            errors.rejectValue("actualFolder.name", "FolderValidator.error.invalid.chars");
        } else if (folder.getName().trim().length() > 30) {
            errors.rejectValue("actualFolder.name", "FolderValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_NAME_W}, null);
        } else if (!wrapper.isEdit() && this.repository.folderExists(null, folder.getURIString())) {
            errors.rejectValue("actualFolder.name", "FolderValidator.error.duplicate");
        }
        if (folder.getLabel() == null || this.size(folder.getLabel()) == 0) {
            errors.rejectValue("actualFolder.label", "FolderValidator.error.not.empty");
        } else if (!JasperServerUtil.regExValidateLabel(folder.getLabel())) {
            errors.rejectValue("actualFolder.label", "FolderValidator.error.invalid.chars");
        } else if (folder.getLabel().trim().length() > 30) {
            errors.rejectValue("actualFolder.label", "FolderValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_LABEL_W}, null);
        }
        if (folder.getDescription() != null && this.size(folder.getDescription()) > 100) {
            errors.rejectValue("actualFolder.description", "FolderValidator.error.too.long", new Object[]{JasperServerConst.MAX_LENGTH_DESC_W}, null);
        }
    }

    private int size(String text) {
        return text.trim().length();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

