/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.DataTypeWrapper;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class DataTypeValidator
implements Validator {
    private RepositoryService repository;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class klass) {
        return (class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper = DataTypeValidator.class$("com.jaspersoft.jasperserver.war.dto.DataTypeWrapper")) : class$com$jaspersoft$jasperserver$war$dto$DataTypeWrapper).isAssignableFrom(klass);
    }

    public void validate(Object object, Errors errors) {
        DataTypeWrapper wrapper = (DataTypeWrapper)object;
        DataType dataType = wrapper.getDataType();
        if (dataType.getName() == null || dataType.getName().trim().length() == 0) {
            errors.rejectValue("dataType.name", "DataTypeValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateName(dataType.getName())) {
                errors.rejectValue("dataType.name", "DataTypeValidator.error.invalid.chars");
            }
            if (dataType.getName().length() > 100) {
                errors.rejectValue("dataType.name", "DataTypeValidator.error.too.long");
            }
            if (wrapper.isAloneNewMode() && this.repository.resourceExists(null, dataType.getURIString())) {
                errors.rejectValue("dataType.name", "DataTypeValidator.error.duplicate");
            }
        }
        if (dataType.getLabel() == null || dataType.getLabel().trim().length() == 0) {
            errors.rejectValue("dataType.label", "DataTypeValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateLabel(dataType.getLabel())) {
                errors.rejectValue("dataType.label", "DataTypeValidator.error.invalid.chars");
            }
            if (dataType.getLabel().length() > 100) {
                errors.rejectValue("dataType.label", "DataTypeValidator.error.too.long");
            }
        }
        if (dataType.getDescription() != null && dataType.getDescription().length() > 250) {
            errors.rejectValue("dataType.description", "DataTypeValidator.error.too.long");
        }
        String strMinValue = (String)((Object)dataType.getMinValue());
        String strMaxValue = (String)((Object)dataType.getMaxValue());
        if (strMinValue != null && strMinValue.length() == 0) {
            dataType.setMinValue(null);
        }
        if (strMaxValue != null && strMaxValue.length() == 0) {
            dataType.setMaxValue(null);
        }
        if (strMinValue != null && strMinValue.length() > 100) {
            errors.rejectValue("dataType.minValue", "DataTypeValidator.error.too.long");
        }
        if (strMaxValue != null && strMaxValue.length() > 100) {
            errors.rejectValue("dataType.maxValue", "DataTypeValidator.error.too.long");
        }
        if (dataType.getRegularExpr() != null && dataType.getRegularExpr().length() > 100) {
            errors.rejectValue("dataType.regularExpr", "DataTypeValidator.error.too.long");
        }
        if (dataType.getType() == 2) {
            BigDecimal maxValue;
            BigDecimal minValue;
            block25: {
                block24: {
                    minValue = null;
                    maxValue = null;
                    try {
                        minValue = new BigDecimal(strMinValue);
                    }
                    catch (NumberFormatException e) {
                        if (strMinValue.length() <= 0) break block24;
                        errors.rejectValue("dataType.minValue", "DataTypeValidator.error.invalid.number");
                    }
                }
                try {
                    maxValue = new BigDecimal(strMaxValue);
                }
                catch (NumberFormatException e) {
                    if (strMaxValue.length() <= 0) break block25;
                    errors.rejectValue("dataType.maxValue", "DataTypeValidator.error.invalid.number");
                }
            }
            if (minValue != null && maxValue != null && minValue.compareTo(maxValue) >= 0) {
                errors.rejectValue("dataType.minValue", "DataTypeValidator.error.larger.than.max");
            }
        }
        if (dataType.getType() == 1 && dataType.getRegularExpr() != null && dataType.getRegularExpr().trim().length() > 0) {
            if (strMinValue != null && strMinValue.trim().length() > 0 && !Pattern.matches(dataType.getRegularExpr(), strMinValue)) {
                errors.rejectValue("dataType.minValue", "DataTypeValidator.error.pattern");
            }
            if (strMaxValue != null && strMaxValue.trim().length() > 0 && !Pattern.matches(dataType.getRegularExpr(), strMaxValue)) {
                errors.rejectValue("dataType.maxValue", "DataTypeValidator.error.pattern");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

