/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.tags.PaginatorLinksTag;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PaginatorTag
extends TagSupport {
    public static final String CURRENT_PAGE_REQUEST_PARAMETER = "currentPage";
    public static final String PAGINATED_ITEMS_REQUEST_PARAMETER = "paginatedItems";
    public static final String PAGINATOR_INFO_REQUEST_PARAMETER = "paginatorInfo";
    private List items = null;
    private String page = null;
    private String strItemsPerPage = null;
    private String strPagesRange = null;

    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getItemsPerPage() {
        return this.strItemsPerPage;
    }

    public void setItemsPerPage(String itemsPerPage) {
        this.strItemsPerPage = itemsPerPage;
    }

    public String getPagesRange() {
        return this.strPagesRange;
    }

    public void setPagesRange(String pagesRange) {
        this.strPagesRange = pagesRange;
    }

    public int doStartTag() throws JspException {
        if (this.items == null || this.items.size() == 0) {
            return 0;
        }
        int itemsPerPage = -1;
        if (this.strItemsPerPage != null && this.strItemsPerPage.trim().length() > 0) {
            itemsPerPage = Integer.parseInt(this.strItemsPerPage);
        }
        if (itemsPerPage <= 0) {
            itemsPerPage = ((ConfigurationBean)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext()).getBean("configurationBean")).getPaginatorItemsPerPage();
        }
        int pagesRange = -1;
        if (this.strPagesRange != null && this.strPagesRange.trim().length() > 0) {
            pagesRange = Integer.parseInt(this.strPagesRange);
        }
        if (pagesRange <= 0) {
            pagesRange = ((ConfigurationBean)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext()).getBean("configurationBean")).getPaginatorPagesRange();
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        int allItemsCount = this.items.size();
        int allPagesCount = allItemsCount / itemsPerPage;
        if (allItemsCount % itemsPerPage > 0) {
            ++allPagesCount;
        }
        List paginatedItems = null;
        int crtPage = 1;
        String strCrtPage = request.getParameter(CURRENT_PAGE_REQUEST_PARAMETER);
        if (strCrtPage == null || strCrtPage.trim().length() == 0) {
            strCrtPage = this.page;
        }
        if (strCrtPage != null && strCrtPage.trim().length() > 0) {
            crtPage = Integer.parseInt(strCrtPage);
        }
        if (allItemsCount <= crtPage * itemsPerPage) {
            crtPage = allPagesCount;
        }
        paginatedItems = allItemsCount < crtPage * itemsPerPage ? this.items.subList((crtPage - 1) * itemsPerPage, allItemsCount) : this.items.subList((crtPage - 1) * itemsPerPage, crtPage * itemsPerPage);
        PaginatorLinksTag.PaginatorInfo info = new PaginatorLinksTag.PaginatorInfo();
        info.currentPage = crtPage;
        info.firstPage = crtPage - pagesRange >= 1 ? crtPage - pagesRange : 1;
        info.lastPage = info.firstPage + 2 * pagesRange;
        info.lastPage = info.lastPage <= allPagesCount ? info.lastPage : allPagesCount;
        info.firstPage = info.lastPage - 2 * pagesRange;
        info.firstPage = info.firstPage >= 1 ? info.firstPage : 1;
        info.pageCount = allPagesCount;
        request.setAttribute(PAGINATED_ITEMS_REQUEST_PARAMETER, paginatedItems);
        request.setAttribute(PAGINATOR_INFO_REQUEST_PARAMETER, (Object)info);
        return 1;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        request.setAttribute(PAGINATED_ITEMS_REQUEST_PARAMETER, null);
        request.setAttribute(PAGINATOR_INFO_REQUEST_PARAMETER, null);
        return 6;
    }
}

