/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.war.control.JRBaseMultiActionController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;

public class LoginController
extends JRBaseMultiActionController {
    private static Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$control$LoginController == null ? (class$com$jaspersoft$jasperserver$war$control$LoginController = LoginController.class$("com.jaspersoft.jasperserver.war.control.LoginController")) : class$com$jaspersoft$jasperserver$war$control$LoginController));
    private List homePageByRole;
    private List homePageByRoleEntries;
    private String defaultHomePage = "home";
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$control$LoginController;

    public ModelAndView homePage(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
            return new ModelAndView("loginError");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() == null) {
            return new ModelAndView("home");
        }
        User user = (User)auth.getPrincipal();
        return new ModelAndView(this.getBestHomeURLForUser(user));
    }

    public ModelAndView loginSuccess(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        User user;
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
            return new ModelAndView("loginError");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() == null) {
            return new ModelAndView("loginError");
        }
        log.debug((Object)("Authentication class: " + auth.getClass() + " Authentication principal class: " + auth.getPrincipal().getClass()));
        if (!(auth.getPrincipal() instanceof MetadataUserDetails)) {
            Object principal = auth.getPrincipal();
            String username = null;
            if (principal instanceof UserDetails) {
                username = ((UserDetails)auth.getPrincipal()).getUsername();
            } else if (principal instanceof String) {
                username = (String)principal;
            }
            log.debug((Object)("External user: " + username));
            user = this.getUserAuthService().getUser((ExecutionContext)new ExecutionContextImpl(), username);
        } else {
            user = (User)auth.getPrincipal();
        }
        return new ModelAndView(this.getBestHomeURLForUser(user));
    }

    private String getBestHomeURLForUser(User user) {
        if (this.getHomePageByRole() == null || this.getHomePageByRole().size() == 0) {
            log.debug((Object)("Set home page for user: " + user.getUsername() + " to default: " + this.getDefaultHomePage()));
            return this.getDefaultHomePage();
        }
        Iterator it = this.getHomePageByRoleEntries().iterator();
        while (it.hasNext()) {
            RoleHomePage entry = (RoleHomePage)it.next();
            if (!this.hasRole(user, entry.getRoleName())) continue;
            log.debug((Object)("Set home page for user: " + user.getUsername() + " based on role: " + entry.getRoleName() + "  to: " + entry.getHomePageURL()));
            return entry.getHomePageURL();
        }
        log.debug((Object)("Set home page for user: " + user.getUsername() + " to default: " + this.getDefaultHomePage()));
        return this.getDefaultHomePage();
    }

    private boolean hasRole(User u, String roleName) {
        if (u == null || u.getRoles().size() == 0) {
            log.debug((Object)("No roles on user: " + u + " to check for role: " + roleName));
            return false;
        }
        Iterator it = u.getRoles().iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            if (!r.getRoleName().equalsIgnoreCase(roleName)) continue;
            log.debug((Object)("Found role " + roleName + " on user: " + u));
            return true;
        }
        log.debug((Object)("Found NO role " + roleName + " on user: " + u));
        return false;
    }

    public String getDefaultHomePage() {
        return this.defaultHomePage;
    }

    public void setDefaultHomePage(String defaultHomePage) {
        this.defaultHomePage = defaultHomePage;
    }

    public List getHomePageByRole() {
        return this.homePageByRole;
    }

    public void setHomePageByRole(List homePageByRole) {
        this.homePageByRole = homePageByRole;
        if (homePageByRole == null) {
            this.setHomePageByRoleEntries(null);
            return;
        }
        ArrayList<RoleHomePage> entriesList = new ArrayList<RoleHomePage>(homePageByRole.size());
        Iterator it = homePageByRole.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            int pos = str.indexOf(124);
            if (pos == -1) {
                throw new RuntimeException("Invalid home page entry (needs | to separate role and URL:" + str);
            }
            RoleHomePage entry = new RoleHomePage(str.substring(0, pos), str.substring(pos + 1));
            entriesList.add(entry);
        }
        this.setHomePageByRoleEntries(entriesList);
    }

    public List getHomePageByRoleEntries() {
        return this.homePageByRoleEntries;
    }

    public void setHomePageByRoleEntries(List homePageByRoleEntries) {
        this.homePageByRoleEntries = homePageByRoleEntries;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RoleHomePage {
        private String roleName;
        private String homePageURL;

        public RoleHomePage(String roleName, String homePageURL) {
            this.roleName = roleName;
            this.homePageURL = homePageURL;
        }

        public String getHomePageURL() {
            return this.homePageURL;
        }

        public void setHomePageURL(String homePageURL) {
            this.homePageURL = homePageURL;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }
    }
}

