/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiteMenu {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$common$SiteMenu == null ? (class$com$jaspersoft$jasperserver$war$common$SiteMenu = SiteMenu.class$("com.jaspersoft.jasperserver.war.common.SiteMenu")) : class$com$jaspersoft$jasperserver$war$common$SiteMenu));
    private final String URL_ATTR = "url";
    private final String SERVLETPARAMS_ATTR = "servletParams";
    private final String NAME_ATTR = "name";
    private final String MENU_ITEM_NODE_NAME = "menu-item";
    private final String SUB_ITEMS_NODE_NAME = "sub-items";
    private final String ROLES_NODE_NAME = "roles";
    private final String ROLE_NODE_NAME = "role";
    private final String MENU_XML_URI = "/JI-menu.xml";
    private static SiteMenu theInstance;
    private MenuItem mMenu = null;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$common$SiteMenu;

    public static SiteMenu instance() {
        if (theInstance == null) {
            theInstance = new SiteMenu();
        }
        return theInstance;
    }

    public MenuItem getMenu() throws Exception {
        if (this.mMenu == null) {
            this.mMenu = this.parse("/JI-menu.xml");
        }
        return this.mMenu;
    }

    protected MenuItem parse(String menuXmlUri) throws Exception {
        MenuItem result = null;
        try {
            InputStream siteXml = this.getClass().getResourceAsStream(menuXmlUri);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            Document menuDoc = domBuilder.parse(siteXml);
            result = this.parseMenuItem(menuDoc.getDocumentElement());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return result;
    }

    public void printNode(Node n, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(n);
        if (n.hasChildNodes()) {
            for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                this.printNode(n.getChildNodes().item(j), indent + 2);
            }
        }
    }

    protected MenuItem parseMenuItem(Element itemNode) {
        MenuItem menuItem = new MenuItem();
        menuItem.name = itemNode.getAttribute("name");
        if (itemNode.hasAttribute("url")) {
            menuItem.url = itemNode.getAttribute("url");
        }
        if (itemNode.hasAttribute("servletParams")) {
            menuItem.servletParams = itemNode.getAttribute("servletParams");
        }
        ArrayList<MenuItem> subItems = new ArrayList<MenuItem>();
        ArrayList<String> roles = new ArrayList<String>();
        if (itemNode.hasChildNodes()) {
            for (int i = 0; i < itemNode.getChildNodes().getLength(); ++i) {
                Node child = itemNode.getChildNodes().item(i);
                if ("sub-items".equals(child.getNodeName())) {
                    for (int j = 0; j < child.getChildNodes().getLength(); ++j) {
                        Node menuChild = child.getChildNodes().item(j);
                        if (!"menu-item".equals(menuChild.getNodeName())) continue;
                        subItems.add(this.parseMenuItem((Element)menuChild));
                    }
                }
                if (!"roles".equals(child.getNodeName())) continue;
                for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                    Node roleChild = child.getChildNodes().item(k);
                    if (!"role".equals(roleChild.getNodeName())) continue;
                    roles.add(roleChild.getFirstChild().getNodeValue());
                }
            }
        }
        menuItem.subItems = subItems.toArray(new MenuItem[subItems.size()]);
        menuItem.roles = roles.toArray(new String[roles.size()]);
        return menuItem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MenuItem {
        String name;
        String url;
        String servletParams;
        MenuItem[] subItems;
        String[] roles;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getServletParams() {
            return this.servletParams;
        }

        public MenuItem[] getSubItems() {
            return this.subItems;
        }

        public boolean getHasSubItems() {
            return this.subItems != null && this.subItems.length > 0;
        }

        public String[] getRoles() {
            return this.roles;
        }

        public String getRolesStr() {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < this.roles.length; ++i) {
                b.append(this.roles[i]);
                if (i >= this.roles.length - 1) continue;
                b.append(",");
            }
            return b.toString();
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("MenuItem( name=").append(this.name);
            buff.append(" url=").append(this.url);
            buff.append(" servletParams=").append(this.servletParams);
            buff.append(" roles=");
            for (int i = 0; i < this.roles.length; ++i) {
                buff.append(this.roles[i]);
                if (i >= this.roles.length - 1) continue;
                buff.append(",");
            }
            buff.append(" sub-items=");
            for (int j = 0; j < this.subItems.length; ++j) {
                buff.append(this.subItems[j].toString());
                if (j >= this.subItems.length - 1) continue;
                buff.append(",");
            }
            buff.append(" )");
            return buff.toString();
        }
    }
}

