/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action.hyperlinks;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.BaseReportExecutionHyperlinkProducerFactory;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFlowFactory;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import org.springframework.context.i18n.LocaleContextHolder;

public class ReportExecutionHyperlinkProducerFactory
extends BaseReportExecutionHyperlinkProducerFactory
implements HyperlinkProducerFlowFactory {
    private static final long serialVersionUID = 1L;

    public JRHyperlinkProducer getHyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
        HyperlinkProducer hyperlinkProducer = new HyperlinkProducer(request, response);
        return hyperlinkProducer;
    }

    public class HyperlinkProducer
    extends BaseReportExecutionHyperlinkProducerFactory.BaseHyperlinkProducer {
        private final HttpServletResponse response;
        private final String contextPath;
        private final String flowExecutionKey;

        public HyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
            super((BaseReportExecutionHyperlinkProducerFactory)ReportExecutionHyperlinkProducerFactory.this);
            this.response = response;
            this.flowExecutionKey = (String)request.getAttribute("flowExecutionKey");
            this.contextPath = request.getContextPath();
        }

        public String getHyperlink(JRPrintHyperlink hyperlink) {
            String uri = super.getHyperlink(hyperlink);
            return this.response.encodeURL(uri);
        }

        protected void appendSubflowParams(StringBuffer sb) {
            if (this.flowExecutionKey != null) {
                sb.append("&_eventId_drillReport=");
                sb.append("&_flowExecutionKey=");
                sb.append(this.encode(this.flowExecutionKey));
            }
        }

        protected void appendAdditionalParameters(JRPrintHyperlink hyperlink, StringBuffer sb) {
            if (hyperlink.getHyperlinkTarget() == 1) {
                this.appendSubflowParams(sb);
            }
        }

        protected void appendHyperlinkStart(JRPrintHyperlink hyperlink, StringBuffer sb) {
            sb.append(this.contextPath);
        }

        protected Locale getLocale() {
            return LocaleContextHolder.getLocale();
        }
    }
}

