/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.dto.UserWrapper;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class UserAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String FORM_OBJECT_KEY = "user";
    UserAuthorityService userService;
    private ConfigurationBean configuration;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$UserWrapper;

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = UserAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
        binder.registerCustomEditor(class$java$lang$String == null ? (class$java$lang$String = UserAction.class$("java.lang.String")) : class$java$lang$String, "user.username", (PropertyEditor)new StringTrimmerEditor(true));
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public UserAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$UserWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$UserWrapper = UserAction.class$("com.jaspersoft.jasperserver.war.dto.UserWrapper")) : class$com$jaspersoft$jasperserver$war$dto$UserWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Event userList(RequestContext context) {
        List users = this.userService.getUsers(null, null);
        context.getRequestScope().put("users", (Object)users);
        return this.success();
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put("currentPage", (Object)context.getRequestParameters().get("currentPage"));
        return this.success();
    }

    public Event removeUsers(RequestContext context) {
        if (context.getRequestParameters().contains("selectedUsers")) {
            String[] selectedUsers = context.getRequestParameters().getArray("selectedUsers");
            for (int i = 0; i < selectedUsers.length; ++i) {
                this.userService.deleteUser(null, selectedUsers[i]);
            }
        }
        return this.success();
    }

    public Event editUser(RequestContext context) throws Exception {
        UserWrapper wrapper = (UserWrapper)this.getFormObject(context);
        String userName = wrapper.getUser().getUsername();
        RoleImpl defaultRole = new RoleImpl();
        defaultRole.setRoleName("ROLE_USER");
        if (userName != null) {
            wrapper.setAvailableRoles(this.userService.getAvailableRoles(null, userName));
            wrapper.setAssignedRoles(this.userService.getAssignedRoles(null, userName));
        } else {
            List availableRoles = this.userService.getRoles(null, null);
            availableRoles.remove(defaultRole);
            wrapper.setAvailableRoles(availableRoles);
            ArrayList<RoleImpl> assignedRoles = new ArrayList<RoleImpl>();
            assignedRoles.add(defaultRole);
            wrapper.setAssignedRoles(assignedRoles);
        }
        return this.success();
    }

    public Event addRoles(RequestContext context) throws Exception {
        UserWrapper wrapper = (UserWrapper)this.getFormObject(context);
        List availableRoles = wrapper.getAvailableRoles();
        List assignedRoles = wrapper.getAssignedRoles();
        String[] selectedAvailableRoles = this.getComboBoxValues(context, "selectedAvailableRoles");
        if (selectedAvailableRoles == null) {
            return this.success();
        }
        block0: for (int i = 0; i < selectedAvailableRoles.length; ++i) {
            for (int j = 0; j < availableRoles.size(); ++j) {
                Role role = (Role)availableRoles.get(j);
                if (role.getRoleName() == null || !role.getRoleName().equals(selectedAvailableRoles[i])) continue;
                availableRoles.remove(role);
                assignedRoles.add(role);
                continue block0;
            }
        }
        return this.success();
    }

    public Event removeRoles(RequestContext context) throws Exception {
        UserWrapper wrapper = (UserWrapper)this.getFormObject(context);
        List availableRoles = wrapper.getAvailableRoles();
        List assignedRoles = wrapper.getAssignedRoles();
        String[] selectedAssignedRoles = this.getComboBoxValues(context, "selectedAssignedRoles");
        if (selectedAssignedRoles == null) {
            return this.success();
        }
        block0: for (int i = 0; i < selectedAssignedRoles.length; ++i) {
            for (int j = 0; j < assignedRoles.size(); ++j) {
                Role role = (Role)assignedRoles.get(j);
                if (role.getRoleName() == null || !role.getRoleName().equals(selectedAssignedRoles[i])) continue;
                assignedRoles.remove(role);
                availableRoles.add(role);
                continue block0;
            }
        }
        return this.success();
    }

    public Event saveUser(RequestContext context) throws Exception {
        Role role;
        List assignedRoles;
        UserWrapper wrapper = (UserWrapper)this.getFormObject(context);
        User user = wrapper.getUser();
        Set existingRoles = user.getRoles();
        HashMap<String, Role> existingRolesMap = new HashMap<String, Role>();
        if (existingRoles != null) {
            Iterator it = existingRoles.iterator();
            while (it.hasNext()) {
                Role role2 = (Role)it.next();
                existingRolesMap.put(role2.getRoleName(), role2);
            }
        }
        if ((assignedRoles = wrapper.getAssignedRoles()) != null) {
            for (int i = 0; i < assignedRoles.size(); ++i) {
                role = (Role)assignedRoles.get(i);
                if (existingRolesMap.remove(role.getRoleName()) != null) continue;
                user.addRole(role);
            }
        }
        Iterator it = existingRolesMap.values().iterator();
        while (it.hasNext()) {
            role = (Role)it.next();
            user.removeRole(role);
        }
        this.userService.putUser(null, user);
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        User user;
        String userName = context.getRequestParameters().get("userName");
        UserWrapper wrapper = new UserWrapper();
        if (userName != null && userName.length() > 0) {
            user = this.userService.getUser(null, userName);
            wrapper.setMode((byte)2);
        } else {
            user = this.userService.newUser(null);
            wrapper.setMode((byte)1);
        }
        wrapper.setUser(user);
        return wrapper;
    }

    private String[] getComboBoxValues(RequestContext context, String comboBoxName) {
        if (context.getRequestParameters().contains(comboBoxName)) {
            return context.getRequestParameters().getArray(comboBoxName);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

