/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.dto.RoleWrapper;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class RoleAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String FORM_OBJECT_KEY = "role";
    UserAuthorityService userService;
    private ConfigurationBean configuration;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$RoleWrapper;

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = RoleAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
        binder.registerCustomEditor(class$java$lang$String == null ? (class$java$lang$String = RoleAction.class$("java.lang.String")) : class$java$lang$String, "role.roleName", (PropertyEditor)new StringTrimmerEditor(true));
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public RoleAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$RoleWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$RoleWrapper = RoleAction.class$("com.jaspersoft.jasperserver.war.dto.RoleWrapper")) : class$com$jaspersoft$jasperserver$war$dto$RoleWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Event roleList(RequestContext context) {
        List roles = this.userService.getRoles(null, null);
        context.getRequestScope().put("roles", (Object)roles);
        return this.success();
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put("currentPage", (Object)context.getRequestParameters().get("currentPage"));
        return this.success();
    }

    public Event removeRoles(RequestContext context) {
        if (context.getRequestParameters().contains("selectedRoles")) {
            String[] selectedRoles = context.getRequestParameters().getArray("selectedRoles");
            for (int i = 0; i < selectedRoles.length; ++i) {
                this.userService.deleteRole(null, selectedRoles[i]);
            }
        }
        return this.success();
    }

    public Event editRole(RequestContext context) throws Exception {
        RoleWrapper wrapper = (RoleWrapper)this.getFormObject(context);
        String roleName = wrapper.getRole().getRoleName();
        if (roleName != null) {
            wrapper.setUsersNotInRole(this.userService.getUsersNotInRole(null, roleName));
            wrapper.setUsersInRole(this.userService.getUsersInRole(null, roleName));
        } else {
            wrapper.setUsersNotInRole(this.userService.getUsers(null, null));
            wrapper.setUsersInRole(new ArrayList());
        }
        return this.success();
    }

    public Event saveRole(RequestContext context) throws Exception {
        RoleWrapper wrapper = (RoleWrapper)this.getFormObject(context);
        Role role = wrapper.getRole();
        List usersInRole = wrapper.getUsersInRole();
        if (usersInRole != null) {
            for (int i = 0; i < usersInRole.size(); ++i) {
                role.addUser((User)usersInRole.get(i));
            }
        }
        this.userService.putRole(null, role);
        return this.success();
    }

    public Event addUser(RequestContext context) throws Exception {
        RoleWrapper wrapper = (RoleWrapper)this.getFormObject(context);
        List usersNotInRole = wrapper.getUsersNotInRole();
        List usersInRole = wrapper.getUsersInRole();
        String[] selectedUsersNotInRole = this.getComboBoxValues(context, "selectedUsersNotInRole");
        if (selectedUsersNotInRole == null) {
            return this.success();
        }
        block0: for (int i = 0; i < selectedUsersNotInRole.length; ++i) {
            for (int j = 0; j < usersNotInRole.size(); ++j) {
                User user = (User)usersNotInRole.get(j);
                if (user.getUsername() == null || !user.getUsername().equals(selectedUsersNotInRole[i])) continue;
                usersNotInRole.remove(user);
                usersInRole.add(user);
                continue block0;
            }
        }
        return this.success();
    }

    public Event removeUser(RequestContext context) throws Exception {
        RoleWrapper wrapper = (RoleWrapper)this.getFormObject(context);
        List usersNotInRole = wrapper.getUsersNotInRole();
        List usersInRole = wrapper.getUsersInRole();
        String[] selectedUsersInRole = this.getComboBoxValues(context, "selectedUsersInRole");
        if (selectedUsersInRole == null) {
            return this.success();
        }
        block0: for (int i = 0; i < selectedUsersInRole.length; ++i) {
            for (int j = 0; j < usersInRole.size(); ++j) {
                User user = (User)usersInRole.get(j);
                if (user.getUsername() == null || !user.getUsername().equals(selectedUsersInRole[i])) continue;
                usersInRole.remove(user);
                usersNotInRole.add(user);
                continue block0;
            }
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        Role role;
        String roleName = context.getRequestParameters().get("roleName");
        RoleWrapper wrapper = new RoleWrapper();
        if (roleName != null && roleName.length() > 0) {
            role = this.userService.getRole(null, roleName);
            wrapper.setMode((byte)2);
        } else {
            role = this.userService.newRole(null);
            wrapper.setMode((byte)1);
        }
        wrapper.setRole(role);
        return wrapper;
    }

    private String[] getComboBoxValues(RequestContext context, String comboBoxName) {
        if (context.getRequestParameters().contains(comboBoxName)) {
            return context.getRequestParameters().getArray(comboBoxName);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

