/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.war.action.ReportInputControlsAction;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class ReportParametersAction
extends FormAction
implements ReportInputControlsAction {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$action$ReportParametersAction == null ? (class$com$jaspersoft$jasperserver$war$action$ReportParametersAction = ReportParametersAction.class$("com.jaspersoft.jasperserver.war.action.ReportParametersAction")) : class$com$jaspersoft$jasperserver$war$action$ReportParametersAction));
    public static final String INPUTWRAPPERS_ATTR = "wrappers";
    private static final String COLUMN_VALUE_SEPARATOR = " | ";
    private static final int COLUMN_VALUE_SEPARATOR_LENGTH = " | ".length();
    private String reportUnitAttrName;
    private String reportUnitObjectAttrName;
    private String controlsDisplayFormAttrName;
    private String reportDisplayFormAttrName;
    private String calendarDatePatternAttrName;
    private String calendarDatetimePatternAttrName;
    private EngineService engine;
    private RepositoryService repository;
    private MessageSource messages;
    private String hasInputControlsAttrName;
    private String staticDatePattern;
    private CalendarFormatProvider calendarFormatProvider;
    private String inputNamePrefix;
    private String attributeDefaultInputValues;
    private String markerParameterPrefix;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$action$ReportParametersAction;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$List;

    protected Event createWrappers(RequestContext context) {
        ReportUnit reportUnit = this.loadReportUnit(context);
        if (reportUnit == null) {
            return this.error();
        }
        context.getFlowScope().put(this.getReportUnitObjectAttrName(), (Object)reportUnit);
        this.setReportUnitAttributes(context, reportUnit);
        context.getFlowScope().put(this.getCalendarDatePatternAttrName(), (Object)this.getCalendarDatePattern());
        context.getFlowScope().put(this.getCalendarDatetimePatternAttrName(), (Object)this.getCalendarDatetimePattern());
        List wrappers = this.createWrappers(context, reportUnit);
        context.getFlowScope().put(INPUTWRAPPERS_ATTR, (Object)wrappers);
        context.getFlowScope().put(this.getHasInputControlsAttrName(), (Object)(!wrappers.isEmpty() ? 1 : 0));
        boolean needsInput = this.needsInput(context, wrappers);
        return needsInput ? this.yes() : this.no();
    }

    protected void setReportUnitAttributes(RequestContext context, ReportUnit reportUnit) {
        MutableAttributeMap flowScope = context.getFlowScope();
        flowScope.put(this.getControlsDisplayFormAttrName(), (Object)reportUnit.getInputControlRenderingView());
        flowScope.put(this.getReportDisplayFormAttrName(), (Object)reportUnit.getReportRenderingView());
    }

    public String getReportURI(RequestContext context) {
        String reportURI = context.getFlowScope().getString(this.getReportUnitAttrName());
        return reportURI;
    }

    protected ReportUnit loadReportUnit(RequestContext context) {
        String reportUnitUri = (String)context.getFlowScope().get(this.getReportUnitAttrName());
        if (reportUnitUri == null && (reportUnitUri = context.getRequestParameters().get(this.getReportUnitAttrName())) != null) {
            context.getFlowScope().put(this.getReportUnitAttrName(), (Object)reportUnitUri);
        }
        ReportUnit reportUnit = reportUnitUri == null || reportUnitUri.trim().length() == 0 ? null : (ReportUnit)this.repository.getResource(null, reportUnitUri);
        return reportUnit;
    }

    protected boolean needsInput(RequestContext context, List wrappers) {
        return !wrappers.isEmpty();
    }

    public Map getReportParameters(RequestContext context) {
        return this.getParameterValues(context, true);
    }

    protected Map getParameterValues(RequestContext context, boolean requestParsed) {
        Map parameterValues;
        boolean valid;
        List wrappers = this.getInputControlWrappers(context);
        boolean bl = valid = requestParsed || this.parseRequest(context, wrappers, true);
        if (valid || wrappers.size() == 0) {
            String reportUnitUri = this.getReportURI(context);
            parameterValues = this.bindParameterValues(reportUnitUri, wrappers);
            this.addCustomParameters(context, parameterValues);
        } else {
            parameterValues = null;
        }
        return parameterValues;
    }

    public List getInputControlWrappers(RequestContext context) {
        List wrappers = (List)context.getFlowScope().get(INPUTWRAPPERS_ATTR);
        return wrappers;
    }

    protected boolean hasInputs(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        return wrappers != null && !wrappers.isEmpty();
    }

    public void setParameterValues(RequestContext context, Map values) {
        List inputControls = this.getInputControlWrappers(context);
        MapValueProvider valueProvider = new MapValueProvider(values, this.defaultValuesProvider(context));
        this.setInputParameterValues(inputControls, valueProvider);
    }

    public void resetValuesToDefaults(RequestContext context) {
        List inputControls = this.getInputControlWrappers(context);
        this.setInputParameterValues(inputControls, this.defaultValuesProvider(context));
    }

    public static int getDSTSavings(TimeZone tz) {
        if (tz.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    protected void addCustomParameters(RequestContext context, Map parameterValues) {
    }

    protected InputValueProvider initialValueProvider(RequestContext context) {
        return this.defaultValuesProvider(context);
    }

    protected InputValueProvider defaultValuesProvider(RequestContext context) {
        Map defaults = (Map)context.getFlowScope().getRequired(this.getAttributeDefaultInputValues(), class$java$util$Map == null ? (class$java$util$Map = ReportParametersAction.class$("java.util.Map")) : class$java$util$Map);
        return new MapValueProvider(defaults);
    }

    protected void setInputParameterValues(List wrappers, InputValueProvider valueProvider) {
        Iterator it = wrappers.iterator();
        while (it.hasNext()) {
            RuntimeInputControlWrapper inputControl = (RuntimeInputControlWrapper)it.next();
            String inputName = inputControl.getInputControl().getName();
            Object paramValue = valueProvider.getValue(inputName);
            this.setInputControlParameterValue(inputControl, paramValue);
        }
    }

    protected void setInputControlParameterValue(RuntimeInputControlWrapper inputControl, Object paramValue) {
        Object inputValue = this.toInputControlValue(inputControl, paramValue);
        inputControl.setValue(inputValue);
    }

    protected Object toInputControlValue(RuntimeInputControlWrapper inputControl, Object paramValue) {
        Object value;
        if (paramValue == null) {
            return null;
        }
        if (inputControl.isMulti()) {
            Set values = this.toMultiInputControlValue(paramValue);
            value = values;
        } else {
            DataType datatype = this.getDatatype(inputControl.getInputControl());
            value = datatype != null && datatype.getType() == 2 ? this.toInputControlNumber(paramValue) : paramValue;
        }
        return value;
    }

    protected Object toInputControlNumber(Object paramValue) {
        BigDecimal inputValue;
        if (paramValue instanceof Byte || paramValue instanceof Short || paramValue instanceof Integer || paramValue instanceof Long) {
            inputValue = BigDecimal.valueOf(((Number)paramValue).longValue());
        } else if (paramValue instanceof Float || paramValue instanceof Double) {
            inputValue = BigDecimal.valueOf(((Number)paramValue).doubleValue());
        } else if (paramValue instanceof BigDecimal) {
            inputValue = (BigDecimal)paramValue;
        } else if (paramValue instanceof BigInteger) {
            inputValue = new BigDecimal((BigInteger)paramValue);
        } else {
            throw new JSException("exception.report.unrecognized.number.type", new Object[]{paramValue.getClass().getName()});
        }
        return inputValue;
    }

    protected Set toMultiInputControlValue(Object paramValue) {
        ListOrderedSet values = new ListOrderedSet();
        if (paramValue != null) {
            if (paramValue instanceof Collection) {
                values.addAll((Collection)paramValue);
            } else if (paramValue.getClass().isArray()) {
                int length = Array.getLength(paramValue);
                for (int idx = 0; idx < length; ++idx) {
                    Object val = Array.get(paramValue, idx);
                    values.add(val);
                }
            }
        }
        return values;
    }

    protected Map loadDefaultInputValues(RequestContext context, ReportUnit report) {
        String reportURI = report.getURIString();
        HashMap params = new HashMap();
        this.addCustomParameters(context, params);
        Map defaultVals = this.getEngine().getReportInputControlDefaultValues(JasperServerUtil.getExecutionContext(context), reportURI, params);
        return defaultVals;
    }

    protected List createWrappers(RequestContext context, ReportUnit reportUnit) {
        ArrayList<RuntimeInputControlWrapper> wrappers = new ArrayList<RuntimeInputControlWrapper>();
        List inputControls = reportUnit.getInputControls();
        for (int i = 0; i < inputControls.size(); ++i) {
            ResourceReference listOfValuesRef;
            ResourceReference inputControlRef = (ResourceReference)inputControls.get(i);
            InputControl control = inputControlRef.isLocal() ? (InputControl)inputControlRef.getLocalResource() : (InputControl)this.repository.getResource((ExecutionContext)new ExecutionContextImpl(), inputControlRef.getReferenceURI());
            Format format = null;
            ResourceReference dataTypeRef = control.getDataType();
            if (dataTypeRef != null) {
                DataType dataType;
                if (!dataTypeRef.isLocal()) {
                    dataType = (DataType)this.repository.getResource((ExecutionContext)new ExecutionContextImpl(), dataTypeRef.getReferenceURI());
                    control.setDataType(dataType);
                } else {
                    dataType = (DataType)dataTypeRef.getLocalResource();
                }
                switch (dataType.getType()) {
                    case 3: {
                        format = this.getDateFormat(true);
                        break;
                    }
                    case 4: {
                        format = this.getDatetimeFormat(true);
                        format.setTimeZone(JasperServerUtil.getTimezone(context));
                        break;
                    }
                    case 2: {
                        if (dataType.getRegularExpr() == null || dataType.getRegularExpr().length() <= 0) break;
                        format = new DecimalFormat(dataType.getRegularExpr());
                    }
                }
            }
            if ((listOfValuesRef = control.getListOfValues()) != null && !listOfValuesRef.isLocal()) {
                ListOfValues listOfValues = (ListOfValues)this.repository.getResource((ExecutionContext)new ExecutionContextImpl(), listOfValuesRef.getReferenceURI());
                control.setListOfValues(listOfValues);
            }
            RuntimeInputControlWrapper wrapper = new RuntimeInputControlWrapper(control);
            wrapper.setFormat(format);
            ResourceReference queryRef = control.getQuery();
            if (queryRef != null) {
                OrderedMap results = this.executeQuery(control.getQuery(), reportUnit.getDataSource(), wrapper);
                wrapper.setQueryResults((Map)results);
            }
            wrappers.add(wrapper);
        }
        if (!wrappers.isEmpty()) {
            Map defaultVals = this.loadDefaultInputValues(context, reportUnit);
            context.getFlowScope().put(this.getAttributeDefaultInputValues(), (Object)defaultVals);
            InputValueProvider valueProvider = this.initialValueProvider(context);
            this.setInputParameterValues(wrappers, valueProvider);
        }
        return wrappers;
    }

    protected OrderedMap executeQuery(ResourceReference queryReference, ResourceReference dataSourceReference, RuntimeInputControlWrapper wrapper) {
        String[] visibleColumns;
        InputControl control = wrapper.getInputControl();
        String valueColumn = control.getQueryValueColumn();
        OrderedMap results = this.engine.executeQuery(null, queryReference, valueColumn, visibleColumns = control.getQueryVisibleColumns(), dataSourceReference);
        if (results == null) {
            return null;
        }
        LinkedMap inputData = new LinkedMap();
        Iterator it = results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object keyValue = entry.getKey();
            String[] columnValues = (String[])entry.getValue();
            String columnValuesString = "";
            if (columnValues != null && columnValues.length > 0) {
                StringBuffer visibleColumnBuffer = new StringBuffer();
                for (int i = 0; i < columnValues.length; ++i) {
                    visibleColumnBuffer.append(COLUMN_VALUE_SEPARATOR);
                    visibleColumnBuffer.append(columnValues[i] != null ? columnValues[i] : "");
                }
                columnValuesString = visibleColumnBuffer.substring(COLUMN_VALUE_SEPARATOR_LENGTH);
            }
            inputData.put(keyValue.toString(), new Object[]{keyValue, columnValuesString});
        }
        return inputData;
    }

    public Event setInputValues(RequestContext context) {
        List wrappers = this.getInputControlWrappers(context);
        boolean valid = this.parseRequest(context, wrappers, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input values valid: " + valid));
        }
        return this.success();
    }

    protected boolean parseRequest(RequestContext context, List wrappers, boolean interactiveParameters) {
        boolean isValid = true;
        for (int i = 0; i < wrappers.size(); ++i) {
            RuntimeInputControlWrapper wrapper = (RuntimeInputControlWrapper)wrappers.get(i);
            boolean parsed = this.parseRequestInput(context, interactiveParameters, wrapper);
            boolean valueValid = parsed && this.validateValue(wrapper, interactiveParameters);
            isValid = isValid && valueValid;
        }
        return isValid;
    }

    protected boolean parseRequestInput(RequestContext context, boolean interactiveParameters, RuntimeInputControlWrapper wrapper) {
        wrapper.setErrorMessage(null);
        boolean parsed = wrapper.isMulti() ? this.parseRequestValues(context, wrapper, interactiveParameters) : this.parseRequestValue(context, wrapper, interactiveParameters);
        return parsed;
    }

    protected String getParameterName(RuntimeInputControlWrapper wrapper) {
        InputControl control = wrapper.getInputControl();
        String paramName = this.getInputNamePrefix() == null ? control.getName() : this.getInputNamePrefix() + control.getName();
        return paramName;
    }

    protected boolean parseRequestValue(RequestContext context, RuntimeInputControlWrapper wrapper, boolean interactiveParameters) {
        wrapper.setErrorMessage(null);
        ParameterMap requestParameters = context.getRequestParameters();
        String parameterName = this.getParameterName(wrapper);
        if (!interactiveParameters && !requestParameters.contains(parameterName)) {
            return true;
        }
        String strValue = requestParameters.get(parameterName);
        InputControl control = wrapper.getInputControl();
        DataType dataType = this.getDatatype(control);
        if (control.getType() == 1) {
            if (interactiveParameters) {
                wrapper.setValue(strValue != null);
            } else {
                wrapper.setValue(strValue == null || !strValue.equals("false"));
            }
            return true;
        }
        if (strValue != null && strValue.trim().length() == 0) {
            strValue = null;
        }
        if (control.getType() == 3 || control.getType() == 8) {
            wrapper.setValue(this.getLovValue(wrapper, strValue));
            return true;
        }
        if (control.getType() == 4 || control.getType() == 9) {
            wrapper.setValue(this.getQueryValue(wrapper, strValue));
            return true;
        }
        if (dataType == null || strValue == null) {
            wrapper.setValue(null);
            return true;
        }
        switch (dataType.getType()) {
            case 1: {
                wrapper.setValue(strValue);
                break;
            }
            case 2: {
                try {
                    wrapper.setValue(new BigDecimal(strValue));
                }
                catch (NumberFormatException e) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidFloat", null, LocaleContextHolder.getLocale()));
                    wrapper.setValue(strValue);
                }
                break;
            }
            case 3: {
                DateFormat format = this.getDateFormat(interactiveParameters);
                try {
                    wrapper.setValue(format.parse(strValue));
                }
                catch (ParseException e) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidDate", null, LocaleContextHolder.getLocale()));
                    wrapper.setValue(strValue);
                }
                break;
            }
            case 4: {
                DateFormat format = this.getDatetimeFormat(interactiveParameters);
                format.setTimeZone(((DateFormat)wrapper.getFormat()).getTimeZone());
                try {
                    wrapper.setValue(format.parse(strValue));
                }
                catch (ParseException e) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidDateTime", null, LocaleContextHolder.getLocale()));
                    wrapper.setValue(strValue);
                }
                break;
            }
        }
        return wrapper.getErrorMessage() == null;
    }

    protected boolean validateValues(List wrappers, boolean setMissingMessage) {
        boolean valid = true;
        Iterator it = wrappers.iterator();
        while (it.hasNext()) {
            RuntimeInputControlWrapper inputWrapper = (RuntimeInputControlWrapper)it.next();
            valid &= this.validateValue(inputWrapper, setMissingMessage);
        }
        return valid;
    }

    protected boolean validateValue(RuntimeInputControlWrapper wrapper, boolean setMissingMessage) {
        Comparable maxValue;
        boolean empty;
        Object value = wrapper.getValue();
        if (wrapper.isMulti()) {
            empty = value == null || ((Collection)value).isEmpty();
        } else {
            boolean bl = empty = value == null;
        }
        if (empty) {
            if (wrapper.getInputControl().isMandatory()) {
                if (setMissingMessage) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.mandatoryField", null, LocaleContextHolder.getLocale()));
                }
                return false;
            }
            return true;
        }
        DataType dataType = this.getDatatype(wrapper.getInputControl());
        if (dataType == null) {
            return true;
        }
        if (dataType.getType() == 1) {
            String strValue = (String)value;
            if (dataType.getMaxLength() != null && dataType.getMaxLength() < strValue.length()) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidType", null, LocaleContextHolder.getLocale()));
                return false;
            }
            if (dataType.getRegularExpr() != null && dataType.getRegularExpr().trim().length() > 0 && !Pattern.matches(dataType.getRegularExpr(), strValue)) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.invalidPattern", null, LocaleContextHolder.getLocale()));
                return false;
            }
        }
        Comparable compValue = (Comparable)value;
        Comparable minValue = this.realDatatypeValue(dataType, dataType.getMinValue());
        if (minValue != null) {
            if (dataType.isStrictMin()) {
                if (minValue.compareTo(compValue) >= 0) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.smallerThan", null, LocaleContextHolder.getLocale()));
                }
            } else if (minValue.compareTo(compValue) > 0) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.smallerOrEqual", null, LocaleContextHolder.getLocale()));
            }
        }
        if ((maxValue = this.realDatatypeValue(dataType, dataType.getMaxValue())) != null) {
            if (dataType.isStrictMax()) {
                if (maxValue.compareTo(compValue) <= 0) {
                    wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.greaterThan", null, LocaleContextHolder.getLocale()));
                }
            } else if (maxValue.compareTo(compValue) < 0) {
                wrapper.setErrorMessage(this.messages.getMessage("fillParameters.error.greaterOrEqual", null, LocaleContextHolder.getLocale()));
            }
        }
        return wrapper.getErrorMessage() == null;
    }

    protected DataType getDatatype(InputControl control) {
        ResourceReference dataTypeRef = control.getDataType();
        DataType dataType = dataTypeRef == null ? null : (dataTypeRef.isLocal() ? (DataType)dataTypeRef.getLocalResource() : (DataType)this.repository.getResource((ExecutionContext)new ExecutionContextImpl(), dataTypeRef.getReferenceURI()));
        return dataType;
    }

    protected Comparable realDatatypeValue(DataType dataType, Comparable value) {
        Comparable rValue = value;
        if (rValue != null) {
            if (rValue instanceof String && ((String)((Object)rValue)).length() == 0) {
                rValue = null;
            } else if (dataType.getType() == 2) {
                rValue = new BigDecimal((String)((Object)value));
            }
        }
        return rValue;
    }

    protected Object getLovValue(RuntimeInputControlWrapper wrapper, String strValue) {
        return strValue;
    }

    protected Object getQueryValue(RuntimeInputControlWrapper wrapper, String strValue) {
        Object[] result = (Object[])wrapper.getQueryResults().get(strValue);
        Object value = result != null ? result[0] : null;
        return value;
    }

    protected boolean parseRequestValues(RequestContext context, RuntimeInputControlWrapper wrapper, boolean interactiveParameters) {
        String[] strValues;
        InputControl control = wrapper.getInputControl();
        ParameterMap requestParameters = context.getRequestParameters();
        String parameterName = this.getParameterName(wrapper);
        if (!interactiveParameters) {
            String markerParamName = this.getMarkerParameterPrefix() + parameterName;
            if (!requestParameters.contains(parameterName) && !requestParameters.contains(markerParamName)) {
                return true;
            }
        }
        if ((strValues = requestParameters.getArray(parameterName)) == null) {
            strValues = new String[]{};
        }
        if (control.getType() == 6 || control.getType() == 10) {
            ListOrderedSet values = new ListOrderedSet();
            for (int i = 0; i < strValues.length; ++i) {
                values.add(this.getLovValue(wrapper, strValues[i]));
            }
            wrapper.setValue(values);
            return true;
        }
        if (control.getType() == 7 || control.getType() == 11) {
            ListOrderedSet values = new ListOrderedSet();
            for (int i = 0; i < strValues.length; ++i) {
                values.add(this.getQueryValue(wrapper, strValues[i]));
            }
            wrapper.setValue(values);
            return true;
        }
        return true;
    }

    protected DateFormat getDateFormat(boolean interactiveParameters) {
        DateFormat format = interactiveParameters ? this.getCalendarFormatProvider().getDateFormat() : new SimpleDateFormat(this.getStaticDatePattern());
        return format;
    }

    protected DateFormat getDatetimeFormat(boolean interactiveParameters) {
        DateFormat format = interactiveParameters ? this.getCalendarFormatProvider().getDatetimeFormat() : new SimpleDateFormat(this.getStaticDatePattern());
        return format;
    }

    protected Map bindParameterValues(String reportName, List wrappers) {
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        JasperReport report = this.getEngine().getMainJasperReport(null, reportName);
        JRParameter[] parameters = report.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRParameter parameter = parameters[i];
                parametersMap.put(parameter.getName(), parameter);
            }
        }
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        Iterator it = wrappers.iterator();
        while (it.hasNext()) {
            RuntimeInputControlWrapper wrapper = (RuntimeInputControlWrapper)it.next();
            String parameterName = wrapper.getInputControl().getName();
            JRParameter parameter = (JRParameter)parametersMap.get(parameterName);
            if (parameter == null) continue;
            Object value = wrapper.getValue();
            if (value != null) {
                if ((class$java$lang$Number == null ? ReportParametersAction.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(parameter.getValueClass())) {
                    value = this.getParameterNumberValue(wrapper, parameter, value);
                }
                if (wrapper.isMulti()) {
                    value = this.getParameterMultiValue(wrapper, parameter, (Set)value);
                }
            }
            parameterValues.put(parameterName, value);
        }
        return parameterValues;
    }

    protected Object getParameterNumberValue(RuntimeInputControlWrapper wrapper, JRParameter parameter, Object value) {
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = ReportParametersAction.class$("java.lang.Byte")) : class$java$lang$Byte).getName().equals(parameter.getValueClassName())) {
            value = new Byte(((Number)value).byteValue());
        } else if ((class$java$lang$Short == null ? (class$java$lang$Short = ReportParametersAction.class$("java.lang.Short")) : class$java$lang$Short).getName().equals(parameter.getValueClassName())) {
            value = new Short(((Number)value).shortValue());
        } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = ReportParametersAction.class$("java.lang.Integer")) : class$java$lang$Integer).getName().equals(parameter.getValueClassName())) {
            value = new Integer(((Number)value).intValue());
        } else if ((class$java$lang$Long == null ? (class$java$lang$Long = ReportParametersAction.class$("java.lang.Long")) : class$java$lang$Long).getName().equals(parameter.getValueClassName())) {
            value = new Long(((Number)value).longValue());
        } else if ((class$java$lang$Float == null ? (class$java$lang$Float = ReportParametersAction.class$("java.lang.Float")) : class$java$lang$Float).getName().equals(parameter.getValueClassName())) {
            value = new Float(((Number)value).floatValue());
        } else if ((class$java$lang$Double == null ? (class$java$lang$Double = ReportParametersAction.class$("java.lang.Double")) : class$java$lang$Double).getName().equals(parameter.getValueClassName())) {
            value = new Double(((Double)value).longValue());
        }
        return value;
    }

    protected Object getParameterMultiValue(RuntimeInputControlWrapper wrapper, JRParameter parameter, Set values) {
        Object value;
        Class paramType = parameter.getValueClass();
        if (paramType.equals(class$java$lang$Object == null ? (class$java$lang$Object = ReportParametersAction.class$("java.lang.Object")) : class$java$lang$Object) || paramType.equals(class$java$util$Collection == null ? (class$java$util$Collection = ReportParametersAction.class$("java.util.Collection")) : class$java$util$Collection) || paramType.equals(class$java$util$Set == null ? (class$java$util$Set = ReportParametersAction.class$("java.util.Set")) : class$java$util$Set)) {
            value = values;
        } else if (paramType.equals(class$java$util$List == null ? (class$java$util$List = ReportParametersAction.class$("java.util.List")) : class$java$util$List)) {
            value = new ArrayList(values);
        } else if (paramType.isArray()) {
            Class<?> componentType = paramType.getComponentType();
            value = Array.newInstance(componentType, values.size());
            int idx = 0;
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object val = iter.next();
                Array.set(value, idx, val);
                ++idx;
            }
        } else {
            throw new JSException("jsexception.unknown.parameter.type.for.multiple.value.input", new Object[]{paramType.getName()});
        }
        return value;
    }

    protected String getCalendarDatePattern() {
        return this.getCalendarFormatProvider().getCalendarDatePattern();
    }

    protected String getCalendarDatetimePattern() {
        return this.getCalendarFormatProvider().getCalendarDatetimePattern();
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public String getReportUnitAttrName() {
        return this.reportUnitAttrName;
    }

    public void setReportUnitAttrName(String reportUnitAttrName) {
        this.reportUnitAttrName = reportUnitAttrName;
    }

    public String getHasInputControlsAttrName() {
        return this.hasInputControlsAttrName;
    }

    public void setHasInputControlsAttrName(String hasInputControlsAttrName) {
        this.hasInputControlsAttrName = hasInputControlsAttrName;
    }

    public String getStaticDatePattern() {
        return this.staticDatePattern;
    }

    public void setStaticDatePattern(String staticDatePattern) {
        this.staticDatePattern = staticDatePattern;
    }

    public String getReportUnitObjectAttrName() {
        return this.reportUnitObjectAttrName;
    }

    public void setReportUnitObjectAttrName(String reportUnitObjectAttrName) {
        this.reportUnitObjectAttrName = reportUnitObjectAttrName;
    }

    public String getControlsDisplayFormAttrName() {
        return this.controlsDisplayFormAttrName;
    }

    public void setControlsDisplayFormAttrName(String controlsDisplayFormAttrName) {
        this.controlsDisplayFormAttrName = controlsDisplayFormAttrName;
    }

    public String getReportDisplayFormAttrName() {
        return this.reportDisplayFormAttrName;
    }

    public void setReportDisplayFormAttrName(String reportDisplayFormAttrName) {
        this.reportDisplayFormAttrName = reportDisplayFormAttrName;
    }

    public String getCalendarDatePatternAttrName() {
        return this.calendarDatePatternAttrName;
    }

    public void setCalendarDatePatternAttrName(String calendarDatePatternAttrName) {
        this.calendarDatePatternAttrName = calendarDatePatternAttrName;
    }

    public CalendarFormatProvider getCalendarFormatProvider() {
        return this.calendarFormatProvider;
    }

    public void setCalendarFormatProvider(CalendarFormatProvider calendarFormatProvider) {
        this.calendarFormatProvider = calendarFormatProvider;
    }

    public String getCalendarDatetimePatternAttrName() {
        return this.calendarDatetimePatternAttrName;
    }

    public void setCalendarDatetimePatternAttrName(String calendarDatetimePatternAttrName) {
        this.calendarDatetimePatternAttrName = calendarDatetimePatternAttrName;
    }

    public String getInputNamePrefix() {
        return this.inputNamePrefix;
    }

    public void setInputNamePrefix(String inputNamePrefix) {
        this.inputNamePrefix = inputNamePrefix;
    }

    public String getAttributeDefaultInputValues() {
        return this.attributeDefaultInputValues;
    }

    public void setAttributeDefaultInputValues(String attributeDefaultInputValues) {
        this.attributeDefaultInputValues = attributeDefaultInputValues;
    }

    public String getMarkerParameterPrefix() {
        return this.markerParameterPrefix;
    }

    public void setMarkerParameterPrefix(String markerParameterPrefix) {
        this.markerParameterPrefix = markerParameterPrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class MapValueProvider
    extends InputValueProvider {
        private final Map values;

        public MapValueProvider(Map values) {
            this.values = values;
        }

        public MapValueProvider(Map values, InputValueProvider parent) {
            super(parent);
            this.values = values;
        }

        protected boolean hasOwnValue(String inputName) {
            return this.values.containsKey(inputName);
        }

        protected Object getOwnValue(String inputName) {
            return this.values.get(inputName);
        }
    }

    protected static abstract class InputValueProvider {
        private final InputValueProvider parent;

        protected InputValueProvider() {
            this(null);
        }

        protected InputValueProvider(InputValueProvider parent) {
            this.parent = parent;
        }

        public Object getValue(String inputName) {
            Object value = this.hasOwnValue(inputName) ? this.getOwnValue(inputName) : (this.parent != null ? this.parent.getValue(inputName) : null);
            return value;
        }

        protected abstract boolean hasOwnValue(String var1);

        protected abstract Object getOwnValue(String var1);
    }
}

