/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.common.LocalesList;
import com.jaspersoft.jasperserver.war.common.TimeZonesList;
import com.jaspersoft.jasperserver.war.common.UserLocale;
import com.jaspersoft.jasperserver.war.dto.ByteEnum;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ReportJobEditAction
extends FormAction {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$action$ReportJobEditAction == null ? (class$com$jaspersoft$jasperserver$war$action$ReportJobEditAction = ReportJobEditAction.class$("com.jaspersoft.jasperserver.war.action.ReportJobEditAction")) : class$com$jaspersoft$jasperserver$war$action$ReportJobEditAction));
    public static final byte RECURRENCE_TYPE_NONE = 1;
    public static final byte RECURRENCE_TYPE_SIMPLE = 2;
    public static final byte RECURRENCE_TYPE_CALENDAR = 3;
    public static final String ATTR_NAME_TRIGGER_RECURRENCE_TYPE = "triggerRecurrenceType";
    public static final String ATTR_NAME_TRIGGER_ALL_WEEK_DAYS = "allWeekDays";
    public static final String ATTR_NAME_TRIGGER_ALL_MONTHS = "allMonths";
    private MessageSource messageSource;
    private RepositoryService repositoryService;
    private ReportSchedulingService schedulingService;
    private String isNewModeAttrName;
    private String reportUnitURIAttrName;
    private String editJobIdParamName;
    private String contentFoldersAttrName;
    private String outputFormatsAttrName;
    private String intervalUnitsAttrName;
    private LocalesList localesList;
    private String localesAttrName;
    private TimeZonesList timeZonesList;
    private String timeZonesAttrName;
    private MailAddressesEditor mailAddressesEditor;
    private CustomDateEditor customDateEditor;
    private CustomNumberEditor customNumberEditor;
    private CustomCollectionEditor byteSetEditor;
    private CustomCollectionEditor byteSortedSetEditor;
    private final List intervalUnits = this.getRecurrenceIntervalUnits();
    private final List allOutputFormats = this.getOutputFormats();
    private final List weekDays = this.getWeekDays();
    private final List months = this.getMonths();
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$action$ReportJobEditAction;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Date;

    protected List getRecurrenceIntervalUnits() {
        ArrayList<ByteEnum> intervalUnitsList = new ArrayList<ByteEnum>();
        intervalUnitsList.add(new ByteEnum(1, "job.interval.unit.minute.label"));
        intervalUnitsList.add(new ByteEnum(2, "job.interval.unit.hour.label"));
        intervalUnitsList.add(new ByteEnum(3, "job.interval.unit.day.label"));
        intervalUnitsList.add(new ByteEnum(4, "job.interval.unit.week.label"));
        return intervalUnitsList;
    }

    protected List getOutputFormats() {
        ArrayList<ByteEnum> allOutputFormatsList = new ArrayList<ByteEnum>();
        allOutputFormatsList.add(new ByteEnum(1, "report.output.pdf.label"));
        allOutputFormatsList.add(new ByteEnum(2, "report.output.html.label"));
        allOutputFormatsList.add(new ByteEnum(3, "report.output.xls.label"));
        allOutputFormatsList.add(new ByteEnum(4, "report.output.rtf.label"));
        allOutputFormatsList.add(new ByteEnum(5, "report.output.csv.label"));
        return allOutputFormatsList;
    }

    protected List getWeekDays() {
        ArrayList<ByteEnum> weekDaysList = new ArrayList<ByteEnum>();
        weekDaysList.add(new ByteEnum(2, "week.days.label.mon"));
        weekDaysList.add(new ByteEnum(3, "week.days.label.tue"));
        weekDaysList.add(new ByteEnum(4, "week.days.label.wen"));
        weekDaysList.add(new ByteEnum(5, "week.days.label.thu"));
        weekDaysList.add(new ByteEnum(6, "week.days.label.fri"));
        weekDaysList.add(new ByteEnum(7, "week.days.label.sat"));
        weekDaysList.add(new ByteEnum(1, "week.days.label.sun"));
        return weekDaysList;
    }

    protected List getMonths() {
        ArrayList<ByteEnum> monthsList = new ArrayList<ByteEnum>();
        monthsList.add(new ByteEnum(1, "monts.label.jan"));
        monthsList.add(new ByteEnum(2, "monts.label.feb"));
        monthsList.add(new ByteEnum(3, "monts.label.mar"));
        monthsList.add(new ByteEnum(4, "monts.label.apr"));
        monthsList.add(new ByteEnum(5, "monts.label.may"));
        monthsList.add(new ByteEnum(6, "monts.label.jun"));
        monthsList.add(new ByteEnum(7, "monts.label.jul"));
        monthsList.add(new ByteEnum(8, "monts.label.aug"));
        monthsList.add(new ByteEnum(9, "monts.label.sep"));
        monthsList.add(new ByteEnum(10, "monts.label.oct"));
        monthsList.add(new ByteEnum(11, "monts.label.nov"));
        monthsList.add(new ByteEnum(12, "monts.label.dec"));
        return monthsList;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.mailAddressesEditor = new MailAddressesEditor();
        this.customDateEditor = new CustomDateEditor(JasperServerUtil.createCalendarDateTimeFormat(this.getMessageSource()), true);
        this.customNumberEditor = new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = ReportJobEditAction.class$("java.lang.Integer")) : class$java$lang$Integer, true);
        this.byteSetEditor = new ByteCollectionEditor(class$java$util$Set == null ? (class$java$util$Set = ReportJobEditAction.class$("java.util.Set")) : class$java$util$Set);
        this.byteSortedSetEditor = new ByteCollectionEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = ReportJobEditAction.class$("java.util.SortedSet")) : class$java$util$SortedSet);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public ReportSchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(ReportSchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public String getEditJobIdParamName() {
        return this.editJobIdParamName;
    }

    public void setEditJobIdParamName(String editJobIdParamName) {
        this.editJobIdParamName = editJobIdParamName;
    }

    public String getIsNewModeAttrName() {
        return this.isNewModeAttrName;
    }

    public void setIsNewModeAttrName(String isNewModeAttrName) {
        this.isNewModeAttrName = isNewModeAttrName;
    }

    public String getReportUnitURIAttrName() {
        return this.reportUnitURIAttrName;
    }

    public void setReportUnitURIAttrName(String reportUnitURIAttrName) {
        this.reportUnitURIAttrName = reportUnitURIAttrName;
    }

    public String getContentFoldersAttrName() {
        return this.contentFoldersAttrName;
    }

    public void setContentFoldersAttrName(String contentFoldersAttrName) {
        this.contentFoldersAttrName = contentFoldersAttrName;
    }

    public String getOutputFormatsAttrName() {
        return this.outputFormatsAttrName;
    }

    public void setOutputFormatsAttrName(String outputFormatsAttrName) {
        this.outputFormatsAttrName = outputFormatsAttrName;
    }

    public String getIntervalUnitsAttrName() {
        return this.intervalUnitsAttrName;
    }

    public void setIntervalUnitsAttrName(String intervalUnitsAttrName) {
        this.intervalUnitsAttrName = intervalUnitsAttrName;
    }

    public String getLocalesAttrName() {
        return this.localesAttrName;
    }

    public void setLocalesAttrName(String localesAttrName) {
        this.localesAttrName = localesAttrName;
    }

    public LocalesList getLocalesList() {
        return this.localesList;
    }

    public void setLocalesList(LocalesList localesList) {
        this.localesList = localesList;
    }

    public String getTimeZonesAttrName() {
        return this.timeZonesAttrName;
    }

    public void setTimeZonesAttrName(String timeZonesAttrName) {
        this.timeZonesAttrName = timeZonesAttrName;
    }

    public TimeZonesList getTimeZonesList() {
        return this.timeZonesList;
    }

    public void setTimeZonesList(TimeZonesList timeZonesList) {
        this.timeZonesList = timeZonesList;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        super.initBinder(context, binder);
        binder.registerCustomEditor(class$java$util$List == null ? (class$java$util$List = ReportJobEditAction.class$("java.util.List")) : class$java$util$List, "mailNotification.toAddresses", (PropertyEditor)this.mailAddressesEditor);
        binder.registerCustomEditor(class$java$util$List == null ? (class$java$util$List = ReportJobEditAction.class$("java.util.List")) : class$java$util$List, "mailNotification.ccAddresses", (PropertyEditor)this.mailAddressesEditor);
        binder.registerCustomEditor(class$java$util$List == null ? (class$java$util$List = ReportJobEditAction.class$("java.util.List")) : class$java$util$List, "mailNotification.bccAddresses", (PropertyEditor)this.mailAddressesEditor);
        binder.registerCustomEditor(class$java$util$Date == null ? (class$java$util$Date = ReportJobEditAction.class$("java.util.Date")) : class$java$util$Date, (PropertyEditor)this.customDateEditor);
        binder.registerCustomEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = ReportJobEditAction.class$("java.lang.Integer")) : class$java$lang$Integer, (PropertyEditor)this.customNumberEditor);
        binder.registerCustomEditor(class$java$util$Set == null ? (class$java$util$Set = ReportJobEditAction.class$("java.util.Set")) : class$java$util$Set, "outputFormats", (PropertyEditor)this.byteSetEditor);
        binder.registerCustomEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = ReportJobEditAction.class$("java.util.SortedSet")) : class$java$util$SortedSet, "trigger.weekDays", (PropertyEditor)this.byteSortedSetEditor);
        binder.registerCustomEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = ReportJobEditAction.class$("java.util.SortedSet")) : class$java$util$SortedSet, "trigger.months", (PropertyEditor)this.byteSortedSetEditor);
    }

    public Event setupForm(RequestContext context) throws Exception {
        try {
            return super.setupForm(context);
        }
        catch (ReportJobNotFoundException e) {
            context.getFlowScope().put("errorMessage", (Object)"report.job.edit.not.found");
            context.getFlowScope().put("errorArguments", (Object)new Long(e.getJobId()));
            return new Event((Object)this, "notFound");
        }
    }

    protected Object createFormObject(RequestContext context) {
        ReportJob job;
        if (this.isNewMode(context)) {
            job = this.createNewReportJob(context);
        } else {
            Long jobIdParam = context.getRequestParameters().getRequiredLong(this.getEditJobIdParamName());
            long jobId = jobIdParam;
            job = this.schedulingService.getScheduledJob(JasperServerUtil.getExecutionContext(context), jobId);
            if (job == null) {
                throw new ReportJobNotFoundException(jobId);
            }
        }
        if (job.getMailNotification() == null) {
            job.setMailNotification(new ReportJobMailNotification());
        }
        return job;
    }

    protected ReportJob createNewReportJob(RequestContext context) {
        ReportJob job = new ReportJob();
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        job.setTrigger((ReportJobTrigger)trigger);
        job.setSource(new ReportJobSource());
        String ownerURI = this.newJobOwnerURI(context);
        job.getSource().setReportUnitURI(ownerURI);
        int lastSepIdx = ownerURI.lastIndexOf("/");
        if (lastSepIdx < 0) {
            String quotedURI = "\"" + ownerURI + "\"";
            throw new JSException("jsexception.no.values.to.enumerate", new Object[]{quotedURI});
        }
        String reportName = ownerURI.substring(lastSepIdx + Folder.SEPARATOR_LENGTH);
        job.setBaseOutputFilename(reportName);
        trigger.setStartType((byte)1);
        trigger.setOccurrenceCount(1);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        job.setContentRepositoryDestination(repositoryDestination);
        job.addOutputFormat((byte)1);
        return job;
    }

    protected String newJobOwnerURI(RequestContext context) {
        String reportUnitURI = context.getFlowScope().getString(this.getReportUnitURIAttrName());
        return reportUnitURI;
    }

    protected ReportJob getReportJob(RequestContext context) throws Exception {
        return (ReportJob)this.getFormObject(context);
    }

    protected boolean isNewMode(RequestContext context) {
        Boolean isNewMode = context.getFlowScope().getBoolean(this.getIsNewModeAttrName());
        return isNewMode != null && isNewMode != false;
    }

    public Event setNowModeDefaults(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        String jobLabel = this.messageSource.getMessage("report.scheduling.job.runNow.label", null, "Run once job", this.getUserLocale());
        job.setLabel(jobLabel);
        return this.success();
    }

    public Event setOutputReferenceData(RequestContext context) {
        UserLocale[] userLocales;
        List folders = this.repositoryService.getAllFolders(JasperServerUtil.getExecutionContext(context));
        context.getRequestScope().put(this.getContentFoldersAttrName(), (Object)folders);
        context.getRequestScope().put(this.getOutputFormatsAttrName(), (Object)this.allOutputFormats);
        if (this.getLocalesList() != null && (userLocales = this.getLocalesList().getUserLocales(this.getUserLocale())) != null && userLocales.length > 0) {
            context.getRequestScope().put(this.getLocalesAttrName(), (Object)userLocales);
        }
        return this.success();
    }

    protected Locale getUserLocale() {
        return LocaleContextHolder.getLocale();
    }

    public Event setTriggerReferenceData(RequestContext context) throws Exception {
        context.getRequestScope().put(this.getIntervalUnitsAttrName(), (Object)this.intervalUnits);
        ReportJob reportJob = this.getReportJob(context);
        byte triggerRecurrenceType = this.getTriggerRecurrenceType(reportJob.getTrigger());
        context.getRequestScope().put(ATTR_NAME_TRIGGER_RECURRENCE_TYPE, (Object)new Byte(triggerRecurrenceType));
        if (triggerRecurrenceType == 3) {
            context.getRequestScope().put(ATTR_NAME_TRIGGER_ALL_WEEK_DAYS, (Object)this.weekDays);
            context.getRequestScope().put(ATTR_NAME_TRIGGER_ALL_MONTHS, (Object)this.months);
        }
        if (this.getTimeZonesList() != null) {
            List timeZones = this.getTimeZonesList().getTimeZones(this.getUserLocale());
            context.getRequestScope().put(this.getTimeZonesAttrName(), (Object)timeZones);
            TimeZone userTz = JasperServerUtil.getTimezone(context);
            context.getRequestScope().put("preferredTimezone", (Object)userTz.getID());
        }
        return this.success();
    }

    protected byte getTriggerRecurrenceType(ReportJobTrigger trigger) {
        int type;
        if (trigger instanceof ReportJobSimpleTrigger) {
            ReportJobSimpleTrigger simpleTrigger = (ReportJobSimpleTrigger)trigger;
            type = simpleTrigger.getOccurrenceCount() == 1 ? 1 : 2;
        } else if (trigger instanceof ReportJobCalendarTrigger) {
            type = 3;
        } else {
            String quotedTriggerType = "\"" + trigger.getClass().getName() + "\"";
            throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedTriggerType});
        }
        return (byte)type;
    }

    public Event setTriggerRecurrenceNone(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        this.copyCommonTriggerAttributes((ReportJobTrigger)trigger, job.getTrigger());
        trigger.setOccurrenceCount(1);
        job.setTrigger((ReportJobTrigger)trigger);
        return this.success();
    }

    public Event setTriggerRecurrenceSimple(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        this.copyCommonTriggerAttributes((ReportJobTrigger)trigger, job.getTrigger());
        trigger.setOccurrenceCount(-1);
        trigger.setRecurrenceInterval(1);
        trigger.setRecurrenceIntervalUnit((byte)3);
        job.setTrigger((ReportJobTrigger)trigger);
        return this.success();
    }

    public Event setTriggerRecurrenceCalendar(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        ReportJobCalendarTrigger trigger = new ReportJobCalendarTrigger();
        this.copyCommonTriggerAttributes((ReportJobTrigger)trigger, job.getTrigger());
        trigger.setMinutes("0");
        trigger.setHours("0");
        trigger.setDaysType((byte)1);
        TreeSet<Byte> selectedMonths = new TreeSet<Byte>();
        Iterator it = this.months.iterator();
        while (it.hasNext()) {
            ByteEnum month = (ByteEnum)it.next();
            selectedMonths.add(new Byte(month.getCode()));
        }
        trigger.setMonths(selectedMonths);
        job.setTrigger((ReportJobTrigger)trigger);
        return this.success();
    }

    protected void copyCommonTriggerAttributes(ReportJobTrigger newTrigger, ReportJobTrigger trigger) {
        newTrigger.setStartType(trigger.getStartType());
        newTrigger.setStartDate(trigger.getStartDate());
        newTrigger.setEndDate(trigger.getEndDate());
    }

    public Event saveJob(RequestContext context) throws Exception {
        ReportJob job = this.getReportJob(context);
        if (job.getMailNotification().isEmpty()) {
            job.setMailNotification(null);
        }
        if (this.isNewMode(context)) {
            this.schedulingService.scheduleJob(JasperServerUtil.getExecutionContext(context), job);
        } else {
            try {
                this.schedulingService.updateScheduledJob(JasperServerUtil.getExecutionContext(context), job);
            }
            catch (ReportJobNotFoundException e) {
                context.getFlowScope().put("errorMessage", (Object)"report.job.save.not.found");
                context.getFlowScope().put("errorArguments", (Object)new Long(e.getJobId()));
                return new Event((Object)this, "notFound");
            }
        }
        return this.success();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ByteCollectionEditor
    extends CustomCollectionEditor {
        public ByteCollectionEditor(Class collectionClass) {
            super(collectionClass);
        }

        protected Object convertElement(Object val) {
            if (val == null || val instanceof Byte) {
                return val;
            }
            try {
                return Byte.valueOf(val.toString());
            }
            catch (NumberFormatException e) {
                log.error((Object)"error parsing byte value", (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }
    }

    protected static class MailAddressesEditor
    extends PropertyEditorSupport {
        protected MailAddressesEditor() {
        }

        public String getAsText() {
            StringBuffer sb = new StringBuffer();
            List addresses = (List)this.getValue();
            if (addresses != null && !addresses.isEmpty()) {
                Iterator it = addresses.iterator();
                String address = (String)it.next();
                sb.append(address);
                while (it.hasNext()) {
                    sb.append(", ");
                    address = (String)it.next();
                    sb.append(address);
                }
            }
            return sb.toString();
        }

        public void setAsText(String text) throws IllegalArgumentException {
            ArrayList<String> addressList = new ArrayList<String>();
            if (text != null && text.trim().length() > 0) {
                String[] addresses = text.trim().split("\\,");
                for (int i = 0; i < addresses.length; ++i) {
                    addressList.add(addresses[i].trim());
                }
            }
            this.setValue(addressList);
        }
    }
}

