/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.dto.ExportParameters;
import com.jaspersoft.jasperserver.war.dto.ExporterConfigurationBean;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ReportExporterAction
extends FormAction {
    private static final String REPORT_EXPORT = "export";
    private static final String REPORT_EXPORT_PARAMS = "exportParams";
    private static final String REPORT_EXPORT_OPTION = "exportOption";
    private static final String PARAMETER_DIALOG_NAME = "parameterDialogName";
    private static final String REPORT_OUTPUT = "output";
    private Map configuredExporters;
    private Object exportParameters;
    private String exporterType;
    private ConfigurationBean configurationBean;

    public Event exportOptions(RequestContext context) throws Exception {
        String type = this.getExporterType(context);
        MutableAttributeMap flowScope = context.getFlowScope();
        if (type != null) {
            this.exporterType = type;
        }
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(this.exporterType);
        if (type != null && StringUtils.isNotEmpty((String)exporterConfiguration.getParameterDialogName())) {
            this.exportParameters = exporterConfiguration.getExportParameters();
            String parameterDialogName = exporterConfiguration.getParameterDialogName();
            this.setFormObjectClass(this.exportParameters.getClass());
            this.setFormObjectName(parameterDialogName);
            this.setFormObjectScope(ScopeType.FLOW);
            if (this.configurationBean.isReportLevelConfigurable()) {
                flowScope.put(PARAMETER_DIALOG_NAME, (Object)parameterDialogName);
                context.getRequestScope().put(parameterDialogName, this.getFormObject(context));
                flowScope.put(REPORT_EXPORT_OPTION, (Object)REPORT_EXPORT_PARAMS);
            } else {
                flowScope.put(parameterDialogName, this.getFormObject(context));
                flowScope.put(REPORT_EXPORT_OPTION, (Object)REPORT_EXPORT);
            }
        } else {
            flowScope.put(REPORT_EXPORT_OPTION, (Object)REPORT_EXPORT);
        }
        return this.success();
    }

    public void export(RequestContext context) throws Exception {
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(this.exporterType);
        exporterConfiguration.getCurrentExporter().export(context);
    }

    public Map getConfiguredExporters() {
        return this.configuredExporters;
    }

    public void setConfiguredExporters(Map configuredExporters) {
        this.configuredExporters = configuredExporters;
    }

    private String getExporterType(RequestContext context) {
        return this.getCanonicValue(context.getRequestParameters().get(REPORT_OUTPUT));
    }

    public Object getExportParameters() {
        return this.exportParameters;
    }

    public void setExportParameters(Object exportParameters) {
        this.exportParameters = exportParameters;
    }

    public Object createFormObject(RequestContext context) throws Exception {
        Object exportParams;
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(this.exporterType);
        if (null != exporterConfiguration && null != (exportParams = exporterConfiguration.getExportParameters())) {
            ExportParameters exp = (ExportParameters)exportParams.getClass().newInstance();
            exp.setPropertyValues(exportParams);
            return exp;
        }
        return null;
    }

    private String getCanonicValue(String type) {
        if ("excel".equalsIgnoreCase(type)) {
            return "xls";
        }
        return type;
    }

    public ConfigurationBean getConfigurationBean() {
        return this.configurationBean;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }
}

