/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JExcelApiHyperlinkProducerFactory;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import com.jaspersoft.jasperserver.war.dto.ExportParameters;
import com.jaspersoft.jasperserver.war.dto.XlsExportParametersBean;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import org.springframework.webflow.execution.RequestContext;

public class ReportExcelExporter
extends AbstractReportExporter {
    private static final String DIALOG_NAME = "excelExportParams";
    private XlsExportParametersBean exportParameters;

    public XlsExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    public ExportParameters getExportParameters(RequestContext context) {
        return context.getFlowScope().get(DIALOG_NAME) == null ? this.exportParameters : (ExportParameters)context.getFlowScope().get(DIALOG_NAME);
    }

    public void setExportParameters(XlsExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }

    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException, JSException {
        JExcelApiExporter exporter = new JExcelApiExporter();
        exporter.setParameters(baseParameters);
        XlsExportParametersBean exportParams = (XlsExportParametersBean)this.getExportParameters(context);
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.isOnePagePerSheet());
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.isDetectCellType());
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.isRemoveEmptySpaceBetweenRows());
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.isWhitePageBackground());
        exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)JExcelApiHyperlinkProducerFactory.INSTANCE);
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            if (e.getCause() instanceof RowsExceededException) {
                throw new JSException("jsexception.too.many.data.rows");
            }
            throw e;
        }
    }

    protected String getContentType(RequestContext context) {
        return "application/xls";
    }

    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", "inline; filename=\"" + this.getReportName(context) + ".xls\"");
    }
}

