/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import com.jaspersoft.jasperserver.war.dto.CsvExportParametersBean;
import com.jaspersoft.jasperserver.war.dto.ExportParameters;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import org.springframework.webflow.execution.RequestContext;

public class ReportCsvExporter
extends AbstractReportExporter {
    private static final String DIALOG_NAME = "csvExportParams";
    private CsvExportParametersBean exportParameters;

    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException {
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameters(baseParameters);
        CsvExportParametersBean exportParams = (CsvExportParametersBean)this.getExportParameters(context);
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)exportParams.getFieldDelimiter());
        exporter.exportReport();
    }

    protected String getContentType(RequestContext context) {
        return "text/csv";
    }

    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", "inline; filename=\"" + this.getReportName(context) + ".csv\"");
    }

    public CsvExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    public void setExportParameters(CsvExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }

    public ExportParameters getExportParameters(RequestContext context) {
        return context.getFlowScope().get(DIALOG_NAME) == null ? this.exportParameters : (ExportParameters)context.getFlowScope().get(DIALOG_NAME);
    }
}

