/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.client.MondrianConnectionImpl;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper;
import com.jaspersoft.jasperserver.war.dto.OlapUnitWrapper;
import com.jaspersoft.jasperserver.war.validation.OlapUnitValidator;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class OlapUnitAction
extends FormAction {
    private static final String OU_URI_PARAM = "resource";
    private static final String FORM_OBJECT_KEY = "wrapper";
    private static final String OLAP_UNIT_SUFFIX = "_unit";
    private static final String OLAP_UNIT_KEY = "unit";
    private static final String CONTROL_OBJECT_KEY = "control";
    private static final String RESOURCE_OBJECT_KEY = "resource";
    private static final String DATASOURCE_OBJECT_KEY = "dataResource";
    private static final String CONNECTION_OBJECT_KEY = "connectionWrapper";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String PARAM_FROM_PAGE = "frompage";
    private static final String PARAM_RESOURCE_NAME = "resourceName";
    private static final String LOCAL_SCHEMA_SUFFIX = "_schema";
    private static final String UNPARSABLE_SCHEMA_ATTR = "schemaUnparsable";
    private static final String INVALID_XMLA_CONNECTION_ATTR = "xmlaConnectionInvalid";
    private static final String UNPARSABLE_XMLA_ATTR = "xmlaUnparsable";
    private static final String UNPARSABLE_CONNECTION_ATTR = "connectionUnparsable";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected RepositoryService repository;
    protected OlapConnectionService olapConnection;
    private EngineService engine;
    protected JasperServerConstImpl constants = new JasperServerConstImpl();
    private String connectionWrapperClass;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$OlapUnitWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit;
    static /* synthetic */ Class array$B;

    public OlapUnitAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$OlapUnitWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$OlapUnitWrapper = OlapUnitAction.class$("com.jaspersoft.jasperserver.war.dto.OlapUnitWrapper")) : class$com$jaspersoft$jasperserver$war$dto$OlapUnitWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Event initAction(RequestContext context) throws Exception {
        ((OlapUnitValidator)this.getValidator()).setConnectionService(this.olapConnection);
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        if (wrapper.isNewMode()) {
            String folderURI = wrapper.getOlapUnit().getParentFolder();
            if (folderURI == null) {
                folderURI = "/";
            }
            FilterCriteria resourcesInFolder = FilterCriteria.createFilter();
            resourcesInFolder.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
            this.log("Searching for resources in the chosen folder:" + folderURI);
            ResourceLookup[] existingResources = this.repository.findResource(JasperServerUtil.getExecutionContext(context), resourcesInFolder);
            if (existingResources != null && existingResources.length != 0) {
                this.log("res lookup size=" + existingResources.length);
                ArrayList<String> allResources = new ArrayList<String>();
                for (int i = 0; i < existingResources.length; ++i) {
                    ResourceLookup rLookup = existingResources[i];
                    allResources.add(rLookup.getName());
                    this.log("adding resource: " + rLookup.getName() + " to the list");
                }
                wrapper.setExistingResources(allResources);
            }
        } else {
            OlapUnit ou = wrapper.getOlapUnit();
            wrapper.setOlapUnitName(ou.getName());
            wrapper.setOlapUnitLabel(ou.getLabel());
            wrapper.setOlapUnitDescription(ou.getDescription());
            wrapper.setOlapClientConnection((OlapClientConnection)this.repository.getResource(null, ou.getOlapClientConnection().getReferenceURI()));
            wrapper.setOlapUnitMdxQuery(ou.getMdxQuery());
            wrapper.setOlapUnitOptions(ou.getOlapViewOptions());
            if (wrapper.getOlapClientConnection() instanceof MondrianConnection) {
                OlapUnitAction olapUnitAction = this;
                wrapper.setType(olapUnitAction.constants.getOlapMondrianConnectionType());
            } else if (wrapper.getOlapClientConnection() instanceof XMLAConnection) {
                OlapUnitAction olapUnitAction = this;
                wrapper.setType(olapUnitAction.constants.getOlapXmlaConnectionType());
            } else {
                this.log("Unknown connection type.");
            }
        }
        this.getAllConnections(context, wrapper);
        this.findAllSchemas(context, wrapper);
        this.getAllXmlaSources(context, wrapper);
        wrapper.setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
        context.getFlowScope().put(FORM_OBJECT_KEY, (Object)wrapper);
        context.getFlowScope().put("constants", (Object)this.constants);
        return this.success();
    }

    private void findAllSchemas(RequestContext context, OlapUnitWrapper wrapper) {
        FilterCriteria filterCriteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = OlapUnitAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource));
        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)"olapMondrianSchema"));
        ResourceLookup[] resourceLookup = this.repository.findResource(JasperServerUtil.getExecutionContext(context), filterCriteria);
        ArrayList<String> allSources = null;
        if (resourceLookup != null && resourceLookup.length != 0) {
            this.log("Found source lookups size=" + resourceLookup.length);
            allSources = new ArrayList<String>(resourceLookup.length);
            for (int i = 0; i < resourceLookup.length; ++i) {
                ResourceLookup resource = resourceLookup[i];
                Resource resourceObj = this.repository.getResource(null, resource.getURIString());
                if (!allSources.contains(((FileResource)resourceObj).getURIString())) {
                    allSources.add(((FileResource)resourceObj).getURIString());
                }
                this.log("added uri=" + resource.getURIString());
            }
            wrapper.setReusableSchemas(allSources);
        }
    }

    private void getAllConnections(RequestContext context, OlapUnitWrapper wrapper) {
        FilterCriteria filterCriteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection = OlapUnitAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection));
        ResourceLookup[] resourceLookup = this.repository.findResource(JasperServerUtil.getExecutionContext(context), filterCriteria);
        ArrayList<String> allMondrianConnections = null;
        ArrayList<String> allXmlaConnections = null;
        if (resourceLookup != null && resourceLookup.length != 0) {
            this.log("Found conneciton lookups size=" + resourceLookup.length);
            allMondrianConnections = new ArrayList<String>(resourceLookup.length);
            allXmlaConnections = new ArrayList<String>(resourceLookup.length);
            for (int i = 0; i < resourceLookup.length; ++i) {
                ResourceLookup resource = resourceLookup[i];
                Resource resourceObj = this.repository.getResource(null, resource.getURIString());
                if (resourceObj instanceof MondrianConnection) {
                    if (allMondrianConnections.contains(((OlapClientConnection)resourceObj).getURIString())) continue;
                    allMondrianConnections.add(((OlapClientConnection)resourceObj).getURIString());
                    continue;
                }
                if (resourceObj instanceof XMLAConnection) {
                    if (allXmlaConnections.contains(((OlapClientConnection)resourceObj).getURIString())) continue;
                    allXmlaConnections.add(((OlapClientConnection)resourceObj).getURIString());
                    continue;
                }
                throw new JSException("jsexception.unknown.connection.type");
            }
            wrapper.setReusableMondrianConnections(allMondrianConnections);
            wrapper.setReusableXmlaConnections(allXmlaConnections);
        }
    }

    private void getAllXmlaSources(RequestContext context, OlapUnitWrapper wrapper) {
        FilterCriteria filterCriteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition = OlapUnitAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition));
        ResourceLookup[] resourceLookup = this.repository.findResource(JasperServerUtil.getExecutionContext(context), filterCriteria);
        ArrayList<String> allXmlaDefinitions = null;
        if (resourceLookup != null && resourceLookup.length != 0) {
            this.log("Found xmla definition lookups size=" + resourceLookup.length);
            allXmlaDefinitions = new ArrayList<String>(resourceLookup.length);
            for (int i = 0; i < resourceLookup.length; ++i) {
                ResourceLookup resource = resourceLookup[i];
                Resource resourceObj = this.repository.getResource(null, resource.getURIString());
                if (allXmlaDefinitions.contains(((MondrianXMLADefinition)resourceObj).getURIString())) continue;
                allXmlaDefinitions.add(((MondrianXMLADefinition)resourceObj).getCatalog());
            }
            wrapper.setReusableXmlaDefinitions(allXmlaDefinitions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Event handleTypeSelection(RequestContext context) throws Exception {
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        String strType = wrapper.getType();
        this.log("Type" + strType);
        if (strType == null) throw new JSException("jsexception.no.connection.selected");
        if (strType.equals(JasperServerConstImpl.getOlapMondrianConnectionType())) {
            wrapper.setOlapConnectionType("olapMondrianSchema");
            return this.success();
        } else {
            if (!strType.equals(JasperServerConstImpl.getOlapXmlaConnectionType())) throw new JSException("jsexception.connection.type.not.suported");
            wrapper.setOlapConnectionType("xmlaConnection");
        }
        return this.success();
    }

    public Event locateOlapConnection(RequestContext context) throws Exception {
        OlapClientConnectionWrapper connectionWrapper;
        this.log("In locate olap connection");
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        OlapClientConnection connection = wrapper.getOlapClientConnection();
        try {
            connectionWrapper = (OlapClientConnectionWrapper)Class.forName(this.getConnectionWrapperClass()).newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)("error creating connection wrapper class: " + e));
            connectionWrapper = new OlapClientConnectionWrapper();
        }
        if (connection == null) {
            this.log("Found no previous OlapClientConnection, creating new");
            connectionWrapper.setMode((byte)3);
            connectionWrapper.setParentFolder(wrapper.getParentFolder());
        } else {
            this.log("Found previous OlapClientConnection");
            connectionWrapper.setOlapConnectionType(wrapper.getOlapConnectionType());
            connectionWrapper.setReusableMondrianConnections(wrapper.getReusableMondrianConnections());
            connectionWrapper.setReusableSchemas(wrapper.getReusableSchemas());
            connectionWrapper.setReusableXmlaConnections(wrapper.getReusableXmlaConnections());
            connectionWrapper.setSource(wrapper.getSource());
            connectionWrapper.setType(wrapper.getType());
            connectionWrapper.setConnectionUri(wrapper.getOlapUnit().getOlapClientConnection().getReferenceURI());
            connectionWrapper.setParentFolder(connection.getParentFolder());
            connectionWrapper.setMode((byte)4);
        }
        connectionWrapper.setParentFlowObject(wrapper);
        context.getFlowScope().put(CONNECTION_OBJECT_KEY, (Object)connectionWrapper);
        context.getFlowScope().put("constants", (Object)this.constants);
        return this.success();
    }

    public Event saveOlapClientConnection(RequestContext context) throws Exception {
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        OlapClientConnectionWrapper connectionWrapper = (OlapClientConnectionWrapper)context.getFlowScope().get(CONNECTION_OBJECT_KEY);
        OlapClientConnection connection = connectionWrapper.getOlapClientConnection();
        if (connection == null) {
            throw new JSException("jsexception.got.null.connection.back");
        }
        this.log("type was " + connectionWrapper.getOlapConnectionType());
        return this.success();
    }

    public Event saveOlapUnit(RequestContext context) throws Exception {
        this.log("In saveOlapUnit");
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        OlapUnit ou = wrapper.getOlapUnit();
        ou.setName(wrapper.getOlapUnitName());
        ou.setLabel(wrapper.getOlapUnitLabel());
        ou.setDescription(wrapper.getOlapUnitDescription());
        if (wrapper.getOlapClientConnection() != null) {
            ou.setOlapClientConnection(wrapper.getOlapClientConnection());
            if (wrapper.getOlapClientConnection().getURIString() == null) {
                throw new JSException("jsexception.missing.olap.connection.reference");
            }
        } else {
            throw new JSException("jsexception.missing.olap.connection");
        }
        ou.setOlapClientConnectionReference(wrapper.getOlapClientConnection().getURIString());
        ou.setMdxQuery(wrapper.getOlapUnitMdxQuery());
        ou.setOlapViewOptions(wrapper.getOlapUnitOptions());
        OlapClientConnection connection = wrapper.getOlapClientConnection();
        OlapClientConnectionWrapper connectionWrapper = (OlapClientConnectionWrapper)context.getFlowScope().get(CONNECTION_OBJECT_KEY);
        wrapper.setConnectionModified(connectionWrapper.isConnectionModified());
        if (wrapper.isConnectionModified()) {
            if (connection instanceof MondrianConnection) {
                FileResource schema = wrapper.getOlapClientSchema();
                if (wrapper.isSchemaLoaded()) {
                    schema = wrapper.getOlapClientSchema();
                    try {
                        this.repository.saveResource(null, (Resource)schema);
                    }
                    catch (Exception e) {
                        throw new JSException((Throwable)e);
                    }
                    schema.setReferenceURI(schema.getURIString());
                    ((MondrianConnection)connection).setSchemaReference(schema.getReferenceURI());
                } else {
                    ((MondrianConnection)connection).setSchemaReference(connectionWrapper.getSchemaUri());
                }
                ReportDataSource datasource = wrapper.getOlapClientDatasource();
                if (wrapper.isDatasourceAdded()) {
                    try {
                        this.repository.saveResource(null, (Resource)datasource);
                    }
                    catch (Exception e) {
                        throw new JSException((Throwable)e);
                    }
                    ((MondrianConnection)connection).setDataSourceReference(datasource.getURIString());
                } else {
                    ((MondrianConnection)connection).setDataSourceReference(connectionWrapper.getDatasourceUri());
                }
            } else if (connection instanceof XMLAConnection) {
                connection.setName(connectionWrapper.getConnectionName());
                connection.setLabel(connectionWrapper.getConnectionLabel());
                connection.setDescription(connectionWrapper.getConnectionDescription());
                ((XMLAConnection)connection).setCatalog(connectionWrapper.getXmlaCatalog());
                ((XMLAConnection)connection).setURI(connectionWrapper.getXmlaConnectionUri());
                ((XMLAConnection)connection).setDataSource(connectionWrapper.getXmlaDatasource());
                ((XMLAConnection)connection).setUsername(connectionWrapper.getUsername());
                ((XMLAConnection)connection).setPassword(connectionWrapper.getPassword());
            } else {
                throw new JSException("jsexception.unknown.connection.type");
            }
            if (connectionWrapper.getMode() == 4) {
                if (connection.getParentFolder() == null) {
                    connection.setParentFolder(wrapper.getParentFolder());
                }
            } else {
                connection.setParentFolder(connectionWrapper.getParentFolder());
                try {
                    this.repository.saveResource(null, (Resource)connection);
                }
                catch (Exception e) {
                    throw new JSException((Throwable)e);
                }
            }
        }
        ou.setOlapClientConnection(connection);
        ou.setOlapClientConnectionReference(connection.getURIString());
        try {
            this.repository.saveResource(null, (Resource)ou);
        }
        catch (JSDuplicateResourceException e) {
            this.getFormErrors(context).rejectValue("olapUnitName", "OlapUnitValidator.error.duplicate");
            return this.error();
        }
        return this.success();
    }

    public Event saveXmlaConnection(RequestContext context) throws Exception {
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        OlapUnit ou = wrapper.getOlapUnit();
        XMLAConnection xmlaConnection = (XMLAConnection)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection = OlapUnitAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection);
        xmlaConnection.setName(wrapper.getOlapUnitName());
        xmlaConnection.setLabel(wrapper.getOlapUnitLabel());
        xmlaConnection.setDescription(wrapper.getOlapUnitDescription());
        xmlaConnection.setCatalog(wrapper.getXmlaCatalog());
        xmlaConnection.setDataSource(wrapper.getXmlaDatasource());
        xmlaConnection.setURI(wrapper.getXmlaConnectionUri());
        ou.setOlapClientConnection((OlapClientConnection)xmlaConnection);
        ou.setOlapClientConnectionReference(xmlaConnection.getURIString());
        wrapper.setOlapConnectionType("xmlaConnection");
        wrapper.setOlapClientConnection((OlapClientConnection)xmlaConnection);
        wrapper.setConnectionModified(true);
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        OlapUnit ou;
        OlapUnitWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get("resource");
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            ou = (OlapUnit)this.repository.getResource(null, resourceUri);
            if (ou == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new OlapUnitWrapper();
            formObject.setOlapUnit(ou);
            ResourceReference olapClientConnectionRef = ou.getOlapClientConnection();
            OlapClientConnection occ = (OlapClientConnection)this.repository.getResource(null, olapClientConnectionRef.getReferenceURI());
            formObject.setOlapClientConnection(occ);
            if (occ instanceof MondrianConnection) {
                formObject.getOlapUnit().setDataSource(((MondrianConnection)occ).getDataSource());
                formObject.setOlapConnectionType("olapMondrianSchema");
            } else if (occ instanceof XMLAConnection) {
                formObject.setOlapConnectionType("xmlaConnection");
            } else {
                throw new JSException("jsexception.unknown.connection.type");
            }
            String uri = null;
            if (!olapClientConnectionRef.isLocal()) {
                formObject.setSource("CONTENT_REPOSITORY");
                if (formObject.getOlapConnectionType().equals("olapMondrianSchema")) {
                    uri = ((MondrianConnectionImpl)occ).getSchema().getReferenceURI();
                }
                formObject.setSchemaUri(uri);
            } else {
                formObject.setSource("FILE_SYSTEM");
                uri = olapClientConnectionRef.getLocalResource().getURIString();
            }
            formObject.setOldSchemaUri(uri);
            formObject.setOriginalSchemaUri(uri);
            formObject.setMode((byte)2);
            formObject.setDatasourceIdentified(true);
            formObject.setNamed(true);
            formObject.setSchemaLocated(true);
        }
        if (formObject == null) {
            this.log("OlapUnitAction: Stand alone new mode");
            formObject = new OlapUnitWrapper();
            ou = (OlapUnit)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit = OlapUnitAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapUnit);
            FileResource schema = (FileResource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = OlapUnitAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
            schema.setFileType("olapMondrianSchema");
            ou.setOlapClientConnectionReference(schema.getReferenceURI());
            formObject.setMode((byte)1);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            ou.setParentFolder(parentFolder);
            formObject.setOlapUnit(ou);
            formObject.setSource("FILE_SYSTEM");
        }
        return formObject;
    }

    public Event validateOlapUnit(RequestContext context) throws Exception {
        this.log("In Validate OLAP Unit");
        OlapUnitWrapper wrapper = (OlapUnitWrapper)this.getFormObject(context);
        OlapUnit ou = wrapper.getOlapUnit();
        ou.setName(wrapper.getOlapUnitName());
        ou.setLabel(wrapper.getOlapUnitLabel());
        ou.setDescription(wrapper.getOlapUnitDescription());
        ou.setOlapClientConnectionReference(wrapper.getConnectionUri());
        ou.setOlapClientConnection(wrapper.getOlapClientConnection());
        ou.setMdxQuery(wrapper.getOlapUnitMdxQuery());
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        FileResource schema = wrapper.getOlapClientSchema();
        OlapClientConnection conn = wrapper.getOlapClientConnection();
        ReportDataSource datasource = wrapper.getOlapClientDatasource();
        ValidationResult result = null;
        try {
            result = this.olapConnection.validate((ExecutionContext)executionContext, ou, schema, conn, datasource);
            wrapper.setResult(result.getValidationState().equals("VALID"));
            if (result.getValidationState().equals("ERROR")) {
                return this.error();
            }
        }
        catch (Exception e) {
            wrapper.setResult(result.getValidationState().equals("ERROR"));
            this.log.error((Object)e.getStackTrace());
        }
        wrapper.setOlapUnit(ou);
        return this.success();
    }

    public String getConnectionWrapperClass() {
        return this.connectionWrapperClass;
    }

    public void setConnectionWrapperClass(String s) {
        this.connectionWrapperClass = s;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public OlapConnectionService getOlapConnection() {
        return this.olapConnection;
    }

    public void setOlapConnection(OlapConnectionService olapConnection) {
        this.olapConnection = olapConnection;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = OlapUnitAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    protected void log(String text) {
        this.log.debug((Object)text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

