/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.action.FileResourceAction;
import com.jaspersoft.jasperserver.war.action.OlapDataSourceAction;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper;
import com.jaspersoft.jasperserver.war.dto.OlapUnitWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import com.jaspersoft.jasperserver.war.validation.OlapClientConnectionValidator;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class OlapClientConnectionAction
extends FormAction {
    private static final String OU_URI_PARAM = "resource";
    private static final String FORM_OBJECT_KEY = "connectionWrapper";
    private static final String OLAP_UNIT_SUFFIX = "_unit";
    private static final String OLAP_UNIT_KEY = "unit";
    private static final String CONTROL_OBJECT_KEY = "control";
    private static final String RESOURCE_OBJECT_KEY = "resource";
    private static final String DATASOURCE_OBJECT_KEY = "dataResource";
    private static final String SCHEMA_OBJECT_KEY = "fileResource";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String PARAM_FROM_PAGE = "frompage";
    private static final String PARAM_RESOURCE_NAME = "resourceName";
    private static final String LOCAL_SCHEMA_SUFFIX = "_schema";
    private static final String UNPARSABLE_SCHEMA_ATTR = "schemaUnparsable";
    private static final String INVALID_XMLA_CONNECTION_ATTR = "xmlaConnectionInvalid";
    private static final String UNPARSABLE_XMLA_ATTR = "xmlaUnparsable";
    private static final String UNPARSABLE_CONNECTION_ATTR = "connectionUnparsable";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected RepositoryService repository;
    protected OlapConnectionService olapConnection;
    private EngineService engine;
    protected JasperServerConstImpl constants = new JasperServerConstImpl();
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection;
    static /* synthetic */ Class array$B;

    public OlapClientConnectionAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper")) : class$com$jaspersoft$jasperserver$war$dto$OlapClientConnectionWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
        this.setValidator(new OlapClientConnectionValidator());
    }

    public Event initAction(RequestContext context) throws Exception {
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        OlapUnitWrapper parentWrapper = (OlapUnitWrapper)wrapper.getParentFlowObject();
        OlapClientConnection connection = null;
        if (wrapper.isNewMode()) {
            String folderURI = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (folderURI == null) {
                folderURI = "/";
            }
            FilterCriteria resourcesInFolder = FilterCriteria.createFilter();
            resourcesInFolder.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
            this.log("Searching for resources in the chosen folder:" + folderURI);
            ResourceLookup[] existingResources = this.repository.findResource(JasperServerUtil.getExecutionContext(context), resourcesInFolder);
            if (existingResources != null && existingResources.length != 0) {
                this.log("res lookup size=" + existingResources.length);
                ArrayList<String> allResources = new ArrayList<String>();
                for (int i = 0; i < existingResources.length; ++i) {
                    ResourceLookup rLookup = existingResources[i];
                    allResources.add(rLookup.getName());
                    this.log("adding resource: " + rLookup.getName() + " to the list");
                }
                wrapper.setExistingResources(allResources);
            }
        } else {
            connection = parentWrapper == null ? wrapper.getOlapClientConnection() : parentWrapper.getOlapClientConnection();
            if (connection == null) {
                throw new JSException("jsexception.no.olap.client.connection");
            }
            wrapper.setOlapClientConnection(connection);
            wrapper.setConnectionName(connection.getName());
            wrapper.setConnectionLabel(connection.getLabel());
            wrapper.setConnectionDescription(connection.getDescription());
            if (wrapper.getOlapClientConnection() instanceof MondrianConnection) {
                wrapper.setOlapClientSchema((FileResource)this.repository.getResource(null, ((MondrianConnection)connection).getSchema().getReferenceURI()));
                wrapper.setOlapClientDatasource((ReportDataSource)this.repository.getResource(null, ((MondrianConnection)connection).getDataSource().getReferenceURI()));
                if (parentWrapper != null) {
                    wrapper.setSchemaUri(parentWrapper.getSchemaUri());
                    wrapper.setDatasourceUri(parentWrapper.getOlapUnit().getDataSource().getReferenceURI());
                }
                OlapClientConnectionAction olapClientConnectionAction = this;
                wrapper.setType(olapClientConnectionAction.constants.getOlapMondrianConnectionType());
            } else if (wrapper.getOlapClientConnection() instanceof XMLAConnection) {
                wrapper.setXmlaCatalog(((XMLAConnection)connection).getCatalog());
                wrapper.setXmlaDatasource(((XMLAConnection)connection).getDataSource());
                wrapper.setXmlaConnectionUri(((XMLAConnection)connection).getURI());
                wrapper.setUsername(((XMLAConnection)connection).getUsername());
                wrapper.setPassword(((XMLAConnection)connection).getPassword());
                OlapClientConnectionAction olapClientConnectionAction = this;
                wrapper.setType(olapClientConnectionAction.constants.getOlapXmlaConnectionType());
            } else {
                throw new JSException("jsexception.unknown.connection.type");
            }
            wrapper.setSource("CONTENT_REPOSITORY");
        }
        if (!wrapper.isSubflowMode()) {
            this.getAllConnections(context, wrapper);
            this.findAllSchemas(context, wrapper);
            this.getAllXmlaSources(context, wrapper);
        } else {
            wrapper.setReusableMondrianConnections(parentWrapper.getReusableMondrianConnections());
            wrapper.setReusableXmlaConnections(parentWrapper.getReusableXmlaConnections());
            wrapper.setReusableSchemas(parentWrapper.getReusableSchemas());
            wrapper.setReusableXmlaDefinitions(parentWrapper.getReusableXmlaDefinitions());
        }
        this.getAllFolders(wrapper);
        wrapper.setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
        context.getFlowScope().put(FORM_OBJECT_KEY, (Object)wrapper);
        context.getFlowScope().put("constants", (Object)this.constants);
        return this.success();
    }

    private void findAllSchemas(RequestContext context, OlapClientConnectionWrapper wrapper) {
        FilterCriteria filterCriteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource));
        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)"olapMondrianSchema"));
        ResourceLookup[] resourceLookup = this.repository.findResource(JasperServerUtil.getExecutionContext(context), filterCriteria);
        ArrayList<String> allSources = null;
        if (resourceLookup != null && resourceLookup.length != 0) {
            this.log("Found source lookups size=" + resourceLookup.length);
            allSources = new ArrayList<String>(resourceLookup.length);
            for (int i = 0; i < resourceLookup.length; ++i) {
                ResourceLookup resource = resourceLookup[i];
                Resource resourceObj = this.repository.getResource(null, resource.getURIString());
                if (!allSources.contains(((FileResource)resourceObj).getURIString())) {
                    allSources.add(((FileResource)resourceObj).getURIString());
                }
                this.log("added uri=" + resource.getURIString());
            }
            wrapper.setReusableSchemas(allSources);
        }
    }

    private void getAllConnections(RequestContext context, OlapClientConnectionWrapper wrapper) {
        FilterCriteria filterCriteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$OlapClientConnection));
        ResourceLookup[] resourceLookup = this.repository.findResource(JasperServerUtil.getExecutionContext(context), filterCriteria);
        ArrayList<String> allMondrianConnections = null;
        ArrayList<String> allXmlaConnections = null;
        if (resourceLookup != null && resourceLookup.length != 0) {
            this.log("Found conneciton lookups size=" + resourceLookup.length);
            allMondrianConnections = new ArrayList<String>(resourceLookup.length);
            allXmlaConnections = new ArrayList<String>(resourceLookup.length);
            for (int i = 0; i < resourceLookup.length; ++i) {
                ResourceLookup resource = resourceLookup[i];
                Resource resourceObj = this.repository.getResource(null, resource.getURIString());
                if (resourceObj instanceof MondrianConnection) {
                    if (allMondrianConnections.contains(((OlapClientConnection)resourceObj).getURIString())) continue;
                    allMondrianConnections.add(((OlapClientConnection)resourceObj).getURIString());
                    continue;
                }
                if (resourceObj instanceof XMLAConnection) {
                    if (allXmlaConnections.contains(((OlapClientConnection)resourceObj).getURIString())) continue;
                    allXmlaConnections.add(((OlapClientConnection)resourceObj).getURIString());
                    continue;
                }
                throw new JSException("jsexception.unknown.connection.type");
            }
            wrapper.setReusableMondrianConnections(allMondrianConnections);
            wrapper.setReusableXmlaConnections(allXmlaConnections);
        }
    }

    private void getAllXmlaSources(RequestContext context, OlapClientConnectionWrapper wrapper) {
        FilterCriteria filterCriteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianXMLADefinition));
        ResourceLookup[] resourceLookup = this.repository.findResource(JasperServerUtil.getExecutionContext(context), filterCriteria);
        ArrayList<String> allXmlaDefinitions = null;
        if (resourceLookup != null && resourceLookup.length != 0) {
            this.log("Found xmla definition lookups size=" + resourceLookup.length);
            allXmlaDefinitions = new ArrayList<String>(resourceLookup.length);
            for (int i = 0; i < resourceLookup.length; ++i) {
                ResourceLookup resource = resourceLookup[i];
                Resource resourceObj = this.repository.getResource(null, resource.getURIString());
                if (allXmlaDefinitions.contains(((MondrianXMLADefinition)resourceObj).getURIString())) continue;
                allXmlaDefinitions.add(((MondrianXMLADefinition)resourceObj).getCatalog());
            }
            wrapper.setReusableXmlaDefinitions(allXmlaDefinitions);
        }
    }

    private void getAllFolders(OlapClientConnectionWrapper wrapper) {
        List allFolders = this.repository.getAllFolders(null);
        wrapper.setAllFolders(new ArrayList());
        for (int i = 0; i < allFolders.size(); ++i) {
            String folderUri = ((Folder)allFolders.get(i)).getURIString();
            wrapper.getAllFolders().add(folderUri);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Event handleTypeSelection(RequestContext context) throws Exception {
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        String strType = wrapper.getType();
        this.log("Type=" + strType);
        if (strType == null) throw new JSException("jsexception.no.connection.selected");
        if (strType.equals(JasperServerConstImpl.getOlapMondrianConnectionType())) {
            wrapper.setOlapConnectionType("olapMondrianSchema");
            return this.success();
        } else {
            if (!strType.equals(JasperServerConstImpl.getOlapXmlaConnectionType())) throw new JSException("jsexception.connection.type.not.suported");
            wrapper.setOlapConnectionType("xmlaConnection");
        }
        return this.success();
    }

    public Event locateSchemaResource(RequestContext context) throws Exception {
        this.log("In locateSchemaResource");
        OlapClientConnectionWrapper occWrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        if (occWrapper == null) {
            throw new JSException("jsexception.no.olap.client.connection");
        }
        this.log("Olap client connection name=" + occWrapper.getConnectionName());
        FileResourceWrapper frW = new FileResourceWrapper();
        FileResource fileR = (FileResource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
        fileR.setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
        frW.setMode((byte)3);
        frW.setFileResource(fileR);
        frW.setParentFlowObject(occWrapper);
        frW.setNewUri(occWrapper.getSchemaUri());
        frW.setSource(occWrapper.getSource());
        context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)((String)context.getFlowScope().get(PARENT_FOLDER_ATTR)));
        context.getFlowScope().put(FileResourceAction.getFORM_OBJECT_KEY(), (Object)frW);
        return this.success();
    }

    public Event locateDataSource(RequestContext context) throws Exception {
        this.log("In locate data source");
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        ResourceReference dsRef = new ResourceReference(wrapper.getDatasourceUri());
        ReportDataSourceWrapper odWrapper = new ReportDataSourceWrapper();
        odWrapper.setMode((byte)3);
        odWrapper.setParentFlowObject(wrapper);
        odWrapper.setParentType("olapMondrianSchema");
        if (dsRef == null) {
            this.log("Found no previous OlapDataSource, creating new");
            ReportDataSource ods = (ReportDataSource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.JdbcOlapDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource);
            ods.setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
            dsRef = new ResourceReference((Resource)ods);
            OlapClientConnectionAction olapClientConnectionAction = this;
            odWrapper.setSource(olapClientConnectionAction.constants.getFieldChoiceLocal());
            OlapClientConnectionAction olapClientConnectionAction2 = this;
            odWrapper.setType(olapClientConnectionAction2.constants.getJDBCDatasourceType());
            odWrapper.setReportDataSource(ods);
        } else {
            if (!dsRef.isLocal()) {
                this.log("Found OlapDataSourceLookup");
                OlapClientConnectionAction olapClientConnectionAction = this;
                odWrapper.setSource(olapClientConnectionAction.constants.getFieldChoiceRepo());
            } else {
                OlapClientConnectionAction olapClientConnectionAction = this;
                odWrapper.setSource(olapClientConnectionAction.constants.getFieldChoiceLocal());
                ReportDataSource ods = (ReportDataSource)dsRef.getLocalResource();
                if ((class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.JdbcOlapDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JdbcOlapDataSource).isAssignableFrom(ods.getClass())) {
                    this.log("Found JDBCOlapDataSource");
                    OlapClientConnectionAction olapClientConnectionAction3 = this;
                    odWrapper.setType(olapClientConnectionAction3.constants.getJDBCDatasourceType());
                } else {
                    this.log("Found JndiJdbcOlapDataSourceLookup");
                    if ((class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.JndiJdbcOlapDataSource")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$JndiJdbcOlapDataSource).isAssignableFrom(ods.getClass())) {
                        OlapClientConnectionAction olapClientConnectionAction4 = this;
                        odWrapper.setType(olapClientConnectionAction4.constants.getJNDIDatasourceType());
                    }
                }
                odWrapper.setReportDataSource(ods);
            }
            odWrapper.setSelectedUri(dsRef.getReferenceURI());
        }
        context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)((String)context.getFlowScope().get(PARENT_FOLDER_ATTR)));
        context.getFlowScope().put(OlapDataSourceAction.getFORM_OBJECT_KEY(), (Object)odWrapper);
        return this.success();
    }

    public Event saveSchemaResource(RequestContext context) throws Exception {
        this.log("In save schema resource");
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        FileResourceWrapper frWrapper = (FileResourceWrapper)context.getFlowScope().get(SCHEMA_OBJECT_KEY);
        if (frWrapper == null) {
            throw new JSException("jsexception.got.null.schema.source.wrapper");
        }
        this.log("type was " + frWrapper.getClass().getName());
        FileResource fileResource = frWrapper.getFileResource();
        if (fileResource == null) {
            throw new JSException("jsexception.got.null.schema.source.wrapper");
        }
        this.log("type was " + frWrapper.getFileResource().getFileType());
        wrapper.setOlapClientSchema(fileResource);
        wrapper.setSchemaUri(fileResource.getPath());
        OlapClientConnectionAction olapClientConnectionAction = this;
        if (frWrapper.getSource().equals(olapClientConnectionAction.constants.getFieldChoiceFile())) {
            wrapper.setSchemaLoaded(true);
        } else {
            wrapper.setSchemaUri(frWrapper.getFileResource().getReferenceURI());
        }
        wrapper.setConnectionModified(true);
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        ReportDataSourceWrapper resource = (ReportDataSourceWrapper)context.getFlowScope().get(DATASOURCE_OBJECT_KEY);
        if (resource == null) {
            throw new JSException("jsexception.got.null.schema.source.wrapper");
        }
        this.log("type was " + resource.getType());
        OlapClientConnectionAction olapClientConnectionAction = this;
        if (resource.getSource().equals(olapClientConnectionAction.constants.getFieldChoiceRepo())) {
            if (wrapper.getOlapClientDatasource() == null) {
                ReportDataSource datasource = (ReportDataSource)this.repository.getResource(null, resource.getSelectedUri());
                resource.setReportDataSource(datasource);
            }
            wrapper.setOlapClientDatasource(resource.getReportDataSource());
            wrapper.setDatasourceUri(resource.getSelectedUri());
        } else {
            ReportDataSource datasource = resource.getReportDataSource();
            if (datasource == null) {
                this.log("No datasource specified for OLAP connection.");
                return this.no();
            }
            wrapper.setOlapClientDatasource(datasource);
            wrapper.setDatasourceUri(datasource.getPath());
            wrapper.setDatasourceAdded(true);
        }
        wrapper.setConnectionModified(true);
        return this.success();
    }

    public Event saveMondrianConnection(RequestContext context) throws Exception {
        this.log("In saveMondrianConnection");
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        OlapUnitWrapper parentWrapper = (OlapUnitWrapper)wrapper.getParentFlowObject();
        MondrianConnection mondrianConnection = null;
        if (wrapper.getSource().equals("CONTENT_REPOSITORY")) {
            if (wrapper.getMode() == 3) {
                if (wrapper.getConnectionUri() == null) {
                    throw new JSException("jsexception.connection.uri.not.specified");
                }
                mondrianConnection = (MondrianConnection)this.repository.getResource(null, wrapper.getConnectionUri());
                parentWrapper.setOlapClientConnection((OlapClientConnection)mondrianConnection);
                parentWrapper.setConnectionUri(wrapper.getConnectionUri());
                wrapper.setSchemaUri(mondrianConnection.getSchema().getReferenceURI());
                wrapper.setDatasourceUri(mondrianConnection.getDataSource().getReferenceURI());
                wrapper.setConnectionModified(false);
            } else if (wrapper.getMode() == 2) {
                mondrianConnection = (MondrianConnection)wrapper.getOlapClientConnection();
                this.setMondrianConnectionDetails(wrapper, mondrianConnection);
                this.repository.saveResource(null, (Resource)mondrianConnection);
            } else {
                mondrianConnection = (MondrianConnection)this.repository.getResource(null, wrapper.getConnectionUri());
                this.getMondrianConnectionDetails(wrapper, mondrianConnection);
                wrapper.setConnectionModified(true);
            }
        } else {
            try {
                mondrianConnection = (MondrianConnection)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$MondrianConnection);
            }
            catch (Exception e) {
                throw new JSException("jsexception.failed.to.create.connection");
            }
            if (wrapper.isSchemaLoaded()) {
                FileResource schema = wrapper.getOlapClientSchema();
                if (!wrapper.isSubflowMode()) {
                    schema.setURIString(wrapper.getSchemaUri());
                    this.olapConnection.saveResource(null, wrapper.getOlapClientSchema().getParentFolder(), (Resource)schema);
                } else {
                    parentWrapper.setOlapClientSchema(schema);
                    parentWrapper.setSchemaLoaded(true);
                }
            }
            if (wrapper.isDatasourceAdded()) {
                ReportDataSource datasource = wrapper.getOlapClientDatasource();
                if (!wrapper.isSubflowMode()) {
                    datasource.setURIString(wrapper.getDatasourceUri());
                    this.repository.saveResource(null, (Resource)datasource);
                } else {
                    parentWrapper.setOlapClientDatasource(datasource);
                    parentWrapper.setDatasourceAdded(true);
                }
            }
            if (wrapper.isConnectionModified()) {
                this.setMondrianConnectionDetails(wrapper, mondrianConnection);
            }
            if (!wrapper.isSubflowMode()) {
                mondrianConnection.setParentFolder((String)context.getFlowScope().get(PARENT_FOLDER_ATTR));
                try {
                    this.repository.saveResource(null, (Resource)mondrianConnection);
                }
                catch (Exception e) {
                    throw new JSException("jsexception.failed.to.save.connection.changes");
                }
            } else {
                mondrianConnection.setParentFolder(((OlapUnitWrapper)wrapper.getParentFlowObject()).getOlapUnit().getParentFolder());
                parentWrapper.setOlapClientConnection((OlapClientConnection)mondrianConnection);
                parentWrapper.setConnectionModified(true);
            }
        }
        wrapper.setOlapConnectionType("olapMondrianSchema");
        wrapper.setOlapClientConnection((OlapClientConnection)mondrianConnection);
        return this.success();
    }

    private void setMondrianConnectionDetails(OlapClientConnectionWrapper wrapper, MondrianConnection mondrianConnection) {
        mondrianConnection.setName(wrapper.getConnectionName());
        mondrianConnection.setLabel(wrapper.getConnectionLabel());
        mondrianConnection.setDescription(wrapper.getConnectionDescription());
        mondrianConnection.setURIString(mondrianConnection.getParentFolder() + "/" + mondrianConnection.getName());
        mondrianConnection.setSchemaReference(wrapper.getOlapClientSchema().getURIString());
        if (wrapper.getMode() == 4) {
            try {
                this.repository.getResource(null, wrapper.getOlapClientSchema().getReferenceURI());
            }
            catch (Exception e) {
                this.repository.saveResource(null, (Resource)wrapper.getOlapClientSchema());
            }
        }
        mondrianConnection.setDataSourceReference(wrapper.getOlapClientDatasource().getURIString());
        if (wrapper.getMode() == 4) {
            try {
                this.repository.getResource(null, wrapper.getOlapClientDatasource().getURIString());
            }
            catch (Exception e) {
                this.repository.saveResource(null, (Resource)wrapper.getOlapClientDatasource());
            }
        }
    }

    private void getMondrianConnectionDetails(OlapClientConnectionWrapper wrapper, MondrianConnection mondrianConnection) {
        wrapper.setConnectionName(mondrianConnection.getName());
        wrapper.setConnectionLabel(mondrianConnection.getLabel());
        wrapper.setConnectionDescription(mondrianConnection.getDescription());
        wrapper.setSchemaUri(mondrianConnection.getSchema().getReferenceURI());
        wrapper.setDatasourceUri(mondrianConnection.getDataSource().getReferenceURI());
    }

    public Event saveXmlaConnection(RequestContext context) throws Exception {
        this.log("In saveXmlaConnection");
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        OlapUnitWrapper parentWrapper = (OlapUnitWrapper)wrapper.getParentFlowObject();
        XMLAConnection xmlaConnection = (XMLAConnection)wrapper.getOlapClientConnection();
        if (wrapper.getSource().equals("CONTENT_REPOSITORY")) {
            if (wrapper.getMode() == 3) {
                if (wrapper.getConnectionUri() == null) {
                    throw new JSException("jsexception.connection.uri.not.specified");
                }
                xmlaConnection = (XMLAConnection)this.repository.getResource(null, wrapper.getConnectionUri());
                parentWrapper.setOlapClientConnection((OlapClientConnection)xmlaConnection);
                parentWrapper.setConnectionUri(wrapper.getConnectionUri());
                wrapper.setConnectionModified(false);
            } else if (wrapper.getMode() == 2) {
                this.setXmlaConnectionDetails(wrapper, xmlaConnection);
                this.repository.saveResource(null, (Resource)xmlaConnection);
            } else {
                xmlaConnection = (XMLAConnection)this.repository.getResource(null, wrapper.getConnectionUri());
                this.getXmlaConnectionDetails(wrapper, xmlaConnection);
                wrapper.setConnectionModified(true);
            }
        } else {
            xmlaConnection = (XMLAConnection)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection == null ? (class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection = OlapClientConnectionAction.class$("com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection")) : class$com$jaspersoft$jasperserver$api$metadata$olap$domain$XMLAConnection);
            xmlaConnection.setParentFolder(wrapper.getParentFolder());
            this.setXmlaConnectionDetails(wrapper, xmlaConnection);
            if (!wrapper.isSubflowMode()) {
                try {
                    this.repository.saveResource(null, (Resource)xmlaConnection);
                }
                catch (Exception e) {
                    throw new JSException("jsexception.failed.to.save.connection");
                }
            } else {
                xmlaConnection.setParentFolder(((OlapUnitWrapper)wrapper.getParentFlowObject()).getOlapUnit().getParentFolder());
                parentWrapper.setOlapClientConnection((OlapClientConnection)xmlaConnection);
                parentWrapper.setConnectionModified(true);
                wrapper.setConnectionModified(true);
            }
        }
        wrapper.setOlapConnectionType("xmlaConnection");
        wrapper.setOlapClientConnection((OlapClientConnection)xmlaConnection);
        return this.success();
    }

    private void setXmlaConnectionDetails(OlapClientConnectionWrapper wrapper, XMLAConnection xmlaConnection) {
        xmlaConnection.setName(wrapper.getConnectionName());
        xmlaConnection.setLabel(wrapper.getConnectionLabel());
        xmlaConnection.setDescription(wrapper.getConnectionDescription());
        xmlaConnection.setCatalog(wrapper.getXmlaCatalog());
        xmlaConnection.setDataSource(wrapper.getXmlaDatasource());
        xmlaConnection.setURI(wrapper.getXmlaConnectionUri());
        xmlaConnection.setUsername(wrapper.getUsername());
        xmlaConnection.setPassword(wrapper.getPassword());
    }

    private void getXmlaConnectionDetails(OlapClientConnectionWrapper wrapper, XMLAConnection xmlaConnection) {
        wrapper.setConnectionName(xmlaConnection.getName());
        wrapper.setConnectionLabel(xmlaConnection.getLabel());
        wrapper.setConnectionDescription(xmlaConnection.getDescription());
        wrapper.setXmlaCatalog(xmlaConnection.getCatalog());
        wrapper.setXmlaDatasource(xmlaConnection.getDataSource());
        wrapper.setXmlaConnectionUri(xmlaConnection.getURI());
        wrapper.setUsername(xmlaConnection.getUsername());
        wrapper.setPassword(xmlaConnection.getPassword());
    }

    public Object createFormObject(RequestContext context) {
        OlapClientConnectionWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get("resource");
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            try {
                formObject = (OlapClientConnectionWrapper)this.getFormObjectClass().newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)("FormObjectClass invalid: " + this.getFormObjectClass()));
            }
            OlapClientConnection occ = (OlapClientConnection)this.repository.getResource(null, resourceUri);
            formObject.setOlapClientConnection(occ);
            formObject.setConnectionName(occ.getName());
            formObject.setConnectionLabel(occ.getLabel());
            formObject.setConnectionDescription(occ.getDescription());
            if (occ instanceof MondrianConnection) {
                MondrianConnection mc = (MondrianConnection)occ;
                formObject.setOlapConnectionType("olapMondrianSchema");
                String uri = mc.getSchema().getReferenceURI();
                formObject.setOriginalSchemaUri(uri);
                formObject.setSchemaUri(uri);
                formObject.setDatasourceUri(mc.getDataSource().getReferenceURI());
                formObject.setSchemaLocated(true);
            } else if (occ instanceof XMLAConnection) {
                XMLAConnection xmlac = (XMLAConnection)occ;
                formObject.setOlapConnectionType("xmlaConnection");
                formObject.setXmlaCatalog(xmlac.getCatalog());
                formObject.setXmlaDatasource(xmlac.getDataSource());
                formObject.setXmlaConnectionUri(xmlac.getURI());
                formObject.setUsername(xmlac.getUsername());
                formObject.setPassword(xmlac.getPassword());
            } else {
                this.log("Unknown connection type");
            }
            formObject.setMode((byte)2);
            formObject.setDatasourceIdentified(true);
            formObject.setNamed(true);
        }
        if (formObject == null) {
            this.log("OlapUnitAction: Stand alone new mode");
            try {
                formObject = (OlapClientConnectionWrapper)this.getFormObjectClass().newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)("FormObjectClass invalid: " + this.getFormObjectClass()));
            }
            formObject.setMode((byte)1);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            formObject.setSource("FILE_SYSTEM");
        }
        return formObject;
    }

    public Event validateOlapConnection(RequestContext context) throws Exception {
        this.log("In Validate OLAP Connection");
        OlapClientConnectionWrapper wrapper = (OlapClientConnectionWrapper)this.getFormObject(context);
        OlapClientConnection connection = wrapper.getOlapClientConnection();
        if (!wrapper.getOlapConnectionType().equals("olapMondrianSchema") && !wrapper.getOlapConnectionType().equals("xmlaConnection")) {
            throw new JSException("jsexception.unknown.connection.type");
        }
        return this.success();
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public OlapConnectionService getOlapConnection() {
        return this.olapConnection;
    }

    public void setOlapConnection(OlapConnectionService olapConnection) {
        this.olapConnection = olapConnection;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = OlapClientConnectionAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    protected void log(String text) {
        this.log.debug((Object)text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

