/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ObjectPermissionAction
extends FormAction {
    protected final String RESOURCE = "resource";
    protected final String ATTRIBUTE_PERMISSIONS = "permissions";
    protected final String ATTRIBUTE_ROLES = "roles";
    protected final String ATTRIBUTE_USERS = "users";
    protected final int NO_ACCESS = 0;
    protected final int NO_PERMISSION_SET = -1;
    protected final int INHERITED = 256;
    protected final String PERMISSION_PARM = "permission_";
    protected final String PREV_PERMISSION_PARM = "prev";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ObjectPermissionService objectPermissionService;
    private RepositoryService repository;
    private UserAuthorityService userService;

    public Event loadPermissionsForRoles(RequestContext context) {
        ExecutionContext executionContext = this.getExecutionContext(context);
        List roleList = this.userService.getRoles(executionContext, null);
        HashMap<Role, Integer> permissionsMap = new HashMap<Role, Integer>();
        Resource resource = (Resource)context.getFlowScope().get("resource");
        if (resource == null) {
            String resourceUri = context.getRequestParameters().get("resource");
            resource = this.repository.getResource(executionContext, resourceUri);
            if (resource == null) {
                resource = this.repository.getFolder(executionContext, resourceUri);
            }
            context.getFlowScope().put("resource", (Object)resource);
        }
        for (int i = 0; i < roleList.size(); ++i) {
            ObjectPermission objectPermission;
            Role role = (Role)roleList.get(i);
            Integer permissionToDisplay = new Integer(-1);
            List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(executionContext, (Object)resource, (Object)role);
            if (permissions != null && permissions.size() > 0 && (objectPermission = (ObjectPermission)permissions.get(0)) != null && objectPermission.getPermissionRecipient() != null) {
                permissionToDisplay = new Integer(objectPermission.getPermissionMask() + this.goUpFolderChainToGetPermission(executionContext, resource, role));
            }
            if (!"/".equals(resource.getURIString()) && permissionToDisplay == -1) {
                permissionToDisplay = new Integer(this.goUpFolderChainToGetPermission(executionContext, resource, role) + 256);
            } else if ("/".equals(resource.getURIString()) && permissionToDisplay == -1) {
                permissionToDisplay = new Integer(256);
            }
            permissionsMap.put(role, permissionToDisplay);
        }
        context.getRequestScope().put("permissions", permissionsMap);
        context.getRequestScope().put("roles", (Object)roleList);
        return this.success();
    }

    private int goUpFolderChainToGetPermission(ExecutionContext context, Resource resource, Object roleOrUser) {
        ObjectPermission objectPermission;
        String parentFolderPath = resource.getParentFolder();
        if (parentFolderPath == null) {
            return 0;
        }
        Folder parentResource = this.repository.getFolder(context, parentFolderPath);
        Integer permissionToDisplay = new Integer(0);
        List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)parentResource, roleOrUser);
        if (permissions != null && permissions.size() > 0 && (objectPermission = (ObjectPermission)permissions.get(0)) != null && objectPermission.getPermissionRecipient() != null) {
            permissionToDisplay = new Integer(objectPermission.getPermissionMask() << 9);
        }
        if (permissionToDisplay == 0 && !"/".equals(parentFolderPath)) {
            permissionToDisplay = new Integer(this.goUpFolderChainToGetPermission(context, (Resource)parentResource, roleOrUser));
        }
        return permissionToDisplay;
    }

    public Event loadPermissionsForUsers(RequestContext context) {
        ExecutionContext executionContext = this.getExecutionContext(context);
        List userList = this.userService.getUsers(executionContext, null);
        HashMap<User, Integer> permissionsMap = new HashMap<User, Integer>();
        Resource resource = (Resource)context.getFlowScope().get("resource");
        if (resource == null) {
            String resourceUri = context.getRequestParameters().get("resource");
            resource = this.repository.getResource(executionContext, resourceUri);
            if (resource == null) {
                resource = this.repository.getFolder(executionContext, resourceUri);
            }
            context.getFlowScope().put("resource", (Object)resource);
        }
        for (int i = 0; i < userList.size(); ++i) {
            ObjectPermission objectPermission;
            User user = (User)userList.get(i);
            Integer permissionToDisplay = new Integer(-1);
            List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(executionContext, (Object)resource, (Object)user);
            if (permissions != null && permissions.size() > 0 && (objectPermission = (ObjectPermission)permissions.get(0)) != null && objectPermission.getPermissionRecipient() != null) {
                permissionToDisplay = new Integer(objectPermission.getPermissionMask() + this.goUpFolderChainToGetPermission(executionContext, resource, user));
            }
            if (!"/".equals(resource.getURIString()) && permissionToDisplay == -1) {
                permissionToDisplay = new Integer(this.goUpFolderChainToGetPermission(executionContext, resource, user) + 256);
            } else if ("/".equals(resource.getURIString()) && permissionToDisplay == -1) {
                permissionToDisplay = new Integer(256);
            }
            permissionsMap.put(user, permissionToDisplay);
        }
        context.getRequestScope().put("permissions", permissionsMap);
        context.getRequestScope().put("users", (Object)userList);
        return this.success();
    }

    public Event setRolePermission(RequestContext context) {
        Map parameters = context.getRequestParameters().asMap();
        Iterator iter = parameters.keySet().iterator();
        ArrayList<String> parmList = new ArrayList<String>();
        while (iter.hasNext()) {
            String currentParameterName = (String)iter.next();
            if (!currentParameterName.startsWith("permission_")) continue;
            parmList.add(currentParameterName);
        }
        if (parmList.size() <= 0) {
            return this.success();
        }
        Resource resource = (Resource)context.getFlowScope().get("resource");
        for (int i = 0; i < parmList.size(); ++i) {
            String roleName = ((String)parmList.get(i)).substring("permission_".length());
            Role role = this.userService.getRole(this.getExecutionContext(context), roleName);
            String permission = context.getRequestParameters().get((String)parmList.get(i));
            String prevPermission = context.getRequestParameters().get("prev" + (String)parmList.get(i));
            int permissionValue = Integer.parseInt(permission);
            int prevPermissionValue = Integer.parseInt(prevPermission);
            if (prevPermissionValue == permissionValue) continue;
            if (permissionValue <= 255) {
                int upChainPermission;
                if (permissionValue == 0) {
                    upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, role);
                    if (upChainPermission == 0) {
                        if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, role)) continue;
                        throw new RuntimeException(" Error occurred in object-permission delete. ");
                    }
                    if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue)) continue;
                    throw new RuntimeException(" Error occurred in object-permission Save. ");
                }
                upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, role);
                if (upChainPermission == permissionValue << 9) {
                    if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, role)) continue;
                    throw new RuntimeException(" Error occurred in object-permission delete. ");
                }
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if ("/".equals(resource.getURIString()) && permissionValue != 256) {
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue /= 512)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if (permissionValue >= 256) {
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue /= 512)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, role)) continue;
            throw new RuntimeException(" Error occurred in object-permission delete. ");
        }
        return this.success();
    }

    public Event setUserPermission(RequestContext context) {
        Map parameters = context.getRequestParameters().asMap();
        Iterator iter = parameters.keySet().iterator();
        ArrayList<String> parmList = new ArrayList<String>();
        while (iter.hasNext()) {
            String currentParameterName = (String)iter.next();
            if (!currentParameterName.startsWith("permission_")) continue;
            parmList.add(currentParameterName);
        }
        if (parmList.size() <= 0) {
            return this.success();
        }
        Resource resource = (Resource)context.getFlowScope().get("resource");
        for (int i = 0; i < parmList.size(); ++i) {
            String userName = ((String)parmList.get(i)).substring("permission_".length());
            User user = this.userService.getUser(this.getExecutionContext(context), userName);
            String permission = context.getRequestParameters().get((String)parmList.get(i));
            String prevPermission = context.getRequestParameters().get("prev" + (String)parmList.get(i));
            int permissionValue = Integer.parseInt(permission);
            int prevPermissionValue = Integer.parseInt(prevPermission);
            if (prevPermissionValue == permissionValue) continue;
            if (permissionValue <= 255) {
                int upChainPermission;
                if (permissionValue == 0) {
                    upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, user);
                    if (upChainPermission == 0) {
                        if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, user)) continue;
                        throw new RuntimeException(" Error occurred in object-permission delete. ");
                    }
                    if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue)) continue;
                    throw new RuntimeException(" Error occurred in object-permission Save. ");
                }
                upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, user);
                if (upChainPermission == permissionValue << 9) {
                    if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, user)) continue;
                    throw new RuntimeException(" Error occurred in object-permission delete. ");
                }
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if ("/".equals(resource.getURIString()) && permissionValue != 256) {
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue /= 512)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if (permissionValue >= 256) {
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue /= 512)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, user)) continue;
            throw new RuntimeException(" Error occurred in object-permission delete. ");
        }
        return this.success();
    }

    private boolean performObjectPermissionSave(ExecutionContext context, Resource targetObject, Object recipientObject, int permission) {
        if (recipientObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: recipient is null");
            return false;
        }
        if (targetObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: target is null");
            return false;
        }
        ObjectPermission objectPermission = null;
        List lstObjPerms = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)targetObject, recipientObject);
        if (lstObjPerms != null && lstObjPerms.size() > 0) {
            objectPermission = (ObjectPermission)lstObjPerms.get(0);
        }
        if (objectPermission == null) {
            objectPermission = this.objectPermissionService.newObjectPermission(context);
        }
        objectPermission.setURI(targetObject.getProtocol() + ":" + targetObject.getURIString());
        objectPermission.setPermissionMask(permission);
        objectPermission.setPermissionRecipient(recipientObject);
        this.objectPermissionService.putObjectPermission(context, objectPermission);
        return true;
    }

    private boolean performObjectPermissionDelete(ExecutionContext context, Resource targetObject, Object recipientObject) {
        if (recipientObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: recipient is null");
            return false;
        }
        if (targetObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: target is null");
            return false;
        }
        ObjectPermission objectPermission = null;
        List lstObjPerms = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)targetObject, recipientObject);
        if (lstObjPerms != null && lstObjPerms.size() > 0) {
            objectPermission = (ObjectPermission)lstObjPerms.get(0);
        }
        if (objectPermission == null || objectPermission.getPermissionRecipient() == null) {
            this.log.warn((Object)"performObjectPermissionDelete: no permission for target and recipient");
            return true;
        }
        this.objectPermissionService.deleteObjectPermission(context, objectPermission);
        return true;
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put("currentPage", (Object)context.getRequestParameters().get("currentPage"));
        return this.success();
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected ExecutionContext getExecutionContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext(context);
    }
}

