/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.OlapClientConnectionWrapper;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class FileResourceAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String FORM_OBJECT_KEY = "fileResource";
    private static final String FILERES_URI_PARAM = "resource";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CONSTANTS_KEY = "constants";
    private RepositoryService repository;
    private ConfigurationBean configuration;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$FileResourceWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource;
    static /* synthetic */ Class array$B;

    public FileResourceAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$FileResourceWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$FileResourceWrapper = FileResourceAction.class$("com.jaspersoft.jasperserver.war.dto.FileResourceWrapper")) : class$com$jaspersoft$jasperserver$war$dto$FileResourceWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Event initAction(RequestContext context) throws Exception {
        String folderURI;
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        if (wrapper.isSubflowMode()) {
            FilterCriteria criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = FileResourceAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource));
            if (wrapper.getFileResource().getFileType() != null && wrapper.getFileResource().getFileType().trim().length() != 0) {
                criteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)wrapper.getFileResource().getFileType()));
            }
            ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
            ArrayList<String> allResources = null;
            if (lookups != null && lookups.length != 0) {
                allResources = new ArrayList<String>();
                this.log("Found lookups size=" + lookups.length);
                for (int i = 0; i < lookups.length; ++i) {
                    allResources.add(lookups[i].getURIString());
                }
            }
            wrapper.setAllResources(allResources);
        }
        if (wrapper.isNewMode()) {
            folderURI = wrapper.getFileResource().getParentFolder();
            if (folderURI == null) {
                folderURI = "/";
            }
            FilterCriteria resourcesInFolder = FilterCriteria.createFilter();
            resourcesInFolder.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
            this.log("Searching for resources in the chosen folder:" + folderURI);
            ResourceLookup[] existingResources = this.repository.findResource(null, resourcesInFolder);
            if (existingResources != null && existingResources.length != 0) {
                this.log("res lookup size=" + existingResources.length);
                ArrayList<String> allResources = new ArrayList<String>();
                for (int i = 0; i < existingResources.length; ++i) {
                    ResourceLookup rLookup = existingResources[i];
                    allResources.add(rLookup.getName());
                    this.log("adding resource: " + rLookup.getName() + " to the list");
                }
                wrapper.setExistingResources(allResources);
            }
        }
        if (wrapper.isSubflowMode()) {
            this.getAllFolders(wrapper);
            folderURI = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (folderURI == null) {
                folderURI = "/";
            }
            wrapper.getFileResource().setParentFolder(folderURI);
            if (wrapper.getParentFlowObject() instanceof OlapClientConnectionWrapper) {
                wrapper.getFileResource().setFileType("olapMondrianSchema");
            }
        }
        context.getFlowScope().put(FORM_OBJECT_KEY, (Object)wrapper);
        context.getFlowScope().put(CONSTANTS_KEY, (Object)new JasperServerConstImpl());
        return this.success();
    }

    private void getAllFolders(FileResourceWrapper wrapper) {
        List allFolders = this.repository.getAllFolders(null);
        wrapper.setAllFolders(new ArrayList());
        for (int i = 0; i < allFolders.size(); ++i) {
            String folderUri = ((Folder)allFolders.get(i)).getURIString();
            wrapper.getAllFolders().add(folderUri);
        }
    }

    public Event determineType(RequestContext context) throws Exception {
        String newUri;
        String fileExtension;
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        if (wrapper.getFileResource().getFileType() == null && (fileExtension = context.getExternalContext().getRequestMap().getString("uploadedFileExt")) != null && fileExtension.trim().length() != 0) {
            wrapper.getFileResource().setFileType(FileResourceWrapper.getTypeForExtention(fileExtension));
        }
        if (wrapper.getSource() != null && wrapper.getSource().equals("CONTENT_REPOSITORY") && (newUri = wrapper.getNewUri()) != null && newUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, newUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{newUri});
            }
            if ((class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = FileResourceAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource).isAssignableFrom(resource.getClass())) {
                FileResource fileR = (FileResource)resource;
                wrapper.getFileResource().setFileType(fileR.getFileType());
            }
            if (wrapper.getFileResource().getFileType().equals("olapMondrianSchema")) {
                ((FileResource)resource).setReferenceURI(wrapper.getFileResource().getReferenceURI());
                wrapper.setFileResource((FileResource)resource);
            }
        }
        wrapper.setLocated(true);
        return this.success();
    }

    public Event setupNamingForm(RequestContext context) throws Exception {
        context.getRequestScope().put("allTypes", (Object)this.configuration.getAllFileResourceTypes());
        return this.success();
    }

    public Event saveResource(RequestContext context) throws Exception {
        this.log("In saveresource");
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        if (wrapper.getFileResource().getParentFolder() == null) {
            wrapper.getFileResource().setParentFolder("/");
        }
        if (wrapper.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)wrapper.getFileResource());
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("fileResource.name", "FileResourceValidator.error.duplicate");
                return this.error();
            }
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        FileResourceWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get(FILERES_URI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new FileResourceWrapper();
            formObject.setFileResource((FileResource)resource);
            formObject.setMode((byte)2);
            formObject.setLocated(true);
        }
        if (formObject == null) {
            formObject = new FileResourceWrapper();
            formObject.setMode((byte)1);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            FileResource fileResource = (FileResource)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource = FileResourceAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$FileResource);
            fileResource.setParentFolder(parentFolder);
            fileResource.setVersion(-1);
            formObject.setFileResource(fileResource);
        }
        return formObject;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(array$B == null ? (array$B = FileResourceAction.class$("[B")) : array$B, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    private void log(String text) {
        this.log.debug((Object)text);
    }

    public static String getFORM_OBJECT_KEY() {
        return FORM_OBJECT_KEY;
    }

    protected void doBind(RequestContext context, DataBinder binder) {
        super.doBind(context, binder);
        FileResourceWrapper res = (FileResourceWrapper)binder.getTarget();
        res.afterBind();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

