/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.DataTypeWrapper;
import com.jaspersoft.jasperserver.war.dto.InputControlWrapper;
import com.jaspersoft.jasperserver.war.dto.ListOfValuesDTO;
import com.jaspersoft.jasperserver.war.dto.ResourceReferenceDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class DefineInputControlsAction
extends FormAction {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String FORM_OBJECT_KEY = "control";
    private static final String CONSTANTS_KEY = "constants";
    private static final String DATATYPE_KEY = "dataType";
    private static final String LOV_KEY = "listOfValuesDTO";
    private static final String INPUTCONTROLURI_PARAM = "resource";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private RepositoryService repository;
    private String queryReferenceReqAttrName;
    private String queryReferenceOutpuAttrName;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$InputControlWrapper;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$dto$ResourceReferenceDTO;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public DefineInputControlsAction() {
        this.setFormObjectClass(class$com$jaspersoft$jasperserver$war$dto$InputControlWrapper == null ? (class$com$jaspersoft$jasperserver$war$dto$InputControlWrapper = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.war.dto.InputControlWrapper")) : class$com$jaspersoft$jasperserver$war$dto$InputControlWrapper);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Event initControlDefinition(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        context.getFlowScope().put(CONSTANTS_KEY, (Object)new JasperServerConstImpl());
        if (formObject.isAloneNewMode()) {
            InputControl ic = formObject.getInputControl();
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)ic.getParentFolder()));
            ResourceLookup[] resources = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
            List<ResourceLookup> allResources = Arrays.asList(resources);
            formObject.setAllResources(allResources);
        }
        return this.success();
    }

    public Event prepareForControlType(RequestContext context) throws Exception {
        String uri;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        InputControl control = formObject.getInputControl();
        int selectedType = control.getType();
        if (selectedType == 0) {
            this.log("Selected type was null");
            selectedType = 2;
        }
        FilterCriteria criteria = null;
        if (selectedType == 6 || selectedType == 3 || selectedType == 8 || selectedType == 10) {
            criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues));
            if (control.getListOfValues() != null) {
                uri = control.getListOfValues().getReferenceURI();
                if (uri != null) {
                    formObject.setExistingPath(uri);
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
                } else {
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
                }
            } else {
                formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        if (selectedType == 7 || selectedType == 4 || selectedType == 9 || selectedType == 11) {
            criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.Query")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$Query));
            if (control.getQuery() != null) {
                uri = control.getQuery().getReferenceURI();
                if (uri != null) {
                    formObject.setExistingPath(uri);
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
                } else {
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
                }
            } else {
                formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        if (selectedType == 5 || selectedType == 2) {
            criteria = FilterCriteria.createFilter((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.DataType")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType));
            if (control.getDataType() != null) {
                uri = control.getDataType().getReferenceURI();
                if (uri != null) {
                    formObject.setExistingPath(uri);
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
                } else {
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
                }
            } else {
                formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        if (selectedType == 1) {
            return this.success();
        }
        this.log("control type=" + selectedType);
        ArrayList<String> existingPathsList = new ArrayList<String>();
        ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
        if (lookups != null) {
            this.log("Found lookups size=" + lookups.length);
            for (int i = 0; i < lookups.length; ++i) {
                existingPathsList.add(lookups[i].getURIString());
                if (lookups[i] != null) {
                    this.log("Found path=" + lookups[i].getURIString());
                    continue;
                }
                this.log("Found null Lookup at " + i);
            }
        }
        formObject.setExistingPathList(existingPathsList);
        return this.success();
    }

    public Event handleDataTypeControl(RequestContext context) throws Exception {
        DataTypeWrapper wrapper;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (formObject == null) {
            return this.error();
        }
        InputControl control = formObject.getInputControl();
        formObject.setSource(context.getRequestParameters().get("source"));
        if (formObject.getSource().equals(JasperServerConstImpl.getFieldChoiceLocal())) {
            if (control.getDataType() == null || control.getDataType().getLocalResource() == null) {
                DataType dt = (DataType)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.DataType")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$DataType);
                control.setDataType(dt);
                wrapper = new DataTypeWrapper(dt);
            } else {
                if (control.getDataType().isLocal()) {
                    DataType dt = (DataType)control.getDataType().getLocalResource();
                    if (dt.getDecimals() != null) {
                        formObject.setDtDecimals(dt.getDecimals().toString());
                    }
                    if (dt.getMaxLength() != null) {
                        formObject.setDtMaxLength(dt.getMaxLength().toString());
                    }
                }
                wrapper = new DataTypeWrapper((DataType)control.getDataType().getLocalResource());
            }
        } else {
            String path = context.getRequestParameters().get("existingPath");
            control.setDataTypeReference(path);
            return this.yes();
        }
        wrapper.setMode(wrapper.getDataType().isNew() ? (byte)3 : 4);
        context.getFlowScope().put(DATATYPE_KEY, (Object)wrapper);
        return this.success();
    }

    public Event handleLovControl(RequestContext context) throws Exception {
        ListOfValuesDTO listOfValues;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (formObject == null) {
            return this.error();
        }
        InputControl control = formObject.getInputControl();
        formObject.setSource(context.getRequestParameters().get("source"));
        if (formObject.getSource().equals(JasperServerConstImpl.getFieldChoiceLocal())) {
            if (control.getListOfValues() == null || control.getListOfValues().getLocalResource() == null) {
                ListOfValues lov = (ListOfValues)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$ListOfValues);
                control.setListOfValues(lov);
                listOfValues = new ListOfValuesDTO(lov);
                listOfValues.setMode((byte)3);
            } else {
                listOfValues = new ListOfValuesDTO((ListOfValues)control.getListOfValues().getLocalResource());
                listOfValues.setMode((byte)4);
            }
        } else {
            String path = context.getRequestParameters().get("existingPath");
            control.setListOfValuesReference(path);
            return this.yes();
        }
        context.getFlowScope().put(LOV_KEY, (Object)listOfValues);
        return this.success();
    }

    public Event saveInputControl(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        InputControl control = formObject.getInputControl();
        if (control.getType() == 2 || control.getType() == 5) {
            DataType dataType = (DataType)control.getDataType().getLocalResource();
            if (formObject.getDtMaxLength() != null && formObject.getDtMaxLength().length() > 0) {
                dataType.setMaxLength(new Integer(formObject.getDtMaxLength()));
            }
            if (formObject.getDtDecimals() != null && formObject.getDtDecimals().length() > 0) {
                dataType.setDecimals(new Integer(formObject.getDtDecimals()));
            }
        }
        if (formObject.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)control);
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("inputControl.name", "InputControlsFlowValidator.error.already.exists");
                return this.error();
            }
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        InputControl control;
        InputControlWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get(INPUTCONTROLURI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            InputControl resource = (InputControl)this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new InputControlWrapper(resource);
            formObject.setMode((byte)2);
        }
        if (formObject == null) {
            InputControl inputControl = (InputControl)this.repository.newResource(null, class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl")) : class$com$jaspersoft$jasperserver$api$metadata$common$domain$InputControl);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            inputControl.setParentFolder(parentFolder);
            formObject = new InputControlWrapper(inputControl);
            formObject.setMode((byte)1);
        }
        if ((control = formObject.getInputControl()).getParentFolder() == null) {
            control.setParentFolder("/");
        }
        formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
        return formObject;
    }

    public Event addVisibleColumn(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        formObject.getInputControl().addQueryVisibleColumn(formObject.getNewVisibleColumn());
        return this.success();
    }

    public Event removeVisibleColumn(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (context.getRequestParameters().contains("itemToDelete")) {
            String[] selectedColumns = context.getRequestParameters().getArray("itemToDelete");
            for (int i = 0; i < selectedColumns.length; ++i) {
                formObject.getInputControl().removeQueryVisibleColumn(selectedColumns[i]);
            }
        }
        return this.success();
    }

    private void log(String text) {
        this.log.debug((Object)text);
    }

    public static String getFORM_OBJECT_KEY() {
        return FORM_OBJECT_KEY;
    }

    public Event prepareQuery(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        ResourceReference queryRef = formObject.getInputControl().getQuery();
        ResourceReferenceDTO queryRefDTO = new ResourceReferenceDTO(queryRef);
        context.getRequestScope().put(this.getQueryReferenceReqAttrName(), (Object)queryRefDTO);
        return this.success();
    }

    public Event setQueryReference(RequestContext context) throws Exception {
        ResourceReferenceDTO queryRef = (ResourceReferenceDTO)context.getFlowScope().getRequired(this.getQueryReferenceOutpuAttrName(), class$com$jaspersoft$jasperserver$war$dto$ResourceReferenceDTO == null ? (class$com$jaspersoft$jasperserver$war$dto$ResourceReferenceDTO = DefineInputControlsAction.class$("com.jaspersoft.jasperserver.war.dto.ResourceReferenceDTO")) : class$com$jaspersoft$jasperserver$war$dto$ResourceReferenceDTO);
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        formObject.getInputControl().setQuery(queryRef.toResourceReference());
        return this.success();
    }

    public String getQueryReferenceReqAttrName() {
        return this.queryReferenceReqAttrName;
    }

    public void setQueryReferenceReqAttrName(String queryReferenceReqAttrName) {
        this.queryReferenceReqAttrName = queryReferenceReqAttrName;
    }

    public String getQueryReferenceOutpuAttrName() {
        return this.queryReferenceOutpuAttrName;
    }

    public void setQueryReferenceOutpuAttrName(String queryReferenceOutpuAttrName) {
        this.queryReferenceOutpuAttrName = queryReferenceOutpuAttrName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

