/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.war.common.FileBufferedOutputStream;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.ExportParameters;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractReportExporter
extends MultiAction {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$action$AbstractReportExporter == null ? (class$com$jaspersoft$jasperserver$war$action$AbstractReportExporter = AbstractReportExporter.class$("com.jaspersoft.jasperserver.war.action.AbstractReportExporter")) : class$com$jaspersoft$jasperserver$war$action$AbstractReportExporter));
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private String flowAttributeJasperPrintName;
    private String flowAttributeReportUnitURI;
    private boolean setResponseContentLength = true;
    private int memoryThreshold = 262144;
    private int initialMemoryBufferSize = 65536;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$action$AbstractReportExporter;

    public Event export(RequestContext context) throws IOException, JRException {
        JasperPrint jasperPrint;
        ServletExternalContext servletContext = (ServletExternalContext)context.getExternalContext();
        HttpServletResponse response = servletContext.getResponse();
        MutableAttributeMap flowAttrs = context.getFlowScope();
        String jasperPrintName = flowAttrs.getRequiredString(this.getFlowAttributeJasperPrintName());
        ReportUnitResult result = (ReportUnitResult)this.getJasperPrintAccessor().getObject(servletContext.getRequest(), jasperPrintName);
        JasperPrint jasperPrint2 = jasperPrint = result == null ? null : result.getJasperPrint();
        if (jasperPrint == null) {
            throw new JSException("jsexception.jasperprint.not.found", new Object[]{jasperPrintName});
        }
        String reportUnitURI = flowAttrs.getRequiredString(this.getFlowAttributeReportUnitURI());
        if (this.setResponseContentLength) {
            this.exportBuffered(context, response, jasperPrint, reportUnitURI);
        } else {
            this.exportToStream(context, response, jasperPrint, reportUnitURI);
        }
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportToStream(RequestContext context, HttpServletResponse response, JasperPrint jasperPrint, String reportUnitURI) throws IOException, JRException {
        HashMap<JRExporterParameter, Object> parameters = new HashMap<JRExporterParameter, Object>();
        parameters.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        ServletOutputStream ouputStream = response.getOutputStream();
        parameters.put(JRExporterParameter.OUTPUT_STREAM, ouputStream);
        try {
            response.setContentType(this.getContentType(context));
            this.setAdditionalResponseHeaders(context, response);
            this.export(context, this.getExecutionContext(context), reportUnitURI, parameters);
        }
        finally {
            if (ouputStream != null) {
                try {
                    ouputStream.close();
                }
                catch (IOException ex) {
                    log.warn((Object)"Error closing output stream", (Throwable)ex);
                }
            }
        }
    }

    protected ExecutionContext getExecutionContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportBuffered(RequestContext context, HttpServletResponse response, JasperPrint jasperPrint, String reportUnitURI) throws IOException, JRException {
        HashMap<JRExporterParameter, Object> parameters = new HashMap<JRExporterParameter, Object>();
        parameters.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        FileBufferedOutputStream bufferedOutput = new FileBufferedOutputStream(this.getMemoryThreshold(), this.getInitialMemoryBufferSize());
        parameters.put(JRExporterParameter.OUTPUT_STREAM, bufferedOutput);
        try {
            this.export(context, this.getExecutionContext(context), reportUnitURI, parameters);
            bufferedOutput.close();
            response.setContentType(this.getContentType(context));
            this.setAdditionalResponseHeaders(context, response);
            response.setContentLength(bufferedOutput.size());
            ServletOutputStream ouputStream = response.getOutputStream();
            try {
                bufferedOutput.writeData((OutputStream)ouputStream);
                bufferedOutput.dispose();
                ouputStream.flush();
            }
            finally {
                if (ouputStream != null) {
                    try {
                        ouputStream.close();
                    }
                    catch (IOException ex) {
                        log.warn((Object)"Error closing output stream", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            bufferedOutput.close();
            bufferedOutput.dispose();
        }
    }

    public String getFlowAttributeJasperPrintName() {
        return this.flowAttributeJasperPrintName;
    }

    public void setFlowAttributeJasperPrintName(String flowAttributeJasperPrintName) {
        this.flowAttributeJasperPrintName = flowAttributeJasperPrintName;
    }

    public String getFlowAttributeReportUnitURI() {
        return this.flowAttributeReportUnitURI;
    }

    public void setFlowAttributeReportUnitURI(String requestAttributeReportUnitURI) {
        this.flowAttributeReportUnitURI = requestAttributeReportUnitURI;
    }

    public boolean isSetResponseContentLength() {
        return this.setResponseContentLength;
    }

    public void setSetResponseContentLength(boolean setResponseContentLength) {
        this.setResponseContentLength = setResponseContentLength;
    }

    public int getInitialMemoryBufferSize() {
        return this.initialMemoryBufferSize;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public void setInitialMemoryBufferSize(int initialMemoryBufferSize) {
        this.initialMemoryBufferSize = initialMemoryBufferSize;
    }

    protected abstract String getContentType(RequestContext var1);

    protected abstract ExportParameters getExportParameters(RequestContext var1);

    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        response.setHeader("Pragma", "");
        response.setHeader("Cache-Control", "no-store");
    }

    protected String getReportName(RequestContext context) {
        MutableAttributeMap flowAttrs = context.getFlowScope();
        String reportUnitURI = flowAttrs.getRequiredString(this.getFlowAttributeReportUnitURI());
        return reportUnitURI.substring(reportUnitURI.lastIndexOf("/") + 1);
    }

    protected abstract void export(RequestContext var1, ExecutionContext var2, String var3, Map var4) throws JRException;

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

