/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.tonbeller.jpivot.chart.ChartComponent;
import com.tonbeller.jpivot.print.PrintComponent;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactoryFinder;
import com.tonbeller.wcf.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OlapPrint
extends HttpServlet {
    private static final Log logger = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$war$OlapPrint == null ? (class$com$jaspersoft$jasperserver$war$OlapPrint = OlapPrint.class$("com.jaspersoft.jasperserver.war.OlapPrint")) : class$com$jaspersoft$jasperserver$war$OlapPrint));
    private static int XLS = 0;
    private static int PDF = 1;
    String filename;
    Resources resources = Resources.instance((Class)(class$com$jaspersoft$jasperserver$war$OlapPrint == null ? (class$com$jaspersoft$jasperserver$war$OlapPrint = OlapPrint.class$("com.jaspersoft.jasperserver.war.OlapPrint")) : class$com$jaspersoft$jasperserver$war$OlapPrint));
    Driver driver;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$war$OlapPrint;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Configuration.put((String)"fontBaseDir", (Object)config.getServletContext().getRealPath("/WEB-INF/jpivot/print/"));
            logger.debug((Object)("fontBaseDir=" + Configuration.getStringValue((String)"fontBaseDir")));
            String fopConfigPath = config.getServletContext().getRealPath("/WEB-INF/jpivot/print/userconfig.xml");
            logger.debug((Object)("fopConfigPath=" + fopConfigPath));
            new Options(new File(fopConfigPath));
            logger.debug((Object)"Construct driver");
            this.driver = new Driver();
            this.driver.setLogger((Logger)new NullLogger());
            logger.debug((Object)"Setup Renderer (output format)");
            this.driver.setRenderer(1);
            logger.debug((Object)"FOP renderer set to PDF");
        }
        catch (FOPException e) {
            e.printStackTrace();
            logger.info((Object)"FOP user config file not loaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)"FOP user config file not loaded");
        }
    }

    public void destroy() {
    }

    protected void processRequest(RequestContext context) throws ServletException, IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        HttpSession session = request.getSession();
        String type = request.getParameter("type");
        int identifiedType = -1;
        boolean xslCache = true;
        String view = request.getParameter("view");
        if (view == null || type == null) {
            throw new ServletException("view and type parameters not supplied");
        }
        try {
            String xslUri = null;
            if (type.equalsIgnoreCase("XLS")) {
                xslUri = "/WEB-INF/jpivot/table/xls_mdxtable.xsl";
                RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
                response.setContentType("application/vnd.ms-excel");
                this.filename = "xls_export.xls";
                identifiedType = XLS;
            } else if (type.equalsIgnoreCase("PDF")) {
                xslUri = "/WEB-INF/jpivot/table/fo_mdxtable.xsl";
                RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                response.setContentType("application/pdf");
                this.filename = "xls_export.pdf";
                identifiedType = PDF;
            } else {
                throw new ServletException("Unknown file type: " + type);
            }
            String tableRef = view + "/table";
            String chartRef = view + "/chart";
            String printRef = view + "/print";
            TableComponent table = (TableComponent)context.getModelReference(tableRef);
            if (table == null) {
                return;
            }
            Map parameters = this.getPrintParameters(printRef, context);
            parameters.putAll(this.getChartParameters(chartRef, request));
            parameters.put("context", context.getRequest().getContextPath());
            StringWriter sw = this.getRenderedTableDOM(table, parameters, session, context, xslUri, xslCache);
            ServletOutputStream outStream = response.getOutputStream();
            PrintWriter out = new PrintWriter((OutputStream)outStream);
            response.setHeader("Content-Disposition", "attachment; filename=" + this.filename);
            if (identifiedType == XLS) {
                logger.debug((Object)"Creating XLS");
                response.setContentLength(sw.toString().length());
                out.write(sw.toString());
                RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
            } else {
                logger.debug((Object)"Creating PDF");
                try {
                    logger.debug((Object)this.resources.getString("jpivot.PrintServlet.message.encoding", new Object[]{this.resources.getCharacterEncoding()}));
                    ByteArrayInputStream bain = new ByteArrayInputStream(sw.toString().getBytes(this.resources.getEncodingProvider().getCharacterEncoding()));
                    ByteArrayOutputStream baout = new ByteArrayOutputStream(16384);
                    this.convertFO2PDF(bain, baout);
                    byte[] content = baout.toByteArray();
                    response.setContentLength(content.length);
                    outStream.write(content);
                    RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            out.flush();
            out.close();
            outStream.flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    private Map getPrintParameters(String printRef, RequestContext context) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PrintComponent printConfig = (PrintComponent)context.getModelReference(printRef);
        if (printConfig == null) {
            return parameters;
        }
        if (printConfig.isSetTableWidth()) {
            printConfig.getClass();
            parameters.put("tableWidth", new Double(printConfig.getTableWidth()));
        }
        if (printConfig.getReportTitle().trim().length() != 0) {
            printConfig.getClass();
            parameters.put("reportTitle", printConfig.getReportTitle().trim());
        }
        printConfig.getClass();
        parameters.put("pageOrientation", printConfig.getPageOrientation());
        printConfig.getClass();
        parameters.put("paper.type", printConfig.getPaperType());
        if (printConfig.getPaperType().equals(this.resources.getString("jsp.wcf.print.custom"))) {
            printConfig.getClass();
            parameters.put("pageWidth", new Double(printConfig.getPageWidth()));
            printConfig.getClass();
            parameters.put("pageHeight", new Double(printConfig.getPageHeight()));
        }
        printConfig.getClass();
        parameters.put("chartPageBreak", new Boolean(printConfig.isChartPageBreak()));
        return parameters;
    }

    private Map getChartParameters(String chartRef, HttpServletRequest request) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ChartComponent chart = (ChartComponent)request.getSession().getAttribute(chartRef);
        if (chart == null || !chart.isVisible()) {
            return parameters;
        }
        String host = request.getServerName();
        int port = request.getServerPort();
        String location = request.getContextPath();
        String scheme = request.getScheme();
        String chartServlet = scheme + "://" + host + ":" + port + location + "/GetChart";
        parameters.put("chartimage", chartServlet + "?filename=" + chart.getFilename());
        parameters.put("chartheight", new Integer(chart.getChartHeight()));
        parameters.put("chartwidth", new Integer(chart.getChartWidth()));
        return parameters;
    }

    private StringWriter getRenderedTableDOM(TableComponent table, Map parameters, HttpSession session, RequestContext context, String xslUri, boolean xslCache) throws Exception {
        table.setDirty(true);
        Document document = table.render(context);
        table.setDirty(true);
        DOMSource source = new DOMSource(document);
        Transformer transformer = XmlUtils.getTransformer((HttpSession)session, (String)xslUri, (boolean)xslCache);
        Iterator it = parameters.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object value = parameters.get(name);
            transformer.setParameter(name, value);
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        sw.flush();
        return sw;
    }

    public void convertFO2PDF(ByteArrayInputStream bain, ByteArrayOutputStream baout) throws IOException, FOPException {
        this.driver.setOutputStream((OutputStream)baout);
        logger.debug((Object)"Setup input");
        this.driver.setInputSource(new InputSource(bain));
        logger.debug((Object)"Process FO");
        this.driver.run();
        logger.debug((Object)"PDF file generation completed");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestContext context = RequestContextFactoryFinder.createContext((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
        try {
            this.processRequest(context);
        }
        finally {
            context.invalidate();
        }
    }

    public String getServletInfo() {
        return "Export OLAP table to Excel or PDF";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

