/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap;

import java.io.UnsupportedEncodingException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class LdapUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ldap$LdapUtils == null ? (class$org$acegisecurity$ldap$LdapUtils = LdapUtils.class$("org.acegisecurity.ldap.LdapUtils")) : class$org$acegisecurity$ldap$LdapUtils));
    static /* synthetic */ Class class$org$acegisecurity$ldap$LdapUtils;

    public static void closeContext(Context ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to close context.", (Throwable)e);
        }
    }

    public static String getRelativeName(String fullDn, Context baseCtx) throws NamingException {
        String baseDn = baseCtx.getNameInNamespace();
        if (baseDn.length() == 0) {
            return fullDn;
        }
        if (baseDn.equals(fullDn)) {
            return "";
        }
        int index = fullDn.lastIndexOf(baseDn);
        Assert.isTrue((index > 0 ? 1 : 0) != 0, (String)"Context base DN is not contained in the full DN");
        return fullDn.substring(0, index - 1);
    }

    public static byte[] getUtf8Bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to convert string to UTF-8 bytes. Shouldn't be possible");
        }
    }

    public static String parseRootDnFromUrl(String url) {
        Assert.hasLength((String)url);
        String urlRootDn = "";
        if (url.startsWith("ldap:") || url.startsWith("ldaps:")) {
            int colon = url.indexOf(58);
            int slash = (url = url.substring(colon + 3)).indexOf(47);
            if (slash >= 0) {
                urlRootDn = url.substring(slash);
            }
        } else {
            urlRootDn = url;
        }
        if (urlRootDn.startsWith("/")) {
            urlRootDn = urlRootDn.substring(1);
        }
        return urlRootDn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

