/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class HttpSessionContextIntegrationFilter
implements InitializingBean,
Filter {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$context$HttpSessionContextIntegrationFilter == null ? (class$org$acegisecurity$context$HttpSessionContextIntegrationFilter = HttpSessionContextIntegrationFilter.class$("org.acegisecurity.context.HttpSessionContextIntegrationFilter")) : class$org$acegisecurity$context$HttpSessionContextIntegrationFilter));
    private static final String FILTER_APPLIED = "__acegi_session_integration_filter_applied";
    public static final String ACEGI_SECURITY_CONTEXT_KEY = "ACEGI_SECURITY_CONTEXT";
    private Class context = class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilter.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl;
    private Object contextObject;
    private boolean allowSessionCreation = true;
    private boolean forceEagerSessionCreation = false;
    static /* synthetic */ Class class$org$acegisecurity$context$HttpSessionContextIntegrationFilter;
    static /* synthetic */ Class class$org$acegisecurity$context$SecurityContextImpl;
    static /* synthetic */ Class class$org$acegisecurity$context$SecurityContext;

    public void afterPropertiesSet() throws Exception {
        if (this.context == null || !(class$org$acegisecurity$context$SecurityContext == null ? (class$org$acegisecurity$context$SecurityContext = HttpSessionContextIntegrationFilter.class$("org.acegisecurity.context.SecurityContext")) : class$org$acegisecurity$context$SecurityContext).isAssignableFrom(this.context)) {
            throw new IllegalArgumentException("context must be defined and implement SecurityContext (typically use org.acegisecurity.context.SecurityContextImpl; existing class is " + this.context + ")");
        }
        if (this.forceEagerSessionCreation && !this.allowSessionCreation) {
            throw new IllegalArgumentException("If using forceEagerSessionCreation, you must set allowSessionCreation to also be true");
        }
        this.contextObject = this.generateNewContext();
    }

    public void destroy() {
    }

    /*
     * Loose catch block
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block51: {
            int contextWhenChainProceeded;
            boolean httpSessionExistedAtStartOfRequest;
            HttpSession httpSession;
            if (request != null && request.getAttribute(FILTER_APPLIED) != null) {
                chain.doFilter(request, response);
            } else {
                if (request != null) {
                    request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
                }
                httpSession = null;
                httpSessionExistedAtStartOfRequest = false;
                try {
                    httpSession = ((HttpServletRequest)request).getSession(this.forceEagerSessionCreation);
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
                if (httpSession != null) {
                    httpSessionExistedAtStartOfRequest = true;
                    Object contextFromSessionObject = httpSession.getAttribute(ACEGI_SECURITY_CONTEXT_KEY);
                    if (contextFromSessionObject != null) {
                        if (contextFromSessionObject instanceof SecurityContext) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Obtained from ACEGI_SECURITY_CONTEXT a valid SecurityContext and set to SecurityContextHolder: '" + contextFromSessionObject + "'"));
                            }
                            SecurityContextHolder.setContext((SecurityContext)contextFromSessionObject);
                        } else {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("ACEGI_SECURITY_CONTEXT did not contain a SecurityContext but contained: '" + contextFromSessionObject + "'; are you improperly modifying the HttpSession directly (you should always use SecurityContextHolder) or using the HttpSession attribute reserved for this class? - new SecurityContext instance associated with SecurityContextHolder"));
                            }
                            SecurityContextHolder.setContext(this.generateNewContext());
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"HttpSession returned null object for ACEGI_SECURITY_CONTEXT - new SecurityContext instance associated with SecurityContextHolder");
                        }
                        SecurityContextHolder.setContext(this.generateNewContext());
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"No HttpSession currently exists - new SecurityContext instance associated with SecurityContextHolder");
                    }
                    SecurityContextHolder.setContext(this.generateNewContext());
                }
                httpSession = null;
                contextWhenChainProceeded = SecurityContextHolder.getContext().hashCode();
                chain.doFilter(request, response);
                Object var9_9 = null;
                try {
                    httpSession = ((HttpServletRequest)request).getSession(false);
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
                if (httpSession == null && httpSessionExistedAtStartOfRequest && logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                }
                if (httpSession == null && !httpSessionExistedAtStartOfRequest) {
                    if (!this.allowSessionCreation) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"The HttpSession is currently null, and the HttpSessionContextIntegrationFilter is prohibited from creating a HttpSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                        }
                    } else if (!this.contextObject.equals(SecurityContextHolder.getContext())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"HttpSession being created as SecurityContextHolder contents are non-default");
                        }
                        try {
                            httpSession = ((HttpServletRequest)request).getSession(true);
                        }
                        catch (IllegalStateException ignored) {}
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("HttpSession is null, but SecurityContextHolder has not changed from default: ' " + SecurityContextHolder.getContext() + "'; not creating HttpSession or storing SecurityContextHolder contents"));
                    }
                }
                if (httpSession != null && SecurityContextHolder.getContext().hashCode() != contextWhenChainProceeded) {
                    httpSession.setAttribute(ACEGI_SECURITY_CONTEXT_KEY, (Object)SecurityContextHolder.getContext());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SecurityContext stored to HttpSession: '" + SecurityContextHolder.getContext() + "'"));
                    }
                }
                SecurityContextHolder.clearContext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"SecurityContextHolder set to new context, as request processing completed");
                }
            }
            break block51;
            {
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (ServletException se) {
                    throw se;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    httpSession = ((HttpServletRequest)request).getSession(false);
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
                if (httpSession == null && httpSessionExistedAtStartOfRequest && logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                }
                if (httpSession == null && !httpSessionExistedAtStartOfRequest) {
                    if (!this.allowSessionCreation) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"The HttpSession is currently null, and the HttpSessionContextIntegrationFilter is prohibited from creating a HttpSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                        }
                    } else if (!this.contextObject.equals(SecurityContextHolder.getContext())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"HttpSession being created as SecurityContextHolder contents are non-default");
                        }
                        try {
                            httpSession = ((HttpServletRequest)request).getSession(true);
                        }
                        catch (IllegalStateException ignored) {}
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("HttpSession is null, but SecurityContextHolder has not changed from default: ' " + SecurityContextHolder.getContext() + "'; not creating HttpSession or storing SecurityContextHolder contents"));
                    }
                }
                if (httpSession != null && SecurityContextHolder.getContext().hashCode() != contextWhenChainProceeded) {
                    httpSession.setAttribute(ACEGI_SECURITY_CONTEXT_KEY, (Object)SecurityContextHolder.getContext());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SecurityContext stored to HttpSession: '" + SecurityContextHolder.getContext() + "'"));
                    }
                }
                SecurityContextHolder.clearContext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"SecurityContextHolder set to new context, as request processing completed");
                }
                throw throwable;
            }
        }
    }

    public SecurityContext generateNewContext() throws ServletException {
        try {
            return (SecurityContext)this.context.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ServletException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new ServletException((Throwable)iae);
        }
    }

    public Class getContext() {
        return this.context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public boolean isForceEagerSessionCreation() {
        return this.forceEagerSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public void setContext(Class secureContext) {
        this.context = secureContext;
    }

    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

