/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.client;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import java.util.Date;
import java.util.List;

public class ResourceLookupImpl
implements ResourceLookup {
    private int version;
    private Date creationDate;
    private String name;
    private String label;
    private String description;
    private String folderUri;
    private String uri;
    private String resourceType;
    private List attributes = null;

    private static String getParentFolderFromUri(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int lastSeparator = s.lastIndexOf("/");
        if (lastSeparator <= 0) {
            return null;
        }
        return s.substring(0, lastSeparator);
    }

    private static String getNameFromUri(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int lastSeparator = s.lastIndexOf("/");
        if (lastSeparator < 0 || lastSeparator == s.length() - 1) {
            return null;
        }
        return s.substring(lastSeparator + 1, s.length());
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.uri = null;
        this.name = name;
    }

    public String getURIString() {
        if (this.uri == null) {
            StringBuffer sb = new StringBuffer();
            if (this.getParentFolder() != null && !this.getParentFolder().equals("/")) {
                sb.append(this.getParentFolder());
            }
            sb.append("/");
            if (!this.getName().equals("/")) {
                sb.append(this.getName());
            }
            this.uri = sb.toString();
        }
        return this.uri;
    }

    public String getURI() {
        return this.getProtocol() + ":" + this.getPath();
    }

    public String getParentURI() {
        return this.getParentFolder() == null ? null : this.getProtocol() + ":" + this.getParentFolder();
    }

    public String getParentPath() {
        return this.getParentFolder() == null ? null : this.getParentFolder();
    }

    public String getPath() {
        return this.getURIString();
    }

    public String getProtocol() {
        return "repo";
    }

    public String getParentFolder() {
        return this.folderUri;
    }

    public void setParentFolder(Folder folder) {
        this.uri = null;
        this.folderUri = folder.getURIString();
    }

    public void setParentFolder(String folderURI) {
        this.uri = null;
        this.folderUri = folderURI;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    protected final JSException lookupUnsupportedException() {
        return new JSException("jsexception.call.not.supported");
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isNew() {
        return false;
    }

    public void setURIString(String uri) {
        this.uri = null;
        this.name = ResourceLookupImpl.getNameFromUri(uri);
        this.folderUri = ResourceLookupImpl.getParentFolderFromUri(uri);
    }
}

