/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.optimizer.Block;

public class FatBlock {
    private ObjToIntMap itsSuccessors = new ObjToIntMap();
    private ObjToIntMap itsPredecessors = new ObjToIntMap();
    private Block itsShadowOfFormerSelf;

    public FatBlock(IRFactory irFactory, int startNodeIndex, int endNodeIndex, Node[] statementNodes) {
        this.itsShadowOfFormerSelf = new Block(irFactory, startNodeIndex, endNodeIndex, statementNodes);
    }

    public Node getEndNode() {
        return this.itsShadowOfFormerSelf.getEndNode();
    }

    public Block getSlimmerSelf() {
        return this.itsShadowOfFormerSelf;
    }

    private Block[] reduceToArray(ObjToIntMap map) {
        Block[] result = null;
        if (!map.isEmpty()) {
            result = new Block[map.size()];
            int i = 0;
            ObjToIntMap.Iterator iter = map.newIterator();
            iter.start();
            while (!iter.done()) {
                FatBlock fb = (FatBlock)iter.getKey();
                result[i++] = fb.itsShadowOfFormerSelf;
                iter.next();
            }
        }
        return result;
    }

    Block diet() {
        this.itsShadowOfFormerSelf.setSuccessorList(this.reduceToArray(this.itsSuccessors));
        this.itsShadowOfFormerSelf.setPredecessorList(this.reduceToArray(this.itsPredecessors));
        return this.itsShadowOfFormerSelf;
    }

    public void addSuccessor(FatBlock b) {
        this.itsSuccessors.put(b, 0);
    }

    public void addPredecessor(FatBlock b) {
        this.itsPredecessors.put(b, 0);
    }
}

