/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.optimizer.CSEHolder;
import org.mozilla.javascript.optimizer.DataFlowBitSet;
import org.mozilla.javascript.optimizer.FatBlock;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

public class Block {
    private IRFactory itsIRFactory;
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private Node[] itsStatementNodes;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;

    public Block(IRFactory irFactory, int startNodeIndex, int endNodeIndex, Node[] statementNodes) {
        this.itsIRFactory = irFactory;
        this.itsStartNodeIndex = startNodeIndex;
        this.itsEndNodeIndex = endNodeIndex;
        this.itsStatementNodes = statementNodes;
    }

    public void setBlockID(int id) {
        this.itsBlockID = id;
    }

    public int getBlockID() {
        return this.itsBlockID;
    }

    public Node getStartNode() {
        return this.itsStatementNodes[this.itsStartNodeIndex];
    }

    public Node getEndNode() {
        return this.itsStatementNodes[this.itsEndNodeIndex];
    }

    public Block[] getPredecessorList() {
        return this.itsPredecessors;
    }

    public Block[] getSuccessorList() {
        return this.itsSuccessors;
    }

    public static Block[] buildBlocks(IRFactory irFactory, Node[] statementNodes) {
        FatBlock fb;
        Hashtable<Node, FatBlock> theTargetBlocks = new Hashtable<Node, FatBlock>();
        ObjArray theBlocks = new ObjArray();
        int beginNodeIndex = 0;
        int i = 0;
        while (i < statementNodes.length) {
            switch (statementNodes[i].getType()) {
                case 137: {
                    if (i == beginNodeIndex) break;
                    fb = new FatBlock(irFactory, beginNodeIndex, i - 1, statementNodes);
                    if (statementNodes[beginNodeIndex].getType() == 137) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.add(fb);
                    beginNodeIndex = i;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    fb = new FatBlock(irFactory, beginNodeIndex, i, statementNodes);
                    if (statementNodes[beginNodeIndex].getType() == 137) {
                        theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
                    }
                    theBlocks.add(fb);
                    beginNodeIndex = i + 1;
                }
            }
            ++i;
        }
        if (beginNodeIndex != statementNodes.length) {
            fb = new FatBlock(irFactory, beginNodeIndex, statementNodes.length - 1, statementNodes);
            if (statementNodes[beginNodeIndex].getType() == 137) {
                theTargetBlocks.put(statementNodes[beginNodeIndex], fb);
            }
            theBlocks.add(fb);
        }
        int i2 = 0;
        while (i2 < theBlocks.size()) {
            FatBlock fb2 = (FatBlock)theBlocks.get(i2);
            Node blockEndNode = fb2.getEndNode();
            int blockEndNodeType = blockEndNode.getType();
            if (blockEndNodeType != 6 && i2 < theBlocks.size() - 1) {
                FatBlock fallThruTarget = (FatBlock)theBlocks.get(i2 + 1);
                fb2.addSuccessor(fallThruTarget);
                fallThruTarget.addPredecessor(fb2);
            }
            if (blockEndNodeType == 8 || blockEndNodeType == 7 || blockEndNodeType == 6) {
                Node target = (Node)blockEndNode.getProp(1);
                FatBlock branchTargetBlock = (FatBlock)theTargetBlocks.get(target);
                target.putProp(20, branchTargetBlock.getSlimmerSelf());
                fb2.addSuccessor(branchTargetBlock);
                branchTargetBlock.addPredecessor(fb2);
            }
            ++i2;
        }
        Block[] result = new Block[theBlocks.size()];
        int i3 = 0;
        while (i3 < theBlocks.size()) {
            FatBlock fb3 = (FatBlock)theBlocks.get(i3);
            result[i3] = fb3.diet();
            result[i3].setBlockID(i3);
            ++i3;
        }
        return result;
    }

    public static String toString(Block[] blockList, Node[] statementNodes) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(blockList.length + " Blocks");
        int i = 0;
        while (i < blockList.length) {
            int j;
            Block b = blockList[i];
            pw.println("#" + b.itsBlockID);
            pw.println("from " + b.itsStartNodeIndex + " " + statementNodes[b.itsStartNodeIndex].toString());
            pw.println("thru " + b.itsEndNodeIndex + " " + statementNodes[b.itsEndNodeIndex].toString());
            pw.print("Predecessors ");
            if (b.itsPredecessors != null) {
                j = 0;
                while (j < b.itsPredecessors.length) {
                    pw.print(b.itsPredecessors[j].getBlockID() + " ");
                    ++j;
                }
                pw.println();
            } else {
                pw.println("none");
            }
            pw.print("Successors ");
            if (b.itsSuccessors != null) {
                j = 0;
                while (j < b.itsSuccessors.length) {
                    pw.print(b.itsSuccessors[j].getBlockID() + " ");
                    ++j;
                }
                pw.println();
            } else {
                pw.println("none");
            }
            ++i;
        }
        return sw.toString();
    }

    void lookForVariablesAndCalls(Node n, boolean[] liveSet, OptFunctionNode fn) {
        switch (n.getType()) {
            case 73: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                this.lookForVariablesAndCalls(rhs, liveSet, fn);
                Object theVarProp = n.getProp(21);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                liveSet[theVarIndex] = true;
                break;
            }
            case 43: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.lookForVariablesAndCalls(child, liveSet, fn);
                    child = child.getNext();
                }
                int i = 0;
                while (i < liveSet.length) {
                    if (liveSet[i]) {
                        fn.getVar(i).markLiveAcrossCall();
                    }
                    ++i;
                }
                break;
            }
            case 72: {
                Object theVarProp = n.getProp(21);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                if (n.getProp(22) == null || this.itsLiveOnExitSet.test(theVarIndex)) break;
                liveSet[theVarIndex] = false;
                break;
            }
            default: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.lookForVariablesAndCalls(child, liveSet, fn);
                    child = child.getNext();
                }
                break block0;
            }
        }
    }

    void markAnyTypeVariables(OptFunctionNode fn) {
        int i = 0;
        while (i < fn.getVarCount()) {
            if (this.itsLiveOnEntrySet.test(i)) {
                fn.getVar(i).assignType(3);
            }
            ++i;
        }
    }

    void markVolatileVariables(OptFunctionNode fn) {
        boolean[] liveSet = new boolean[fn.getVarCount()];
        int i = 0;
        while (i < liveSet.length) {
            liveSet[i] = this.itsLiveOnEntrySet.test(i);
            ++i;
        }
        int i2 = this.itsStartNodeIndex;
        while (i2 <= this.itsEndNodeIndex) {
            Node n = this.itsStatementNodes[i2];
            this.lookForVariablesAndCalls(n, liveSet, fn);
            ++i2;
        }
    }

    void lookForVariableAccess(Node n, Node[] lastUse) {
        switch (n.getType()) {
            case 106: 
            case 107: {
                Object theVarProp;
                Node child = n.getFirstChild();
                if (child.getType() != 72 || (theVarProp = child.getProp(21)) == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                if (!this.itsNotDefSet.test(theVarIndex)) {
                    this.itsUseBeforeDefSet.set(theVarIndex);
                }
                this.itsNotDefSet.set(theVarIndex);
                break;
            }
            case 73: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                this.lookForVariableAccess(rhs, lastUse);
                Object theVarProp = n.getProp(21);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                this.itsNotDefSet.set(theVarIndex);
                if (lastUse[theVarIndex] == null) break;
                lastUse[theVarIndex].putProp(22, theVarProp);
                break;
            }
            case 72: {
                Object theVarProp = n.getProp(21);
                if (theVarProp == null) break;
                int theVarIndex = ((OptLocalVariable)theVarProp).getIndex();
                if (!this.itsNotDefSet.test(theVarIndex)) {
                    this.itsUseBeforeDefSet.set(theVarIndex);
                }
                lastUse[theVarIndex] = n;
                break;
            }
            default: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.lookForVariableAccess(child, lastUse);
                    child = child.getNext();
                }
                break block0;
            }
        }
    }

    void initLiveOnEntrySets(OptFunctionNode fn) {
        int listLength = fn.getVarCount();
        Node[] lastUse = new Node[listLength];
        this.itsUseBeforeDefSet = new DataFlowBitSet(listLength);
        this.itsNotDefSet = new DataFlowBitSet(listLength);
        this.itsLiveOnEntrySet = new DataFlowBitSet(listLength);
        this.itsLiveOnExitSet = new DataFlowBitSet(listLength);
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = this.itsStatementNodes[i];
            this.lookForVariableAccess(n, lastUse);
            ++i;
        }
        int i2 = 0;
        while (i2 < listLength) {
            if (lastUse[i2] != null) {
                lastUse[i2].putProp(22, this);
            }
            ++i2;
        }
        this.itsNotDefSet.not();
    }

    boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            int i = 0;
            while (i < this.itsSuccessors.length) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[i].itsLiveOnEntrySet);
                ++i;
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    int findExpressionType(Node n) {
        switch (n.getType()) {
            case 45: {
                return 1;
            }
            case 30: 
            case 43: {
                return 0;
            }
            case 41: {
                return 3;
            }
            case 72: {
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(21);
                if (theVar != null) {
                    return theVar.getTypeUnion();
                }
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 106: 
            case 107: {
                return 1;
            }
            case 23: {
                Node child = n.getFirstChild();
                int lType = this.findExpressionType(child);
                int rType = this.findExpressionType(child.getNext());
                return lType | rType;
            }
        }
        Node child = n.getFirstChild();
        if (child == null) {
            return 3;
        }
        int result = 0;
        while (child != null) {
            result |= this.findExpressionType(child);
            child = child.getNext();
        }
        return result;
    }

    boolean findDefPoints(Node n) {
        boolean result = false;
        switch (n.getType()) {
            default: {
                Node child = n.getFirstChild();
                while (child != null) {
                    result |= this.findDefPoints(child);
                    child = child.getNext();
                }
                break;
            }
            case 106: 
            case 107: {
                Node firstChild = n.getFirstChild();
                OptLocalVariable theVar = (OptLocalVariable)firstChild.getProp(21);
                if (theVar == null) break;
                result |= theVar.assignType(1);
                break;
            }
            case 40: {
                Node baseChild = n.getFirstChild();
                Node nameChild = baseChild.getNext();
                Node rhs = nameChild.getNext();
                if (baseChild != null) {
                    OptLocalVariable theVar;
                    if (baseChild.getType() == 72 && (theVar = (OptLocalVariable)baseChild.getProp(21)) != null) {
                        theVar.assignType(3);
                    }
                    result |= this.findDefPoints(baseChild);
                }
                if (nameChild != null) {
                    result |= this.findDefPoints(nameChild);
                }
                if (rhs == null) break;
                result |= this.findDefPoints(rhs);
                break;
            }
            case 73: {
                Node firstChild = n.getFirstChild();
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(21);
                if (theVar == null) break;
                Node rValue = firstChild.getNext();
                int theType = this.findExpressionType(rValue);
                result |= theVar.assignType(theType);
            }
        }
        return result;
    }

    void localCSE(Node parent, Node n, Hashtable theCSETable, OptFunctionNode theFunction) {
        switch (n.getType()) {
            default: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.localCSE(n, child, theCSETable, theFunction);
                    child = child.getNext();
                }
                break;
            }
            case 106: 
            case 107: {
                Node child = n.getFirstChild();
                if (child.getType() == 39) {
                    Node nameChild = child.getFirstChild().getNext();
                    if (nameChild.getType() == 46) {
                        theCSETable.remove(nameChild.getString());
                        break;
                    }
                    theCSETable.clear();
                    break;
                }
                if (child.getType() == 72) break;
                theCSETable.clear();
                break;
            }
            case 40: {
                Node baseChild = n.getFirstChild();
                Node nameChild = baseChild.getNext();
                Node rhs = nameChild.getNext();
                if (baseChild != null) {
                    this.localCSE(n, baseChild, theCSETable, theFunction);
                }
                if (nameChild != null) {
                    this.localCSE(n, nameChild, theCSETable, theFunction);
                }
                if (rhs != null) {
                    this.localCSE(n, rhs, theCSETable, theFunction);
                }
                if (nameChild.getType() == 46) {
                    theCSETable.remove(nameChild.getString());
                    break;
                }
                theCSETable.clear();
                break;
            }
            case 39: {
                Node theCSE;
                Node nameChild;
                Node baseChild = n.getFirstChild();
                if (baseChild != null) {
                    this.localCSE(n, baseChild, theCSETable, theFunction);
                }
                if (baseChild.getType() != 109 || baseChild.getOperation() != 50 || (nameChild = baseChild.getNext()).getType() != 46) break;
                String theName = nameChild.getString();
                Object cse = theCSETable.get(theName);
                if (cse == null) {
                    theCSETable.put(theName, new CSEHolder(parent, n));
                    break;
                }
                if (parent == null) break;
                if (cse instanceof CSEHolder) {
                    CSEHolder cseHolder = (CSEHolder)cse;
                    Node nextChild = cseHolder.getPropChild.getNext();
                    cseHolder.getPropParent.removeChild(cseHolder.getPropChild);
                    theCSE = this.itsIRFactory.createNewLocal(cseHolder.getPropChild);
                    theFunction.incrementLocalCount();
                    if (nextChild == null) {
                        cseHolder.getPropParent.addChildToBack(theCSE);
                    } else {
                        cseHolder.getPropParent.addChildBefore(theCSE, nextChild);
                    }
                    theCSETable.put(theName, theCSE);
                } else {
                    theCSE = (Node)cse;
                }
                Node nextChild = n.getNext();
                parent.removeChild(n);
                Node cseUse = this.itsIRFactory.createUseLocal(theCSE);
                if (nextChild == null) {
                    parent.addChildToBack(cseUse);
                    break;
                }
                parent.addChildBefore(cseUse, nextChild);
                break;
            }
            case 42: {
                Node lhsBase = n.getFirstChild();
                Node lhsIndex = lhsBase.getNext();
                Node rhs = lhsIndex.getNext();
                if (lhsBase != null) {
                    this.localCSE(n, lhsBase, theCSETable, theFunction);
                }
                if (lhsIndex != null) {
                    this.localCSE(n, lhsIndex, theCSETable, theFunction);
                }
                if (rhs != null) {
                    this.localCSE(n, rhs, theCSETable, theFunction);
                }
                theCSETable.clear();
                break;
            }
            case 43: {
                Node child = n.getFirstChild();
                while (child != null) {
                    this.localCSE(n, child, theCSETable, theFunction);
                    child = child.getNext();
                }
                theCSETable.clear();
            }
        }
    }

    Hashtable localCSE(Hashtable theCSETable, OptFunctionNode theFunction) {
        if (theCSETable == null) {
            theCSETable = new Hashtable(5);
        }
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = this.itsStatementNodes[i];
            if (n != null) {
                this.localCSE(null, n, theCSETable, theFunction);
            }
            ++i;
        }
        return theCSETable;
    }

    void findDefs() {
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = this.itsStatementNodes[i];
            if (n != null) {
                this.findDefPoints(n);
            }
            ++i;
        }
    }

    boolean doTypeFlow() {
        boolean changed = false;
        int i = this.itsStartNodeIndex;
        while (i <= this.itsEndNodeIndex) {
            Node n = this.itsStatementNodes[i];
            if (n != null) {
                changed |= this.findDefPoints(n);
            }
            ++i;
        }
        return changed;
    }

    boolean isLiveOnEntry(int index) {
        return this.itsLiveOnEntrySet != null && this.itsLiveOnEntrySet.test(index);
    }

    void printLiveOnEntrySet(PrintWriter pw, OptFunctionNode fn) {
        int i = 0;
        while (i < fn.getVarCount()) {
            String name = fn.getVar(i).getName();
            if (this.itsUseBeforeDefSet.test(i)) {
                pw.println(name + " is used before def'd");
            }
            if (this.itsNotDefSet.test(i)) {
                pw.println(name + " is not def'd");
            }
            if (this.itsLiveOnEntrySet.test(i)) {
                pw.println(name + " is live on entry");
            }
            if (this.itsLiveOnExitSet.test(i)) {
                pw.println(name + " is live on exit");
            }
            ++i;
        }
    }

    public void setSuccessorList(Block[] b) {
        this.itsSuccessors = b;
    }

    public void setPredecessorList(Block[] b) {
        this.itsPredecessors = b;
    }
}

