/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class JavaAdapter
extends ScriptableObject {
    private static int serial;
    private static Hashtable generatedClasses;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getClassName() {
        return "JavaAdapter";
    }

    public static Object convertResult(Object result, Class c) {
        if (result == Undefined.instance && c != ScriptRuntime.ObjectClass && c != ScriptRuntime.StringClass) {
            return null;
        }
        return NativeJavaObject.coerceType(c, result, true);
    }

    public static Scriptable setAdapterProto(Scriptable obj, Object adapter) {
        Scriptable scriptable;
        Context cx = Context.enter();
        try {
            Scriptable topLevel = ScriptableObject.getTopLevelScope(obj);
            Scriptable res = ScriptRuntime.toObject(topLevel, adapter);
            res.setPrototype(obj);
            scriptable = res;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return scriptable;
    }

    public static Object getAdapterSelf(Class adapterClass, Object adapter) throws NoSuchFieldException, IllegalAccessException {
        Field self = adapterClass.getDeclaredField("self");
        return self.get(adapter);
    }

    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        Class superClass = null;
        Class[] intfs = new Class[args.length - 1];
        int interfaceCount = 0;
        int i = 0;
        while (i < args.length - 1) {
            if (!(args[i] instanceof NativeJavaClass)) {
                throw NativeGlobal.constructError(cx, "TypeError", "expected java class object", ctorObj);
            }
            Class c = ((NativeJavaClass)args[i]).getClassObject();
            if (!c.isInterface()) {
                if (superClass != null) {
                    String msg = "Only one class may be extended by a JavaAdapter. Had " + superClass.getName() + " and " + c.getName();
                    throw NativeGlobal.constructError(cx, "TypeError", msg, ctorObj);
                }
                superClass = c;
            } else {
                intfs[interfaceCount++] = c;
            }
            ++i;
        }
        if (superClass == null) {
            superClass = class$java$lang$Object == null ? (class$java$lang$Object = JavaAdapter.class$("java.lang.Object")) : class$java$lang$Object;
        }
        Class[] interfaces = new Class[interfaceCount];
        System.arraycopy(intfs, 0, interfaces, 0, interfaceCount);
        Scriptable obj = (Scriptable)args[args.length - 1];
        ClassSignature sig = new ClassSignature(superClass, interfaces, obj);
        Class adapterClass = (Class)generatedClasses.get(sig);
        if (adapterClass == null) {
            String adapterName;
            Hashtable hashtable = generatedClasses;
            synchronized (hashtable) {
                adapterName = "adapter" + serial++;
            }
            byte[] code = JavaAdapter.createAdapterCode(cx, obj, adapterName, superClass, interfaces, null);
            adapterClass = JavaAdapter.loadAdapterClass(cx, adapterName, code);
            generatedClasses.put(sig, adapterClass);
        }
        Class[] ctorParms = new Class[]{class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = JavaAdapter.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable};
        Object[] ctorArgs = new Object[]{obj};
        Object adapter = adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        return JavaAdapter.getAdapterSelf(adapterClass, adapter);
    }

    public static Object createAdapterClass(Class superClass, Class[] interfaces, Scriptable obj, Scriptable self) throws ClassNotFoundException {
        ClassSignature sig = new ClassSignature(superClass, interfaces, obj);
        Class adapterClass = (Class)generatedClasses.get(sig);
        if (adapterClass == null) {
            String adapterName;
            Hashtable hashtable = generatedClasses;
            synchronized (hashtable) {
                adapterName = "adapter" + serial++;
            }
            Context cx = Context.enter();
            try {
                byte[] code = JavaAdapter.createAdapterCode(cx, obj, adapterName, superClass, interfaces, null);
                adapterClass = JavaAdapter.loadAdapterClass(cx, adapterName, code);
                generatedClasses.put(sig, adapterClass);
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            {
            }
        }
        try {
            Class[] ctorParms = new Class[]{class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = JavaAdapter.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = JavaAdapter.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable};
            Object[] ctorArgs = new Object[]{obj, self};
            return adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    public static byte[] createAdapterCode(Context cx, Scriptable jsObj, String adapterName, Class superClass, Class[] interfaces, String scriptClassName) {
        int mods;
        Method method;
        int j;
        Method[] methods;
        ClassFileWriter cfw = new ClassFileWriter(adapterName, superClass.getName(), "<adapter>");
        cfw.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        cfw.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int interfacesCount = interfaces == null ? 0 : interfaces.length;
        int i = 0;
        while (i < interfacesCount) {
            if (interfaces[i] != null) {
                cfw.addInterface(interfaces[i].getName());
            }
            ++i;
        }
        String superName = superClass.getName().replace('.', '/');
        JavaAdapter.generateCtor(cfw, adapterName, superName);
        JavaAdapter.generateSerialCtor(cfw, adapterName, superName);
        if (scriptClassName != null) {
            JavaAdapter.generateEmptyCtor(cfw, adapterName, superName, scriptClassName);
        }
        ObjToIntMap generatedOverrides = new ObjToIntMap();
        ObjToIntMap generatedMethods = new ObjToIntMap();
        int i2 = 0;
        while (i2 < interfacesCount) {
            methods = interfaces[i2].getMethods();
            j = 0;
            while (j < methods.length) {
                block21: {
                    method = methods[j];
                    mods = method.getModifiers();
                    if (!Modifier.isStatic(mods) && !Modifier.isFinal(mods) && jsObj != null) {
                        String methodName;
                        String methodKey;
                        if (!ScriptableObject.hasProperty(jsObj, method.getName())) {
                            try {
                                superClass.getMethod(method.getName(), method.getParameterTypes());
                                break block21;
                            }
                            catch (NoSuchMethodException e) {
                                // empty catch block
                            }
                        }
                        if (!generatedOverrides.has(methodKey = (methodName = method.getName()) + JavaAdapter.getMethodSignature(method))) {
                            JavaAdapter.generateMethod(cfw, adapterName, methodName, method.getParameterTypes(), method.getReturnType());
                            generatedOverrides.put(methodKey, 0);
                            generatedMethods.put(methodName, 0);
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        methods = superClass.getMethods();
        j = 0;
        while (j < methods.length) {
            boolean isAbstractMethod;
            method = methods[j];
            mods = method.getModifiers();
            if (!Modifier.isStatic(mods) && !Modifier.isFinal(mods) && ((isAbstractMethod = Modifier.isAbstract(mods)) || jsObj != null && ScriptableObject.hasProperty(jsObj, method.getName()))) {
                String methodName = method.getName();
                String methodSignature = JavaAdapter.getMethodSignature(method);
                String methodKey = methodName + methodSignature;
                if (!generatedOverrides.has(methodKey)) {
                    JavaAdapter.generateMethod(cfw, adapterName, methodName, method.getParameterTypes(), method.getReturnType());
                    generatedOverrides.put(methodKey, 0);
                    generatedMethods.put(methodName, 0);
                }
                if (!isAbstractMethod) {
                    JavaAdapter.generateSuper(cfw, adapterName, superName, methodName, methodSignature, method.getParameterTypes(), method.getReturnType());
                }
            }
            ++j;
        }
        Scriptable o = jsObj;
        while (o != null) {
            Object[] ids = jsObj.getIds();
            int j2 = 0;
            while (j2 < ids.length) {
                block22: {
                    int length;
                    String id;
                    block24: {
                        Object f;
                        block23: {
                            if (!(ids[j2] instanceof String) || generatedMethods.has(id = (String)ids[j2])) break block22;
                            f = o.get(id, o);
                            if (!(f instanceof Function)) break block23;
                            Function p = (Function)f;
                            length = (int)Context.toNumber(ScriptableObject.getProperty((Scriptable)p, "length"));
                            break block24;
                        }
                        if (!(f instanceof FunctionNode)) break block22;
                        length = ((FunctionNode)f).getVariableTable().getParameterCount();
                    }
                    Class[] parms = new Class[length];
                    int k = 0;
                    while (k < length) {
                        parms[k] = class$java$lang$Object == null ? JavaAdapter.class$("java.lang.Object") : class$java$lang$Object;
                        ++k;
                    }
                    JavaAdapter.generateMethod(cfw, adapterName, id, parms, class$java$lang$Object == null ? JavaAdapter.class$("java.lang.Object") : class$java$lang$Object);
                }
                ++j2;
            }
            o = o.getPrototype();
        }
        return cfw.toByteArray();
    }

    private static Class loadAdapterClass(Context cx, String className, byte[] classBytes) {
        GeneratedClassLoader loader;
        ClassLoader parentLoader = cx.getClass().getClassLoader();
        SecurityController sc = cx.getSecurityController();
        if (sc == null) {
            loader = cx.createClassLoader(parentLoader);
        } else {
            Object securityDomain = sc.getDynamicSecurityDomain(null);
            loader = sc.createClassLoader(parentLoader, securityDomain);
        }
        Class result = loader.defineClass(className, classBytes);
        loader.linkClass(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object callMethod(Scriptable object, Object thisObj, String methodId, Object[] args) {
        Object object2;
        block6: {
            Scriptable scriptable;
            block5: {
                Context cx = Context.enter();
                try {
                    try {
                        Object fun = ScriptableObject.getProperty(object, methodId);
                        if (fun == Scriptable.NOT_FOUND) {
                            scriptable = Undefined.instance;
                            Object var8_9 = null;
                            break block5;
                        }
                        object2 = ScriptRuntime.call(cx, fun, thisObj, args, object);
                        break block6;
                    }
                    catch (JavaScriptException ex) {
                        throw WrappedException.wrapException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    Context.exit();
                    throw throwable;
                }
            }
            Context.exit();
            return scriptable;
        }
        Object var8_10 = null;
        Context.exit();
        return object2;
    }

    public static Scriptable toObject(Object value, Scriptable scope, Class staticType) {
        Scriptable scriptable;
        Context cx = Context.enter();
        try {
            scriptable = ScriptRuntime.toObject(cx, scope, value, staticType);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return scriptable;
    }

    private static void generateCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, superName, "<init>", "()", "V");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)43);
        cfw.add((byte)42);
        cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "setAdapterProto", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static void generateSerialCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, superName, "<init>", "()", "V");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)44);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static void generateEmptyCtor(ClassFileWriter cfw, String adapterName, String superName, String scriptClassName) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, superName, "<init>", "()", "V");
        cfw.add((byte)-69, scriptClassName);
        cfw.add((byte)89);
        cfw.add((byte)-73, scriptClassName, "<init>", "()", "V");
        cfw.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", "runScript", "(Lorg/mozilla/javascript/Script;)", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)43);
        cfw.add((byte)42);
        cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "setAdapterProto", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static int generateWrapParam(ClassFileWriter cfw, int paramOffset, Class paramType) {
        if (paramType.equals(Boolean.TYPE)) {
            cfw.add((byte)-69, "java/lang/Boolean");
            cfw.add((byte)89);
            cfw.add((byte)21, paramOffset++);
            cfw.add((byte)-73, "java/lang/Boolean", "<init>", "(Z)", "V");
        } else if (paramType.equals(Character.TYPE)) {
            cfw.add((byte)-69, "java/lang/String");
            cfw.add((byte)89);
            cfw.add((byte)4);
            cfw.add((byte)-68, 5);
            cfw.add((byte)89);
            cfw.add((byte)3);
            cfw.add((byte)21, paramOffset++);
            cfw.add((byte)85);
            cfw.add((byte)-73, "java/lang/String", "<init>", "([C)", "V");
        } else {
            cfw.add((byte)-69, "java/lang/Double");
            cfw.add((byte)89);
            String typeName = paramType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add((byte)21, paramOffset++);
                    cfw.add((byte)-121);
                    break;
                }
                case 'l': {
                    cfw.add((byte)22, paramOffset);
                    cfw.add((byte)-118);
                    paramOffset += 2;
                    break;
                }
                case 'f': {
                    cfw.add((byte)23, paramOffset++);
                    cfw.add((byte)-115);
                    break;
                }
                case 'd': {
                    cfw.add((byte)24, paramOffset);
                    paramOffset += 2;
                }
            }
            cfw.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
        }
        return paramOffset;
    }

    private static void generateReturnResult(ClassFileWriter cfw, Class retType) {
        if (retType.equals(Boolean.TYPE)) {
            cfw.add((byte)-72, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)", "Z");
            cfw.add((byte)-84);
        } else if (retType.equals(Character.TYPE)) {
            cfw.add((byte)-72, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            cfw.add((byte)3);
            cfw.add((byte)-74, "java/lang/String", "charAt", "(I)", "C");
            cfw.add((byte)-84);
        } else if (retType.isPrimitive()) {
            cfw.add((byte)-72, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)", "D");
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add((byte)-114);
                    cfw.add((byte)-84);
                    break;
                }
                case 'l': {
                    cfw.add((byte)-113);
                    cfw.add((byte)-83);
                    break;
                }
                case 'f': {
                    cfw.add((byte)-112);
                    cfw.add((byte)-82);
                    break;
                }
                case 'd': {
                    cfw.add((byte)-81);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + retType.toString());
                }
            }
        } else {
            String retTypeStr = retType.getName();
            cfw.addLoadConstant(retTypeStr);
            cfw.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
            cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)", "Ljava/lang/Object;");
            cfw.add((byte)-64, retTypeStr.replace('.', '/'));
            cfw.add((byte)-80);
        }
    }

    private static void generateMethod(ClassFileWriter cfw, String genName, String methodName, Class[] parms, Class returnType) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int arrayLocal = 1;
        int i = 0;
        while (i < parms.length) {
            Class type = parms[i];
            JavaAdapter.appendTypeString(sb, type);
            arrayLocal = type.equals(Long.TYPE) || type.equals(Double.TYPE) ? (int)((short)(arrayLocal + 2)) : (int)((short)(arrayLocal + 1));
            ++i;
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, returnType);
        String methodSignature = sb.toString();
        cfw.startMethod(methodName, methodSignature, (short)1);
        cfw.add((byte)16, (byte)parms.length);
        cfw.add((byte)-67, "java/lang/Object");
        cfw.add((byte)58, arrayLocal);
        short scopeLocal = (short)(arrayLocal + 1);
        boolean loadedScope = false;
        int paramOffset = 1;
        int i2 = 0;
        while (i2 < parms.length) {
            cfw.add((byte)25, arrayLocal);
            cfw.add((byte)16, i2);
            if (parms[i2].isPrimitive()) {
                paramOffset = JavaAdapter.generateWrapParam(cfw, paramOffset, parms[i2]);
            } else {
                cfw.add((byte)25, paramOffset++);
                if (!loadedScope) {
                    cfw.add((byte)42);
                    cfw.add((byte)-76, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
                    cfw.add((byte)58, scopeLocal);
                    loadedScope = true;
                }
                cfw.add((byte)25, scopeLocal);
                cfw.addLoadConstant(parms[i2].getName());
                cfw.add((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
                cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "toObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Class;)", "Lorg/mozilla/javascript/Scriptable;");
            }
            cfw.add((byte)83);
            ++i2;
        }
        cfw.add((byte)42);
        cfw.add((byte)-76, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)-76, genName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.addLoadConstant(methodName);
        cfw.add((byte)25, arrayLocal);
        cfw.add((byte)-72, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        if (returnType.equals(Void.TYPE)) {
            cfw.add((byte)87);
            cfw.add((byte)-79);
        } else {
            JavaAdapter.generateReturnResult(cfw, returnType);
        }
        cfw.stopMethod((short)(scopeLocal + 3), null);
    }

    private static int generatePushParam(ClassFileWriter cfw, int paramOffset, Class paramType) {
        String typeName = paramType.getName();
        switch (typeName.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                cfw.add((byte)21, paramOffset++);
                break;
            }
            case 'l': {
                cfw.add((byte)22, paramOffset);
                paramOffset += 2;
                break;
            }
            case 'f': {
                cfw.add((byte)23, paramOffset++);
                break;
            }
            case 'd': {
                cfw.add((byte)24, paramOffset);
                paramOffset += 2;
            }
        }
        return paramOffset;
    }

    private static void generatePopResult(ClassFileWriter cfw, Class retType) {
        if (retType.isPrimitive()) {
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    cfw.add((byte)-84);
                    break;
                }
                case 'l': {
                    cfw.add((byte)-83);
                    break;
                }
                case 'f': {
                    cfw.add((byte)-82);
                    break;
                }
                case 'd': {
                    cfw.add((byte)-81);
                }
            }
        } else {
            cfw.add((byte)-80);
        }
    }

    private static void generateSuper(ClassFileWriter cfw, String genName, String superName, String methodName, String methodSignature, Class[] parms, Class returnType) {
        cfw.startMethod("super$" + methodName, methodSignature, (short)1);
        cfw.add((byte)25, 0);
        int paramOffset = 1;
        int i = 0;
        while (i < parms.length) {
            if (parms[i].isPrimitive()) {
                paramOffset = JavaAdapter.generatePushParam(cfw, paramOffset, parms[i]);
            } else {
                cfw.add((byte)25, paramOffset++);
            }
            ++i;
        }
        int rightParen = methodSignature.indexOf(41);
        cfw.add((byte)-73, superName, methodName, methodSignature.substring(0, rightParen + 1), methodSignature.substring(rightParen + 1));
        Class retType = returnType;
        if (!retType.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(cfw, retType);
        } else {
            cfw.add((byte)-79);
        }
        cfw.stopMethod((short)(paramOffset + 1), null);
    }

    private static String getMethodSignature(Method method) {
        Class<?>[] parms = method.getParameterTypes();
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int i = 0;
        while (i < parms.length) {
            Class<?> type = parms[i];
            JavaAdapter.appendTypeString(sb, type);
            ++i;
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, method.getReturnType());
        return sb.toString();
    }

    private static StringBuffer appendTypeString(StringBuffer sb, Class type) {
        while (type.isArray()) {
            sb.append('[');
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                sb.append('Z');
            } else if (type.equals(Long.TYPE)) {
                sb.append('J');
            } else {
                String typeName = type.getName();
                sb.append(Character.toUpperCase(typeName.charAt(0)));
            }
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
        return sb;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        generatedClasses = new Hashtable(7);
    }

    static class ClassSignature {
        Class mSuperClass;
        Class[] mInterfaces;
        Object[] mProperties;

        ClassSignature(Class superClass, Class[] interfaces, Scriptable jsObj) {
            this.mSuperClass = superClass;
            this.mInterfaces = interfaces;
            this.mProperties = ScriptableObject.getPropertyIds(jsObj);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassSignature) {
                ClassSignature sig = (ClassSignature)obj;
                if (this.mSuperClass == sig.mSuperClass) {
                    int i;
                    Class[] interfaces = sig.mInterfaces;
                    if (this.mInterfaces != interfaces) {
                        if (this.mInterfaces == null || interfaces == null) {
                            return false;
                        }
                        if (this.mInterfaces.length != interfaces.length) {
                            return false;
                        }
                        i = 0;
                        while (i < interfaces.length) {
                            if (this.mInterfaces[i] != interfaces[i]) {
                                return false;
                            }
                            ++i;
                        }
                    }
                    if (this.mProperties.length != sig.mProperties.length) {
                        return false;
                    }
                    i = 0;
                    while (i < this.mProperties.length) {
                        if (!this.mProperties[i].equals(sig.mProperties[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.mSuperClass.hashCode();
        }
    }
}

