/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.image.ColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PointOpImage;

final class BandSelectOpImage
extends PointOpImage {
    private boolean areDataCopied;
    private int[] bandIndices;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int[] nArray) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = nArray.length;
        SampleModel sampleModel2 = null;
        if (sampleModel instanceof SinglePixelPackedSampleModel && n < 3) {
            int[] nArray2;
            int n2 = sampleModel.getWidth();
            int n3 = sampleModel.getHeight();
            int n4 = sampleModel.getWidth() * n;
            if (n == 1) {
                int[] nArray3 = new int[1];
                nArray2 = nArray3;
                nArray3[0] = 0;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = 0;
                nArray2 = nArray4;
                nArray4[1] = 1;
            }
            sampleModel2 = new PixelInterleavedSampleModel(0, n2, n3, n, n4, nArray2);
        } else {
            sampleModel2 = sampleModel.createSubsetSampleModel(nArray);
        }
        imageLayout2.setSampleModel(sampleModel2);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
            imageLayout2.unsetValid(512);
        }
        imageLayout2.setTileGridXOffset(renderedImage.getTileGridXOffset());
        imageLayout2.setTileGridYOffset(renderedImage.getTileGridYOffset());
        imageLayout2.setTileWidth(renderedImage.getTileWidth());
        imageLayout2.setTileHeight(renderedImage.getTileHeight());
        return imageLayout2;
    }

    public BandSelectOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int[] nArray) {
        super(OpImage.vectorize(renderedImage), BandSelectOpImage.layoutHelper(imageLayout, renderedImage, nArray), map, true);
        this.areDataCopied = renderedImage.getSampleModel() instanceof SinglePixelPackedSampleModel && nArray.length < 3;
        this.bandIndices = (int[])nArray.clone();
    }

    public boolean computesUniqueTiles() {
        return this.areDataCopied;
    }

    public Raster computeTile(int n, int n2) {
        Raster raster = this.getSourceImage(0).getTile(n, n2);
        if (this.areDataCopied) {
            raster = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), this.bandIndices);
            WritableRaster writableRaster = this.createTile(n, n2);
            writableRaster.setRect(raster);
            return writableRaster;
        }
        return raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), this.bandIndices);
    }

    public Raster getTile(int n, int n2) {
        return this.computeTile(n, n2);
    }
}

