/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.Reference;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.Expression;

public class Parameter {
    public static final Parameter[] EMPTY_ARRAY = new Parameter[0];
    private String type;
    private String name;
    private boolean dynamicType;
    private Expression defaultValue;
    private String realType;
    private final boolean hasDefaultValue;

    public Parameter(String name) {
        this.name = null;
        this.hasDefaultValue = false;
        this.type = "java.lang.Object";
        this.dynamicType = true;
    }

    public Parameter(String type, String name) {
        this.name = MethodNode.ensureJavaTypeNameSyntax(name);
        this.type = type;
        this.hasDefaultValue = false;
        if (type == null || type.length() == 0) {
            this.type = "java.lang.Object";
            this.dynamicType = true;
        }
    }

    public Parameter(String type, String name, Expression defaultValue) {
        this.name = MethodNode.ensureJavaTypeNameSyntax(name);
        this.type = type;
        this.defaultValue = defaultValue;
        this.hasDefaultValue = true;
        if (type == null || type.length() == 0) {
            this.type = "java.lang.Object";
            this.dynamicType = true;
        }
    }

    public String toString() {
        return super.toString() + "[name:" + this.name + (this.type == null ? "" : " type: " + this.type) + ", hasDefaultValue: " + this.hasDefaultValue() + "]";
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isDynamicType() {
        return this.dynamicType;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void makeReference() {
        this.realType = this.type;
        this.type = Reference.class.getName();
    }

    public String getRealType() {
        return this.realType;
    }
}

