/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.TypeMismatchException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.runtime.InvokerHelper;

public class MetaBeanProperty
extends MetaProperty {
    private MetaMethod getter;
    private MetaMethod setter;

    public MetaBeanProperty(String name, Class type, MetaMethod getter, MetaMethod setter) {
        super(name, type);
        this.getter = getter;
        this.setter = setter;
    }

    public Object getProperty(Object object) throws Exception {
        if (this.getter == null) {
            throw new GroovyRuntimeException("Cannot read write-only property: " + this.name);
        }
        return this.getter.invoke(object, MetaClass.EMPTY_ARRAY);
    }

    public void setProperty(Object object, Object newValue) {
        if (this.setter == null) {
            throw new GroovyRuntimeException("Cannot set read-only property: " + this.name);
        }
        try {
            newValue = this.getType() == String.class && !(newValue instanceof String) ? newValue.toString() : MetaBeanProperty.coercePrimitiveValue(newValue, this.getType());
            this.setter.invoke(object, new Object[]{newValue});
        }
        catch (IllegalArgumentException e) {
            try {
                newValue = InvokerHelper.asType(newValue, this.getType());
                this.setter.invoke(object, new Object[]{newValue});
            }
            catch (Exception ex) {
                throw new TypeMismatchException("The property '" + this.toName(object.getClass()) + "." + this.name + "' can not refer to the value '" + newValue + "' (type " + this.toName(newValue.getClass()) + "), because it is of the type " + this.toName(this.getType()) + ". The reason is from java.lang.IllegalArgumentException.");
            }
        }
        catch (ClassCastException e) {
            try {
                newValue = InvokerHelper.asType(newValue, this.getType());
                this.setter.invoke(object, new Object[]{newValue});
            }
            catch (Exception ex) {
                throw new TypeMismatchException("The property '" + this.toName(object.getClass()) + "." + this.name + "' can not refer to the value '" + newValue + "' (type " + this.toName(newValue.getClass()) + "), because it is of the type " + this.toName(this.getType()) + ". The reason is from java.lang.ClassCastException.");
            }
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Cannot set property: " + this.name + " reason: " + e.getMessage(), e);
        }
    }

    protected static Object coercePrimitiveValue(Object src, Class target) {
        Object newValue = src;
        if (newValue instanceof BigDecimal) {
            if (target == BigInteger.class) {
                newValue = ((BigDecimal)newValue).unscaledValue();
            } else if (target == Double.class) {
                newValue = new Double(((BigDecimal)newValue).doubleValue());
            } else if (target == Float.class) {
                newValue = new Float(((BigDecimal)newValue).floatValue());
            } else if (target == Long.class) {
                newValue = new Long(((BigDecimal)newValue).longValue());
            } else if (target == Integer.class) {
                newValue = new Integer(((BigDecimal)newValue).intValue());
            } else if (target == Short.class) {
                newValue = new Short((short)((BigDecimal)newValue).intValue());
            } else if (target == Byte.class) {
                newValue = new Byte((byte)((BigDecimal)newValue).intValue());
            } else if (target == Character.class) {
                newValue = new Character((char)((BigDecimal)newValue).intValue());
            }
        } else if (newValue instanceof BigInteger) {
            if (target == BigDecimal.class) {
                newValue = new BigDecimal((BigInteger)newValue);
            } else if (target == Double.class) {
                newValue = new Double(((BigInteger)newValue).doubleValue());
            } else if (target == Float.class) {
                newValue = new Float(((BigInteger)newValue).floatValue());
            } else if (target == Long.class) {
                newValue = new Long(((BigInteger)newValue).longValue());
            } else if (target == Integer.class) {
                newValue = new Integer(((BigInteger)newValue).intValue());
            } else if (target == Short.class) {
                newValue = new Short((short)((BigInteger)newValue).intValue());
            } else if (target == Byte.class) {
                newValue = new Byte((byte)((BigInteger)newValue).intValue());
            } else if (target == Character.class) {
                newValue = new Character((char)((BigInteger)newValue).intValue());
            }
        } else if (newValue instanceof Long) {
            if (target == Integer.class) {
                newValue = new Integer(((Long)newValue).intValue());
            } else if (target == Short.class) {
                newValue = new Short(((Long)newValue).shortValue());
            } else if (target == Byte.class) {
                newValue = new Byte(((Long)newValue).byteValue());
            } else if (target == Character.class) {
                newValue = new Character((char)((Long)newValue).intValue());
            } else if (target == BigInteger.class) {
                newValue = new BigInteger("" + newValue);
            } else if (target == BigDecimal.class) {
                newValue = new BigDecimal("" + newValue);
            }
        } else if (newValue instanceof Integer) {
            if (target == Double.class) {
                newValue = new Double(((Integer)newValue).intValue());
            } else if (target == Float.class) {
                newValue = new Float(((Integer)newValue).floatValue());
            } else if (target == Long.class) {
                newValue = new Long(((Integer)newValue).intValue());
            } else if (target == Short.class) {
                newValue = new Short(((Integer)newValue).shortValue());
            } else if (target == Byte.class) {
                newValue = new Byte(((Integer)newValue).byteValue());
            } else if (target == Character.class) {
                newValue = new Character((char)((Integer)newValue).intValue());
            } else if (target == BigDecimal.class) {
                newValue = new BigDecimal("" + newValue);
            } else if (target == BigInteger.class) {
                newValue = new BigInteger("" + newValue);
            }
        } else if (newValue instanceof Short) {
            if (target == Double.class) {
                newValue = new Double(((Short)newValue).shortValue());
            } else if (target == Float.class) {
                newValue = new Float(((Short)newValue).shortValue());
            } else if (target == Long.class) {
                newValue = new Long(((Short)newValue).shortValue());
            } else if (target == Integer.class) {
                newValue = new Integer(((Short)newValue).shortValue());
            } else if (target == Byte.class) {
                newValue = new Byte((byte)((Short)newValue).shortValue());
            } else if (target == Character.class) {
                newValue = new Character((char)((Short)newValue).shortValue());
            } else if (target == BigDecimal.class) {
                newValue = new BigDecimal("" + newValue);
            } else if (target == BigInteger.class) {
                newValue = new BigInteger("" + newValue);
            }
        } else if (newValue instanceof Byte) {
            if (target == Double.class) {
                newValue = new Double(((Byte)newValue).byteValue());
            } else if (target == Float.class) {
                newValue = new Float(((Byte)newValue).byteValue());
            } else if (target == Long.class) {
                newValue = new Long(((Byte)newValue).byteValue());
            } else if (target == Integer.class) {
                newValue = new Integer(((Byte)newValue).byteValue());
            } else if (target == Short.class) {
                newValue = new Short(((Byte)newValue).byteValue());
            } else if (target == Character.class) {
                newValue = new Character((char)((Byte)newValue).byteValue());
            } else if (target == BigDecimal.class) {
                newValue = new BigDecimal("" + newValue);
            } else if (target == BigInteger.class) {
                newValue = new BigInteger("" + newValue);
            }
        } else if (newValue instanceof Character) {
            if (target == Double.class) {
                newValue = new Double(((Character)newValue).charValue() & 0xFFFF);
            } else if (target == Long.class) {
                newValue = new Long(((Character)newValue).charValue());
            } else if (target == Integer.class) {
                newValue = new Integer(((Character)newValue).charValue());
            } else if (target == Short.class) {
                newValue = new Short((short)((Character)newValue).charValue());
            } else if (target == BigDecimal.class) {
                newValue = new BigDecimal("" + (((Character)newValue).charValue() & 0xFFFF));
            } else if (target == BigInteger.class) {
                newValue = new BigInteger("" + (((Character)newValue).charValue() & 0xFFFF));
            } else if (target == String.class) {
                newValue = new String("" + newValue);
            }
        }
        return newValue;
    }

    private String toName(Class c) {
        String s = c.toString();
        if (s.startsWith("class ") && s.length() > 6) {
            return s.substring(6);
        }
        return s;
    }

    public MetaMethod getGetter() {
        return this.getter;
    }

    public MetaMethod getSetter() {
        return this.setter;
    }

    void setGetter(MetaMethod getter) {
        this.getter = getter;
    }

    void setSetter(MetaMethod setter) {
        this.setter = setter;
    }
}

