/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Object invokeMethod(Method method, Object target) throws RuntimeException {
        return ReflectionUtils.invokeMethod(method, target, null);
    }

    public static Object invokeMethod(Method method, Object target, Object[] args) throws RuntimeException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
    }

    private static void handleInvocationTargetException(InvocationTargetException ex) {
        if (ex.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)ex.getTargetException();
        }
        if (ex.getTargetException() instanceof Error) {
            throw (Error)ex.getTargetException();
        }
        throw new IllegalStateException("Unexpected exception thrown by method - " + ex.getTargetException().getClass().getName() + ": " + ex.getTargetException().getMessage());
    }
}

