/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.FlowSessionStatus;

public class MockFlowSession
implements FlowSession {
    private Flow definition;
    private State state;
    private FlowSessionStatus status = FlowSessionStatus.CREATED;
    private MutableAttributeMap scope = new LocalAttributeMap();
    private MutableAttributeMap flashMap = new LocalAttributeMap();
    private FlowSession parent;

    public MockFlowSession() {
        this.setDefinition(new Flow("mockFlow"));
        ViewState state = new ViewState(this.definition, "mockState");
        this.setStatus(FlowSessionStatus.ACTIVE);
        this.setState(state);
    }

    public MockFlowSession(Flow flow) {
        this.setDefinition(flow);
    }

    public MockFlowSession(Flow flow, AttributeMap input) {
        this.setDefinition(flow);
        this.scope.putAll(input);
    }

    public FlowDefinition getDefinition() {
        return this.definition;
    }

    public StateDefinition getState() {
        return this.state;
    }

    public FlowSessionStatus getStatus() {
        return this.status;
    }

    public MutableAttributeMap getScope() {
        return this.scope;
    }

    public MutableAttributeMap getFlashMap() {
        return this.flashMap;
    }

    public FlowSession getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setDefinition(Flow flow) {
        this.definition = flow;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setStatus(FlowSessionStatus status) {
        this.status = status;
    }

    public void setScope(MutableAttributeMap scope) {
        this.scope = scope;
    }

    public void setParent(FlowSession parent) {
        this.parent = parent;
    }

    public Flow getDefinitionInternal() {
        return this.definition;
    }

    public State getStateInternal() {
        return this.state;
    }
}

