/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.FlowRequestHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;

public class FlowController
extends AbstractController
implements InitializingBean {
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentHandler argumentHandler = new RequestParameterFlowExecutorArgumentHandler();

    public FlowController() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentHandler.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
        Assert.notNull((Object)this.argumentHandler, (String)"The argument handler property is required");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletExternalContext context = new ServletExternalContext(this.getServletContext(), request, response);
        ResponseInstruction responseInstruction = this.createRequestHandler().handleFlowRequest(context);
        return this.toModelAndView(responseInstruction, context);
    }

    protected FlowRequestHandler createRequestHandler() {
        return new FlowRequestHandler(this.getFlowExecutor(), this.getArgumentHandler());
    }

    protected ModelAndView toModelAndView(ResponseInstruction response, ExternalContext context) {
        if (response.isApplicationView()) {
            ApplicationView view = (ApplicationView)response.getViewSelection();
            HashMap model = new HashMap(view.getModel());
            this.argumentHandler.exposeFlowExecutionContext(response.getFlowExecutionKey(), response.getFlowExecutionContext(), model);
            return new ModelAndView(view.getViewName(), model);
        }
        if (response.isFlowDefinitionRedirect()) {
            String flowUrl = this.argumentHandler.createFlowDefinitionUrl((FlowDefinitionRedirect)response.getViewSelection(), context);
            return new ModelAndView((View)new RedirectView(flowUrl));
        }
        if (response.isFlowExecutionRedirect()) {
            String flowExecutionUrl = this.argumentHandler.createFlowExecutionUrl(response.getFlowExecutionKey(), response.getFlowExecutionContext(), context);
            return new ModelAndView((View)new RedirectView(flowExecutionUrl));
        }
        if (response.isExternalRedirect()) {
            ExternalRedirect redirect = (ExternalRedirect)response.getViewSelection();
            String externalUrl = this.argumentHandler.createExternalUrl(redirect, response.getFlowExecutionKey(), context);
            return new ModelAndView((View)new RedirectView(externalUrl));
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }
}

