/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.impl.ConversationContainer;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.springframework.webflow.conversation.impl.ConversationLockFactory;

class ContainedConversation
implements Conversation,
Serializable {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager == null ? (class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager = ContainedConversation.class$("org.springframework.webflow.conversation.impl.SessionBindingConversationManager")) : class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager));
    private ConversationContainer container;
    private ConversationId id;
    private transient ConversationLock lock;
    private Map attributes;
    static /* synthetic */ Class class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager;

    public ContainedConversation(ConversationContainer container, ConversationId id) {
        this.container = container;
        this.id = id;
        this.lock = ConversationLockFactory.createLock();
        this.attributes = new HashMap();
    }

    public ConversationId getId() {
        return this.id;
    }

    public void lock() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locking conversation " + this.id));
        }
        this.lock.lock();
    }

    public Object getAttribute(Object name) {
        return this.attributes.get(name);
    }

    public void putAttribute(Object name, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Putting conversation attribute '" + name + "' with value " + value));
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(Object name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing conversation attribute '" + name + "'"));
        }
        this.attributes.remove(name);
    }

    public void end() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending conversation " + this.id));
        }
        this.container.removeConversation(this.getId());
    }

    public void unlock() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unlocking conversation " + this.id));
        }
        this.lock.unlock();
    }

    public String toString() {
        return this.getId().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainedConversation)) {
            return false;
        }
        return this.id.equals(((ContainedConversation)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = ConversationLockFactory.createLock();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

